/*
 * Decompiled with CFR 0.152.
 */
package com.bisnode.opa.testformats.opa;

import com.bisnode.opa.OpaTestResults;
import com.bisnode.opa.testformats.opa.OpaVerboseSummaryFactory;
import com.bisnode.opa.testformats.opa.Summarizable;
import com.bisnode.opa.testformats.opa.TestCase;
import java.util.List;

public class OpaVerboseSummary
implements Summarizable {
    private static final String SEPARATOR = "--------------------------------------------------------------------------------";
    private final List<TestCase> testCases;

    public static OpaVerboseSummary of(OpaTestResults opaTestResults) {
        return new OpaVerboseSummaryFactory(opaTestResults.getTestCases()).create();
    }

    OpaVerboseSummary(List<TestCase> testCases) {
        this.testCases = testCases;
    }

    @Override
    public String summary() {
        StringBuilder summary = new StringBuilder().append("SUMMARY").append('\n').append(SEPARATOR).append('\n');
        this.testCases.stream().map(TestCase::summary).map(this::withNewLine).forEach(summary::append);
        summary.append(SEPARATOR).append('\n');
        if (this.passedCount() > 0L) {
            summary.append(String.format("PASS: %d/%d\n", this.passedCount(), this.total()));
        }
        if (this.failedCount() > 0L) {
            summary.append(String.format("FAIL: %d/%d\n", this.failedCount(), this.total()));
        }
        if (this.errorCount() > 0L) {
            summary.append(String.format("ERROR: %d/%d\n", this.errorCount(), this.total()));
        }
        return summary.toString();
    }

    private String withNewLine(String testCaseSummary) {
        return testCaseSummary.concat("\n");
    }

    private long passedCount() {
        return this.testCases.stream().filter(TestCase::passed).count();
    }

    private long failedCount() {
        return this.testCases.stream().filter(TestCase::isFailure).count();
    }

    private long errorCount() {
        return this.testCases.stream().filter(TestCase::isError).count();
    }

    private int total() {
        return this.testCases.size();
    }
}

