/*
 * Decompiled with CFR 0.152.
 */
package com.bisnode.opa.testformats.opa;

import com.bisnode.opa.OpaTestCase;
import com.bisnode.opa.testformats.opa.OpaVerboseSummary;
import com.bisnode.opa.testformats.opa.TestCase;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class OpaVerboseSummaryFactory {
    private final List<OpaTestCase> opaTestCases;

    OpaVerboseSummaryFactory(List<OpaTestCase> opaTestCases) {
        this.opaTestCases = opaTestCases;
    }

    OpaVerboseSummary create() {
        TestNameOccurrenceCounter testNameOccurrenceCounter = new TestNameOccurrenceCounter();
        List<TestCase> summarizableTestCases = this.getTestsInExecutionOrder().stream().map(opaTestCase -> TestCase.of(opaTestCase, testNameOccurrenceCounter.getAndIncrement(opaTestCase.getName()))).collect(Collectors.toList());
        return new OpaVerboseSummary(summarizableTestCases);
    }

    @NotNull
    private List<OpaTestCase> getTestsInExecutionOrder() {
        LinkedHashMap groupedTests = this.opaTestCases.stream().collect(Collectors.groupingBy(OpaTestCase::getName, LinkedHashMap::new, Collectors.toList()));
        groupedTests.values().forEach(Collections::reverse);
        return groupedTests.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static class TestNameOccurrenceCounter {
        private final Map<String, Integer> testNameOccurences = new HashMap<String, Integer>();

        private TestNameOccurrenceCounter() {
        }

        int getAndIncrement(@NotNull String testName) {
            if (!this.testNameOccurences.containsKey(testName)) {
                this.testNameOccurences.put(testName, 1);
                return 0;
            }
            return this.testNameOccurences.compute(testName, (name, count) -> {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                return n;
            });
        }
    }
}

