/*
 * Decompiled with CFR 0.152.
 */
package com.bisnode.opa.testformats.opa;

import com.bisnode.opa.OpaError;
import com.bisnode.opa.OpaTestCase;
import com.bisnode.opa.testformats.opa.Summarizable;
import com.bisnode.opa.testformats.opa.TestDuration;
import java.util.Objects;
import java.util.Optional;

class TestCase
implements Summarizable {
    private final OpaTestCase opaTestCase;
    private final int testNameOccurrence;
    private final TestDuration testDuration;

    private TestCase(OpaTestCase opaTestCase, int testNameOccurrence, TestDuration testDuration) {
        this.opaTestCase = opaTestCase;
        this.testNameOccurrence = testNameOccurrence;
        this.testDuration = testDuration;
    }

    static TestCase of(OpaTestCase opaTestCase, int testNameOccurrence) {
        return new TestCase(opaTestCase, testNameOccurrence, TestDuration.ofNanos(opaTestCase.getDuration()));
    }

    boolean isFailure() {
        return Optional.ofNullable(this.opaTestCase.getFail()).map(Boolean.TRUE::equals).orElse(false);
    }

    boolean isError() {
        return Objects.nonNull(this.opaTestCase.getError());
    }

    boolean passed() {
        return !this.isFailure() && !this.isError();
    }

    @Override
    public String summary() {
        OpaError error;
        StringBuilder summary = new StringBuilder(this.opaTestCase.getPackage()).append('.').append(this.opaTestCase.getName());
        if (this.testNameOccurrence != 0) {
            summary.append(String.format("#%02d", this.testNameOccurrence));
        }
        summary.append(": ").append(this.outcome()).append(" (").append(this.testDuration.summary()).append(")");
        if (this.isError() && Objects.nonNull(error = this.opaTestCase.getError())) {
            summary.append("\n  ").append(error.getLocation().getFile()).append(":").append(error.getLocation().getRow()).append(": ").append(error.getCode()).append(": ").append(error.getMessage());
        }
        return summary.toString();
    }

    private String outcome() {
        if (this.isError()) {
            return "ERROR";
        }
        if (this.isFailure()) {
            return "FAIL";
        }
        return "PASS";
    }
}

