/*
 * Decompiled with CFR 0.152.
 */
package com.bisnode.opa.testformats.opa;

import com.bisnode.opa.testformats.opa.Summarizable;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

class TestDuration
implements Summarizable {
    private final long nanos;
    private final DurationUnit durationUnit;
    private static final long NANOS_IN_MINUTE = 60000000000L;
    private static final long NANOS_IN_SECOND = 1000000000L;
    private static final long NANOS_IN_MILLISECOND = 1000000L;
    private static final long NANOS_IN_MICROSECOND = 1000L;

    private TestDuration(long nanos, DurationUnit durationUnit) {
        this.nanos = nanos;
        this.durationUnit = durationUnit;
    }

    static TestDuration ofNanos(long nanos) {
        DurationUnit durationUnit = DurationUnit.ofTimeUnit(TestDuration.biggestTimeUnitFor(nanos));
        return new TestDuration(nanos, durationUnit);
    }

    @Override
    public String summary() {
        return String.format("%s%s", this.durationUnit.getConverter().convert(this.nanos), this.durationUnit.getSuffix());
    }

    private static TimeUnit biggestTimeUnitFor(long nanos) {
        if (nanos > 60000000000L) {
            return TimeUnit.MINUTES;
        }
        if (nanos > 1000000000L) {
            return TimeUnit.SECONDS;
        }
        if (nanos > 1000000L) {
            return TimeUnit.MILLISECONDS;
        }
        if (nanos > 1000L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    private static interface FromNanosConverter {
        public double convert(long var1);
    }

    private static enum DurationUnit {
        MINUTES(TimeUnit.MINUTES, "min", nanos -> (double)nanos / 6.0E10),
        SECONDS(TimeUnit.SECONDS, "s", nanos -> (double)nanos / 1.0E9),
        MILLISECONDS(TimeUnit.MILLISECONDS, "ms", nanos -> (double)nanos / 1000000.0),
        MICROSECONDS(TimeUnit.MICROSECONDS, "\u00b5s", nanos -> (double)nanos / 1000.0),
        NANOSECONDS(TimeUnit.NANOSECONDS, "ns", nanos -> nanos);

        private final TimeUnit timeUnit;
        private final String suffix;
        private final FromNanosConverter converter;

        private DurationUnit(TimeUnit timeUnit, String suffix, FromNanosConverter converter) {
            this.timeUnit = timeUnit;
            this.suffix = suffix;
            this.converter = converter;
        }

        String getSuffix() {
            return this.suffix;
        }

        FromNanosConverter getConverter() {
            return this.converter;
        }

        static DurationUnit ofTimeUnit(TimeUnit timeUnit) {
            return Arrays.stream(DurationUnit.values()).filter(durationUnit -> durationUnit.timeUnit.equals((Object)timeUnit)).findAny().orElse(MINUTES);
        }
    }
}

