/*
 * Decompiled with CFR 0.152.
 */
package com.dumbster.smtp;

import com.dumbster.smtp.ClientSession;
import com.dumbster.smtp.MailMessage;
import com.dumbster.smtp.MailStore;
import com.dumbster.smtp.SocketWrapper;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SmtpServer
implements Runnable {
    public static final int DEFAULT_SMTP_PORT = 25;
    private static final int SERVER_SOCKET_TIMEOUT = 0;
    private static final int MAX_THREADS = 10;
    private volatile MailStore mailStore;
    private volatile boolean stopped = true;
    private volatile boolean ready = false;
    private volatile boolean threaded = false;
    private ServerSocket serverSocket;
    private int port;

    @Override
    public void run() {
        this.stopped = false;
        try {
            this.initializeServerSocket();
            this.serverLoop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.ready = false;
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void initializeServerSocket() throws Exception {
        this.serverSocket = new ServerSocket(this.port);
        this.serverSocket.setSoTimeout(0);
    }

    private void serverLoop() throws IOException {
        int poolSize = this.threaded ? 10 : 1;
        ExecutorService threadExecutor = Executors.newFixedThreadPool(poolSize);
        while (!this.isStopped()) {
            Socket clientSocket;
            try {
                clientSocket = this.clientSocket();
            }
            catch (IOException ex) {
                if (this.isStopped()) break;
                throw ex;
            }
            SocketWrapper source = new SocketWrapper(clientSocket);
            ClientSession session = new ClientSession(source, this.mailStore);
            threadExecutor.execute(session);
        }
        threadExecutor.shutdown();
        this.ready = false;
    }

    private Socket clientSocket() throws IOException {
        Socket socket = null;
        while (socket == null) {
            socket = this.accept();
        }
        return socket;
    }

    private Socket accept() throws IOException {
        this.ready = true;
        return this.serverSocket.accept();
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public synchronized void stop() {
        this.stopped = true;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            throw new SmtpServerException(e);
        }
    }

    public MailMessage[] getMessages() {
        return this.mailStore.getMessages();
    }

    public MailMessage getMessage(int i) {
        return this.mailStore.getMessage(i);
    }

    public int getEmailCount() {
        return this.mailStore.getEmailCount();
    }

    public void anticipateMessageCountFor(int messageCount, int ticks) {
        for (int tickdown = ticks; this.mailStore.getEmailCount() < messageCount && tickdown > 0; --tickdown) {
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setThreaded(boolean threaded) {
        this.threaded = threaded;
    }

    public void setMailStore(MailStore mailStore) {
        this.mailStore = mailStore;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void clearMessages() {
        this.mailStore.clearMessages();
    }

    public static class SmtpServerException
    extends RuntimeException {
        public SmtpServerException(Throwable cause) {
            super(cause);
        }
    }
}

