/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.mediawiki.japi;

import com.bitplan.mediawiki.japi.MediawikiApi;
import com.bitplan.mediawiki.japi.PageInfo;
import com.bitplan.mediawiki.japi.SiteInfo;
import com.bitplan.mediawiki.japi.api.Api;
import com.bitplan.mediawiki.japi.api.Edit;
import com.bitplan.mediawiki.japi.api.Error;
import com.bitplan.mediawiki.japi.api.Ii;
import com.bitplan.mediawiki.japi.api.Tokens;
import com.bitplan.mediawiki.japi.api.Warnings;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringEscapeUtils;

public abstract class MediaWikiApiImpl
implements MediawikiApi {
    protected static Logger LOGGER = Logger.getLogger("com.bitplan.mediawiki.japi");
    protected boolean throwExceptionOnError = true;
    protected String protectionMarker = "<!-- This page is protected against edits by Mediawiki-Japi -->";
    private String mediawikiVersion;

    @Override
    public boolean isThrowExceptionOnError() {
        return this.throwExceptionOnError;
    }

    @Override
    public void setThrowExceptionOnError(boolean throwExceptionOnError) {
        this.throwExceptionOnError = throwExceptionOnError;
    }

    public String getProtectionMarker() {
        return this.protectionMarker;
    }

    @Override
    public void setProtectionMarker(String protectionMarker) {
        this.protectionMarker = protectionMarker;
    }

    protected void handleError(String errMsg) throws Exception {
        LOGGER.log(Level.SEVERE, errMsg);
        if (this.isThrowExceptionOnError()) {
            throw new Exception(errMsg);
        }
    }

    protected void handleError(Error error) throws Exception {
        String errMsg = "error: " + error.getCode() + " info: " + error.getInfo();
        this.handleError(errMsg);
    }

    protected void handleError(Api api) throws Exception {
        Warnings warnings;
        if (api == null) {
            String errMsg = "api result is null";
            this.handleError(errMsg);
        }
        if (api.getError() != null) {
            this.handleError(api.getError());
        }
        if (api.getWarnings() != null && (warnings = api.getWarnings()).getTokens() != null) {
            Tokens warningTokens = warnings.getTokens();
            String errMsg = warningTokens.getValue();
            this.handleError(errMsg);
        }
    }

    public Api fromXML(String xml) throws Exception {
        Api api = Api.fromXML(xml);
        Error error = api.getError();
        if (error != null) {
            String errMsg = "error code=" + error.getCode() + " info:'" + error.getInfo() + "'";
            this.handleError(errMsg);
        }
        return api;
    }

    @Override
    public abstract SiteInfo getSiteInfo() throws Exception;

    @Override
    public Edit copyToWiki(MediawikiApi targetWiki, String pageTitle, String summary) throws Exception {
        SiteInfo siteinfo = this.getSiteInfo();
        SiteInfo targetSiteInfo = targetWiki.getSiteInfo();
        PageInfo sourcePageInfo = new PageInfo(pageTitle, siteinfo);
        String targetPageTitle = pageTitle;
        Edit result = null;
        String nameSpaceName = "";
        if (sourcePageInfo.namespace != null) {
            nameSpaceName = sourcePageInfo.nameSpaceName;
            String targetNameSpace = siteinfo.mapNamespace(nameSpaceName, targetSiteInfo);
            targetPageTitle = pageTitle.replaceFirst(nameSpaceName + ":", targetNameSpace + ":");
        }
        String content = this.getPageContent(pageTitle);
        if (sourcePageInfo.namespaceId == 6) {
            Ii ii = this.getImageInfo(pageTitle);
            String filename = pageTitle.replaceFirst("File:", "");
            if (nameSpaceName != null) {
                filename = filename.replaceFirst(nameSpaceName + ":", "");
            }
            targetWiki.upload(ii, filename, content);
            result = new Edit();
            result.setTitle(filename);
        } else {
            result = targetWiki.edit(targetPageTitle, content, summary);
        }
        return result;
    }

    @Override
    public String getVersion() throws Exception {
        if (this.mediawikiVersion == null) {
            this.mediawikiVersion = this.getSiteInfo().getVersion();
        }
        return this.mediawikiVersion;
    }

    public void setVersion(String version) {
        if (this.mediawikiVersion != null) {
            throw new IllegalStateException("version " + this.mediawikiVersion + " already set");
        }
        this.mediawikiVersion = version;
    }

    protected String encode(String param) throws Exception {
        String result = URLEncoder.encode(param, "UTF-8");
        return result;
    }

    protected String decode(String html) throws Exception {
        String result = StringEscapeUtils.unescapeHtml4((String)html);
        return result;
    }

    @Override
    public String normalizeTitle(String title) throws Exception {
        String result = this.encode(title);
        result = result.replace("+", "_");
        return result;
    }
}

