/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.mediawiki.japi;

import com.bitplan.mediawiki.japi.MediaWikiApiImpl;
import com.bitplan.mediawiki.japi.MediawikiApi;
import com.bitplan.mediawiki.japi.SiteInfo;
import com.bitplan.mediawiki.japi.SiteInfoImpl;
import com.bitplan.mediawiki.japi.api.Api;
import com.bitplan.mediawiki.japi.api.Bl;
import com.bitplan.mediawiki.japi.api.Delete;
import com.bitplan.mediawiki.japi.api.Edit;
import com.bitplan.mediawiki.japi.api.Error;
import com.bitplan.mediawiki.japi.api.General;
import com.bitplan.mediawiki.japi.api.Ii;
import com.bitplan.mediawiki.japi.api.Im;
import com.bitplan.mediawiki.japi.api.Imageinfo;
import com.bitplan.mediawiki.japi.api.Img;
import com.bitplan.mediawiki.japi.api.Iu;
import com.bitplan.mediawiki.japi.api.Login;
import com.bitplan.mediawiki.japi.api.P;
import com.bitplan.mediawiki.japi.api.Page;
import com.bitplan.mediawiki.japi.api.Parse;
import com.bitplan.mediawiki.japi.api.Query;
import com.bitplan.mediawiki.japi.api.Rc;
import com.bitplan.mediawiki.japi.api.Rev;
import com.bitplan.mediawiki.japi.api.S;
import com.google.gson.Gson;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.StreamDataBodyPart;
import com.sun.jersey.multipart.impl.MultiPartWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.kohsuke.args4j.Option;

public class Mediawiki
extends MediaWikiApiImpl
implements MediawikiApi {
    protected static final String VERSION = "0.1.07";
    public static boolean testMode = false;
    protected static final String USER_AGENT = "Mediawiki-Japi/0.1.07 (https://github.com/WolfgangFahl/Mediawiki-Japi; support@bitplan.com)";
    public static final String DEFAULT_SCRIPTPATH = "/w";
    protected String siteurl;
    protected String scriptPath = "/w";
    protected String format = "xml";
    protected String apiPath = "/api.php?";
    private Client client;
    private ArrayList<Object> cookies;
    protected String userid;
    SiteInfo siteinfo;
    private Gson gson;
    @Option(name="-d", aliases={"--debug"}, usage="debug\nadds debugging output")
    protected boolean debug = false;

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public String getSiteurl() {
        return this.siteurl;
    }

    @Override
    public void setSiteurl(String siteurl) {
        this.siteurl = siteurl;
    }

    @Override
    public String getScriptPath() {
        return this.scriptPath;
    }

    @Override
    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Mediawiki() throws Exception {
        this(null);
    }

    public Mediawiki(String siteurl) throws Exception {
        this(siteurl, DEFAULT_SCRIPTPATH);
    }

    public Mediawiki(String siteurl, String pScriptPath) throws Exception {
        this.init(siteurl, pScriptPath);
    }

    @Override
    public void init(String siteurl, String scriptpath) throws Exception {
        this.client = Mediawiki.getClient();
        this.siteurl = siteurl;
        this.scriptPath = scriptpath;
    }

    public static void initLog4J() {
        String[] clazzes;
        for (String clazz : clazzes = new String[]{"org.apache.http.wire", "org.apache.http.headers", "httpclient.wire.content", "httpclient.wire.header", "org.apache.commons.httpclient", "org.apache.commons.httpclient.HttpClient", "org.apache.commons.httpclient.params.DefaultHttpParams"}) {
            Logger logger = LogManager.getLogger((String)clazz);
            Configurator.setLevel((String)logger.getName(), (Level)Level.ERROR);
        }
    }

    @Override
    public String getIsoTimeStamp() {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
        df.setTimeZone(tz);
        String nowAsISO = df.format(new Date());
        return nowAsISO;
    }

    public static ApacheHttpClient getClient() {
        DefaultApacheHttpClientConfig config = new DefaultApacheHttpClientConfig();
        config.getProperties().put("com.sun.jersey.impl.client.httpclient.handleCookies", true);
        config.getClasses().add(MultiPartWriter.class);
        ApacheHttpClient lClient = ApacheHttpClient.create((ClientConfig)config);
        lClient.setFollowRedirects(Boolean.valueOf(true));
        return lClient;
    }

    public static String getStringFromUrl(String urlString) {
        ApacheHttpClient lclient = Mediawiki.getClient();
        WebResource webResource = lclient.resource(urlString);
        ClientResponse response = (ClientResponse)webResource.get(ClientResponse.class);
        if (response.getStatus() != 200) {
            throw new RuntimeException("HTTP error code : " + response.getStatus());
        }
        String result = (String)response.getEntity(String.class);
        return result;
    }

    public WebResource.Builder getResource(String queryUrl) throws Exception {
        if (this.debug) {
            LOGGER.log(java.util.logging.Level.INFO, queryUrl);
        }
        WebResource wrs = this.client.resource(queryUrl);
        WebResource.Builder result = wrs.header("USER-AGENT", (Object)USER_AGENT);
        return result;
    }

    public ClientResponse getPostResponse(String queryUrl, String params, TokenResult token, Object pFormDataObject) throws Exception {
        params = params.replace("|", "%7C");
        params = params.replace("+", "%20");
        FormDataMultiPart form = null;
        MultivaluedMapImpl lFormData = null;
        if (pFormDataObject instanceof FormDataMultiPart) {
            form = (FormDataMultiPart)pFormDataObject;
        } else {
            Map pFormData = (Map)pFormDataObject;
            lFormData = new MultivaluedMapImpl();
            if (pFormData != null) {
                for (String key : pFormData.keySet()) {
                    lFormData.add((Object)key, pFormData.get(key));
                }
            }
        }
        if (token != null) {
            switch (token.tokenMode) {
                case token1_24: {
                    if (lFormData != null) {
                        lFormData.add((Object)token.tokenName, (Object)token.token);
                        break;
                    }
                    form.field(token.tokenName, token.token);
                    break;
                }
                default: {
                    params = params + token.asParam();
                }
            }
        }
        WebResource.Builder resource = this.getResource(queryUrl + params);
        ClientResponse response = null;
        response = lFormData != null ? (ClientResponse)((WebResource.Builder)resource.type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)lFormData) : (ClientResponse)((WebResource.Builder)resource.type(MediaType.MULTIPART_FORM_DATA_TYPE)).post(ClientResponse.class, (Object)form);
        return response;
    }

    public ClientResponse getResponse(String url, Method method) throws Exception {
        WebResource.Builder resource = this.getResource(url);
        ClientResponse response = null;
        switch (method) {
            case Get: {
                response = (ClientResponse)resource.get(ClientResponse.class);
                break;
            }
            case Post: {
                response = (ClientResponse)resource.post(ClientResponse.class);
                break;
            }
            case Head: {
                response = resource.head();
                break;
            }
            case Put: {
                response = (ClientResponse)resource.put(ClientResponse.class);
            }
        }
        return response;
    }

    public String getResponseString(ClientResponse response) throws Exception {
        if (this.debug) {
            LOGGER.log(java.util.logging.Level.INFO, "status: " + response.getStatus());
        }
        String responseText = (String)response.getEntity(String.class);
        if (response.getStatus() != 200) {
            String msg = "status " + response.getStatus() + ":'" + responseText + "'";
            this.handleError(msg);
            responseText = msg + responseText;
        }
        return responseText;
    }

    public Map<String, String> getParamMap(String params) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] paramlist = params.split("&");
        for (int i = 0; i < paramlist.length; ++i) {
            String[] parts = paramlist[i].split("=");
            if (parts.length != 2) continue;
            result.put(parts[0], parts[1]);
        }
        return result;
    }

    public String getActionResultText(String action, String params, TokenResult token, Object pFormData, String format) throws Exception {
        String queryUrl = this.siteurl + this.scriptPath + this.apiPath + "action=" + action + "&format=" + format;
        String text = "";
        try {
            ClientResponse response = this.getPostResponse(queryUrl, params, token, pFormData);
            text = this.getResponseString(response);
        }
        catch (Throwable th) {
            LOGGER.log(java.util.logging.Level.SEVERE, th.getMessage());
        }
        return text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Api getActionResult(String action, String params, TokenResult token, Object pFormData, String format) throws Exception {
        String text = this.getActionResultText(action, params, token, pFormData, format);
        if (text != null) {
            text = text.trim();
        }
        Api api = null;
        if ("xml".equals(format)) {
            if (this.debug) {
                String xmlDebug = text.replace(">", ">\n");
                LOGGER.log(java.util.logging.Level.INFO, xmlDebug);
            }
            if (text.startsWith("<?xml version")) {
                return this.fromXML(text);
            }
            LOGGER.log(java.util.logging.Level.SEVERE, text);
            throw new Exception("invalid xml:" + text);
        }
        if (!"json".equals(format)) throw new IllegalStateException("unknown format " + format);
        if (this.debug) {
            LOGGER.log(java.util.logging.Level.INFO, text.substring(0, Math.min(240, text.length() - 1)));
        }
        if (this.gson == null) {
            this.gson = new Gson();
        }
        api = (Api)this.gson.fromJson(text, Api.class);
        api.setRawJson(text);
        return api;
    }

    public Api getActionResult(String action, String params, TokenResult token, Object pFormData) throws Exception {
        return this.getActionResult(action, params, token, pFormData, this.format);
    }

    public Api getActionResult(String action, String params) throws Exception {
        Api result = this.getActionResult(action, params, null, null);
        return result;
    }

    public Api getQueryResult(String query) throws Exception {
        Api result = this.getActionResult("query", query, null, null);
        return result;
    }

    public String getTitles(List<String> titleList) throws Exception {
        String titles = "";
        String delim = "";
        for (String title : titleList) {
            titles = titles + delim + this.normalizeTitle(title);
            delim = "%7C";
        }
        return titles;
    }

    @Override
    public SiteInfo getSiteInfo() throws Exception {
        if (this.siteinfo == null) {
            Api api = this.getQueryResult("&meta=siteinfo&siprop=general%7Cnamespaces");
            Query query = api.getQuery();
            this.setUpSiteInfo(query);
        }
        return this.siteinfo;
    }

    public void setUpSiteInfo(Query query) {
        General general = query.getGeneral();
        this.siteinfo = new SiteInfoImpl(general, query.getNamespaces());
    }

    public boolean isVersion128() {
        String mwversion = "Mediawiki 1.28 or after";
        try {
            mwversion = this.getVersion();
        }
        catch (Exception e) {
            LOGGER.log(java.util.logging.Level.INFO, "Could not retrieve Mediawiki Version via API - will assume " + mwversion + " you might want to set the Version actively if you are on a different version and have the api blocked for non-logged in users");
        }
        boolean result = this.checkVersion128(mwversion);
        return result;
    }

    public boolean checkVersion128(String mwversion) {
        if (!mwversion.toLowerCase().startsWith("mediawiki")) {
            mwversion = "Mediawiki " + mwversion;
        }
        boolean result = mwversion.compareToIgnoreCase("Mediawiki 1.28") >= 0;
        return result;
    }

    public TokenResult prepareLogin(String username) throws Exception {
        username = this.encode(username);
        Api apiResult = null;
        TokenResult token = new TokenResult();
        token.tokenName = "lgtoken";
        token.tokenMode = TokenMode.token1_19;
        if (this.isVersion128()) {
            apiResult = this.getQueryResult("&meta=tokens&type=login");
            super.handleError(apiResult);
            token.token = apiResult.getQuery().getTokens().getLogintoken();
        } else {
            apiResult = this.getActionResult("login", "&lgname=" + username, null, null);
            super.handleError(apiResult);
            Login login = apiResult.getLogin();
            token.token = login.getToken();
        }
        return token;
    }

    public Login login(TokenResult token, String username, String password) throws Exception {
        return this.login(token, username, password, null);
    }

    public Login login(TokenResult token, String username, String password, String domain) throws Exception {
        username = this.encode(username);
        if (domain != null) {
            domain = this.encode(domain);
        }
        Api apiResult = null;
        if (this.isVersion128()) {
            HashMap<String, String> lFormData = new HashMap<String, String>();
            lFormData.put("lgpassword", password);
            lFormData.put("lgtoken", token.token);
            apiResult = domain != null ? this.getActionResult("login", "&lgdomain=" + domain + "&lgname=" + username, null, lFormData) : this.getActionResult("login", "&lgname=" + username, null, lFormData);
        } else {
            password = this.encode(password);
            apiResult = domain != null ? this.getActionResult("login", "&lgdomain=" + domain + "&lgname=" + username + "&lgpassword=" + password, token, null) : this.getActionResult("login", "&lgname=" + username + "&lgpassword=" + password, token, null);
        }
        Login login = apiResult.getLogin();
        this.userid = login.getLguserid();
        return login;
    }

    public Login login(String username, String password, String domain) throws Exception {
        TokenResult token = this.prepareLogin(username);
        Login login = this.login(token, username, password, domain);
        if ("Success".equals(login.getResult())) {
            login.setLgtoken(token.token);
        }
        return login;
    }

    @Override
    public Login login(String username, String password) throws Exception {
        return this.login(username, password, null);
    }

    @Override
    public boolean isLoggedIn() {
        boolean result = this.userid != null;
        return result;
    }

    @Override
    public void logout() throws Exception {
        Api apiResult;
        TokenResult token = null;
        String version = this.getVersion();
        if (version.compareToIgnoreCase("Mediawiki 1.27.7") >= 0) {
            token = this.getCSRF_Token();
        }
        if ((apiResult = this.getActionResult("logout", "", token, null)) != null) {
            this.userid = null;
        }
        if (this.cookies != null) {
            this.cookies.clear();
            this.cookies = null;
        }
    }

    public String getPageContent(String pageTitle, String queryParams, boolean checkNotNull) throws Exception {
        Page page;
        Api api = this.getQueryResult("&prop=revisions&rvprop=content" + queryParams + "&titles=" + this.normalizeTitle(pageTitle));
        this.handleError(api);
        List<Page> pages = api.getQuery().getPages();
        String content = null;
        if (pages != null && (page = pages.get(0)) != null && page.getRevisions().size() > 0) {
            content = page.getRevisions().get(0).getValue();
        }
        if (checkNotNull && content == null) {
            String errMsg = "pageTitle '" + pageTitle + "' not found";
            this.handleError(errMsg);
        }
        return content;
    }

    public List<Rev> getPageRevisions(String pageTitle, int revisionLimit, String rvprop, String queryParams) throws Exception {
        Page page;
        if (StringUtils.isBlank((CharSequence)pageTitle)) {
            throw new IllegalArgumentException("Please provide a valid page title.");
        }
        if (revisionLimit < 1 || revisionLimit > 500) {
            throw new IllegalArgumentException("Revision limit must be > 0 and <= 500.");
        }
        if (StringUtils.isBlank((CharSequence)rvprop)) {
            throw new IllegalArgumentException("Please provide a meaningful rvprop string.");
        }
        Api api = this.getQueryResult("&prop=revisions&rvprop=" + rvprop + "&rvlimit=" + revisionLimit + (queryParams != null ? queryParams : "") + "&titles=" + this.normalizeTitle(pageTitle));
        this.handleError(api);
        List<Page> pages = api.getQuery().getPages();
        LinkedList<Rev> pageRevisions = new LinkedList<Rev>();
        if (pages != null && (page = pages.get(0)) != null) {
            pageRevisions.addAll(page.getRevisions());
        }
        return Collections.unmodifiableList(pageRevisions);
    }

    @Override
    public String getPageContent(String pageTitle) throws Exception {
        String result = this.getPageContent(pageTitle, "", false);
        return result;
    }

    @Override
    public String getSectionText(String pageTitle, int sectionNumber) throws Exception {
        String result = this.getPageContent(pageTitle, "&rvsection=" + sectionNumber, false);
        return result;
    }

    @Override
    public List<S> getSections(String pageTitle) throws Exception {
        String params = "&prop=sections&page=" + pageTitle;
        Parse parse = this.getParse(params);
        List<S> sections = parse.getSections();
        return sections;
    }

    @Override
    public String getPageHtml(String pageTitle) throws Exception {
        String params = "&page=" + this.encode(pageTitle);
        Parse parse = this.getParse(params);
        String html = parse.getText();
        return html;
    }

    public Parse getParse(String params) throws Exception {
        String action = "parse";
        Api api = this.getActionResult(action, params);
        super.handleError(api);
        return api.getParse();
    }

    public List<Page> getPages(List<String> titleList, String rvprop) throws Exception {
        String titles = this.getTitles(titleList);
        Api api = this.getQueryResult("&titles=" + titles + "&prop=revisions&rvprop=" + rvprop);
        this.handleError(api);
        Query query = api.getQuery();
        if (query == null) {
            throw new Exception("query is null for getPages '" + titleList + "' rvprop='" + rvprop + "'");
        }
        List<Page> pages = query.getPages();
        return pages;
    }

    public List<Page> getPages(List<String> titleList) throws Exception {
        String rvprop = "content|ids|timestamp";
        List<Page> result = this.getPages(titleList, rvprop);
        return result;
    }

    public TokenResult getCSRF_Token() throws Exception {
        TokenResult token = new TokenResult();
        String action = "query";
        String params = "&meta=tokens";
        Api api = this.getActionResult(action, params);
        this.handleError(api);
        token.setToken(api.getQuery().getTokens().getCsrftoken());
        return token;
    }

    public TokenResult getEditToken(String pageTitle, String type) throws Exception {
        TokenMode tokenMode;
        pageTitle = this.normalizeTitle(pageTitle);
        String editversion = "";
        String action = "query";
        String params = "&meta=tokens";
        if (this.getVersion().compareToIgnoreCase("Mediawiki 1.24") >= 0) {
            editversion = "Versions 1.24 and later";
            tokenMode = TokenMode.token1_24;
            params = "&meta=tokens";
        } else if (this.getVersion().compareToIgnoreCase("Mediawiki 1.20") >= 0) {
            editversion = "Versions 1.20-1.23";
            tokenMode = TokenMode.token1_20_23;
            action = "tokens";
            params = "&type=" + type;
        } else {
            editversion = "Version 1.19 and earlier";
            tokenMode = TokenMode.token1_19;
            params = "&prop=info&7Crevisions&intoken=" + type + "&titles=" + pageTitle;
        }
        if (this.debug) {
            LOGGER.log(java.util.logging.Level.INFO, "handling " + type + " token for wiki version " + this.getVersion() + " as " + editversion + " with action=" + action + params);
        }
        Api api = this.getActionResult(action, params);
        this.handleError(api);
        TokenResult token = new TokenResult();
        token.tokenMode = tokenMode;
        token.tokenName = "token";
        switch (tokenMode) {
            case token1_19: {
                Page page = api.getQuery().getPages().get(0);
                if (type.equals("edit")) {
                    token.setToken(page.getEdittoken());
                    break;
                }
                if (!type.equals("delete")) break;
                token.setToken(page.getDeletetoken());
                break;
            }
            case token1_20_23: {
                if (type.equals("edit")) {
                    token.setToken(api.getTokens().getEdittoken());
                    break;
                }
                if (!type.equals("delete")) break;
                token.setToken(api.getTokens().getDeletetoken());
                break;
            }
            default: {
                token.setToken(api.getQuery().getTokens().getCsrftoken());
            }
        }
        return token;
    }

    @Override
    public Edit edit(String pageTitle, String text, String summary) throws Exception {
        Edit result = this.edit(pageTitle, text, summary, true, false, -2, null, null);
        return result;
    }

    @Override
    public Delete delete(String pageTitle, String reason) throws Exception {
        Delete result = new Delete();
        String pageContent = this.getPageContent(pageTitle);
        if (pageContent != null && pageContent.contains(this.protectionMarker)) {
            LOGGER.log(java.util.logging.Level.WARNING, "page " + pageTitle + " is protected!");
        } else {
            TokenResult token = this.getEditToken(pageTitle, "delete");
            if (token.token == null) {
                throw new IllegalStateException("could not get " + token.tokenMode.toString() + " delete token for " + pageTitle + " ");
            }
            HashMap<String, String> lFormData = new HashMap<String, String>();
            lFormData.put("title", pageTitle);
            lFormData.put("reason", reason);
            String params = "";
            Api api = this.getActionResult("delete", params, token, lFormData);
            this.handleError(api);
            result = api.getDelete();
        }
        return result;
    }

    @Override
    public Edit edit(String pageTitle, String text, String summary, boolean minor, boolean bot, int sectionNumber, String sectionTitle, Calendar basetime) throws Exception {
        Edit result = new Edit();
        String pageContent = this.getPageContent(pageTitle);
        if (pageContent != null && pageContent.contains(this.protectionMarker)) {
            LOGGER.log(java.util.logging.Level.WARNING, "page " + pageTitle + " is protected!");
        } else {
            TokenResult token = this.getEditToken(pageTitle, "edit");
            HashMap<String, String> lFormData = new HashMap<String, String>();
            lFormData.put("text", text);
            lFormData.put("title", pageTitle);
            lFormData.put("summary", summary);
            if (minor) {
                lFormData.put("minor", "1");
            }
            if (bot) {
                lFormData.put("bot", "1");
            }
            switch (sectionNumber) {
                case -1: {
                    lFormData.put("section", "new");
                    if (sectionTitle == null) break;
                    lFormData.put("sectiontitle", sectionTitle);
                    break;
                }
                case -2: {
                    break;
                }
                default: {
                    lFormData.put("section", "" + sectionNumber);
                }
            }
            String params = "";
            Api api = this.getActionResult("edit", params, token, lFormData);
            this.handleError(api);
            result = api.getEdit();
        }
        return result;
    }

    @Override
    public synchronized void upload(File fileToUpload, String filename, String contents, String comment) throws Exception {
        this.upload(new FileInputStream(fileToUpload), filename, contents, comment);
    }

    public synchronized void upload(InputStream fileToUpload, String filename, String contents, String comment) throws Exception {
        Error error;
        TokenResult token = this.getEditToken("File:" + filename, "edit");
        FormDataMultiPart multiPart = new FormDataMultiPart();
        multiPart.bodyPart((BodyPart)new StreamDataBodyPart("file", fileToUpload));
        multiPart.field("filename", filename);
        multiPart.field("ignorewarnings", "true");
        multiPart.field("text", contents);
        if (comment != null && !comment.isEmpty()) {
            multiPart.field("comment", comment);
        }
        String params = "";
        boolean oldThrowExceptionOnError = this.throwExceptionOnError;
        this.throwExceptionOnError = false;
        Api api = this.getActionResult("upload", params, token, multiPart);
        this.throwExceptionOnError = oldThrowExceptionOnError;
        String info = null;
        if (api != null && (error = api.getError()) != null && !(info = error.getInfo()).contains("duplicate")) {
            this.handleError(api);
        }
    }

    @Override
    public void upload(Ii ii, String fileName, String pageContent) throws Exception {
        String url = ii.getUrl();
        InputStream imageInput = new URL(url).openStream();
        String comment = ii.getComment();
        this.upload(imageInput, fileName, pageContent, comment);
    }

    @Override
    public List<P> getAllPages(String apfrom, int aplimit) throws Exception {
        String query = "&list=allpages";
        if (apfrom != null && !apfrom.trim().equals("")) {
            query = query + "&apfrom=" + apfrom;
        }
        query = query + "&aplimit=" + aplimit;
        Api api = this.getQueryResult(query);
        List<P> pageRefList = api.getQuery().getAllpages();
        return pageRefList;
    }

    @Override
    public List<Img> getAllImagesByTimeStamp(String aistart, String aiend, int ailimit) throws Exception {
        String query = "&list=allimages&aisort=timestamp";
        if (aistart != null && !aistart.trim().equals("")) {
            query = query + "&aistart=" + aistart;
        }
        if (aiend != null && !aiend.trim().equals("")) {
            query = query + "&aiend=" + aiend;
        }
        query = query + "&ailimit=" + ailimit;
        Api api = this.getQueryResult(query);
        this.handleError(api);
        List<Img> result = api.getQuery().getAllImages();
        return result;
    }

    @Override
    public List<Bl> getBacklinks(String pageTitle, String params, int bllimit) throws Exception {
        String query = "&list=backlinks&bltitle=" + this.normalizeTitle(pageTitle);
        query = query + "&bllimit=" + bllimit;
        query = query + params;
        Api api = this.getQueryResult(query);
        this.handleError(api);
        List<Bl> result = api.getQuery().getBacklinks();
        return result;
    }

    @Override
    public List<Iu> getImageUsage(String imageTitle, String params, int limit) throws Exception {
        String query = "&list=imageusage&iutitle=" + this.normalizeTitle(imageTitle);
        query = query + "&iulimit=" + limit;
        query = query + params;
        Api api = this.getQueryResult(query);
        this.handleError(api);
        List<Iu> result = api.getQuery().getImageusage();
        return result;
    }

    public void handle(Throwable t) {
        System.out.flush();
        System.err.println(t.getClass().getSimpleName() + ":" + t.getMessage());
        if (this.debug) {
            t.printStackTrace();
        }
    }

    public Api getAuthManagerInfo() throws Exception {
        String oldFormat = this.format;
        this.format = "json";
        Api apiResult = this.getQueryResult("&meta=authmanagerinfo&amirequestsfor=create");
        super.handleError(apiResult);
        this.format = oldFormat;
        return apiResult;
    }

    @Deprecated
    public Api createAccount(String name, String eMail, String realname, boolean mailpassword, String reason, String language) throws Exception {
        String createtoken = "?";
        if (this.getVersion().compareToIgnoreCase("Mediawiki 1.27") >= 0) {
            Api apiResult = this.getQueryResult("&meta=tokens&type=createaccount");
            super.handleError(apiResult);
            createtoken = apiResult.getQuery().getTokens().getCreateaccounttoken();
        }
        Api api = null;
        if (this.getVersion().compareToIgnoreCase("Mediawiki 1.27") >= 0) {
            HashMap<String, String> lFormData = new HashMap<String, String>();
            lFormData.put("createtoken", createtoken);
            lFormData.put("username", name);
            lFormData.put("email", eMail);
            lFormData.put("realname", realname);
            lFormData.put("mailpassword", mailpassword ? "1" : "0");
            lFormData.put("reason", reason);
            lFormData.put("createcontinue", "1");
            String params = "";
            api = this.getActionResult("createaccount", params, null, lFormData);
        } else {
            String params = "&name=" + this.encode(name);
            params = params + "&email=" + this.encode(eMail);
            params = params + "&realname=" + this.encode(realname);
            params = params + "&mailpassword=" + mailpassword;
            params = params + "&reason=" + this.encode(reason);
            params = params + "&token=";
            api = this.getActionResult("createaccount", params);
            this.handleError(api);
            String token = api.getCreateaccount().getToken();
            params = params + token;
            api = this.getActionResult("createaccount", params);
        }
        return api;
    }

    @Override
    public Ii getImageInfo(String pageTitle) throws Exception {
        Page page;
        String props = "timestamp";
        props = props + "%7Cuser%7Cuserid%7Ccomment%7Cparsedcomment%7Curl%7Csize%7Cdimensions";
        props = props + "%7Csha1%7Cmime%7Cthumbmime%7Cmediatype%7Carchivename%7Cbitdepth";
        Api api = this.getQueryResult("&prop=imageinfo&iiprop=" + props + "&titles=" + this.normalizeTitle(pageTitle));
        this.handleError(api);
        Ii ii = null;
        List<Page> pages = api.getQuery().getPages();
        if (pages != null && (page = pages.get(0)) != null) {
            Imageinfo imageinfo = page.getImageinfo();
            if (imageinfo != null) {
                ii = imageinfo.getIi();
            } else {
                String errMsg = "imageinfo for pageTitle '" + pageTitle + "' not found";
                this.handleError(errMsg);
            }
        }
        if (ii == null) {
            String errMsg = "pageTitle '" + pageTitle + "' not found";
            this.handleError(errMsg);
        }
        return ii;
    }

    @Override
    public List<Im> getImagesOnPage(String pageTitle, int imLimit) throws Exception {
        List<Page> pages;
        String query = "&titles=" + this.normalizeTitle(pageTitle) + "&prop=images&imlimit=" + imLimit;
        Api api = this.getQueryResult(query);
        this.handleError(api);
        List<Im> result = new ArrayList<Im>();
        Query lquery = api.getQuery();
        if (lquery != null && (pages = lquery.getPages()).size() > 0) {
            Page page = pages.get(0);
            result = page.getImages();
        }
        return result;
    }

    @Override
    public List<Ii> getImageInfosForPage(String pageTitle, int imLimit) throws Exception {
        List<Im> images = this.getImagesOnPage(pageTitle, imLimit);
        ArrayList<Ii> result = new ArrayList<Ii>();
        for (Im image : images) {
            Ii imageinfo = this.getImageInfo(image.getTitle());
            if (imageinfo.getCanonicaltitle() == null) {
                imageinfo.setCanonicaltitle(image.getTitle());
            }
            result.add(imageinfo);
        }
        return result;
    }

    public List<Rc> getRecentChanges(String rcstart, String rcend, Integer rclimit) throws Exception {
        String query = "&list=recentchanges&rcprop=title%7Ctimestamp%7Csha1%7Cids%7Csizes%7Cflags%7Cuser";
        if (rclimit != null) {
            query = query + "&rclimit=" + rclimit;
        }
        if (rcstart != null) {
            query = query + "&rcstart=" + rcstart;
        }
        if (rcend != null) {
            query = query + "&rcend=" + rcend;
        }
        Api api = this.getQueryResult(query);
        this.handleError(api);
        List<Rc> rcList = api.getQuery().getRecentchanges();
        rcList = this.sortByTitleAndFilterDoubles(rcList);
        return rcList;
    }

    public List<Rc> sortByTitleAndFilterDoubles(List<Rc> rcList) {
        ArrayList<Rc> result = new ArrayList<Rc>();
        ArrayList<Rc> sorted = new ArrayList<Rc>();
        sorted.addAll(rcList);
        Collections.sort(sorted, new Comparator<Rc>(){

            @Override
            public int compare(Rc lRc, Rc rRc) {
                int result = lRc.getTitle().compareTo(rRc.getTitle());
                if (result == 0) {
                    result = rRc.getTimestamp().compare(lRc.getTimestamp());
                }
                return result;
            }
        });
        Rc previous = null;
        for (Rc rc : sorted) {
            if (previous == null || !rc.getTitle().equals(previous.getTitle())) {
                result.add(rc);
            }
            previous = rc;
        }
        Collections.sort(result, new Comparator<Rc>(){

            @Override
            public int compare(Rc lRc, Rc rRc) {
                int result = rRc.getTimestamp().compare(lRc.getTimestamp());
                return result;
            }
        });
        return result;
    }

    public String dateToMWTimeStamp(Date date) {
        SimpleDateFormat mwTimeStampFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String result = mwTimeStampFormat.format(date);
        return result;
    }

    public List<Rc> getMostRecentChanges(int days, int rcLimit) throws Exception {
        Date today = new Date();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(today);
        ((Calendar)cal).add(5, -days);
        Date date30daysbefore = cal.getTime();
        String rcstart = this.dateToMWTimeStamp(today);
        String rcend = this.dateToMWTimeStamp(date30daysbefore);
        List<Rc> rcList = this.getRecentChanges(rcstart, rcend, rcLimit);
        List<Rc> result = this.sortByTitleAndFilterDoubles(rcList);
        return result;
    }

    class TokenResult {
        String tokenName = "token";
        String token;
        TokenMode tokenMode = TokenMode.token1_24;

        public void setToken(String pToken) {
            this.token = pToken;
        }

        public String asParam() throws Exception {
            String lToken = this.token;
            String result = "&" + this.tokenName + "=" + Mediawiki.this.encode(lToken);
            if (Mediawiki.this.debug) {
                MediaWikiApiImpl.LOGGER.log(java.util.logging.Level.INFO, "token " + this.token + "=>" + result);
            }
            return result;
        }
    }

    static enum TokenMode {
        token1_19,
        token1_20_23,
        token1_24;

    }

    public static enum Method {
        Post,
        Get,
        Head,
        Put;

    }
}

