/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.mediawiki.japi;

import com.bitplan.mediawiki.japi.Mediawiki;
import com.bitplan.mediawiki.japi.PushPages;
import com.bitplan.mediawiki.japi.SSLWiki;
import com.bitplan.mediawiki.japi.SiteInfo;
import com.bitplan.mediawiki.japi.user.WikiUser;
import java.io.File;
import java.io.OutputStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StringArrayOptionHandler;

public class MediawikiMain
extends Mediawiki {
    static int exitCode;
    private CmdLineParser parser;
    @Option(name="-h", aliases={"--help"}, usage="help\nshow this usage")
    boolean showHelp = false;
    @Option(name="-i", aliases={"--imageLimit"}, usage="the maximum number of images per page to push")
    int imageLimit = 100;
    @Option(name="-l", aliases={"--login"}, usage="login to source wiki for access permission")
    boolean login = false;
    @Option(name="-s", aliases={"--source"}, usage="the source wiki")
    String sourceWiki = null;
    @Option(name="-t", aliases={"--target"}, usage="the target wiki")
    String targetWiki = null;
    @Option(name="--test", usage="test")
    boolean test = false;
    @Option(name="-a", aliases={"--all"}, usage="all available wikis")
    boolean all = false;
    @Option(name="-u", aliases={"--user"}, usage="activates credential mode\nuse -u -h to see options\nsee http://mediawiki-japi.bitplan.com/index.php/CommandLine")
    String username = null;
    @Option(name="-c", aliases={"--check"}, usage="check mode - tries access without writing to target")
    boolean check = false;
    @Option(name="--cookie", usage="use given cookie for download")
    String cookie = null;
    @Option(name="-p", aliases={"--pages"}, handler=StringArrayOptionHandler.class, usage="the pages to be transferred")
    String[] pageTitles = new String[0];
    @Option(name="-v", aliases={"--version"}, usage="showVersion\nshow current version if this switch is used")
    boolean showVersion = false;

    public static void showVersion() {
        System.err.println("Mediawiki-Japi Version: 0.1.07");
        System.err.println();
        System.err.println(" github: https://github.com/WolfgangFahl/Mediawiki-Japi");
        System.err.println("");
    }

    public void usage(String msg) {
        System.err.println(msg);
        MediawikiMain.showVersion();
        String usageMsg = String.format("  usage: java %s", this.getClass().getName());
        System.err.println(usageMsg);
        this.parser.printUsage((OutputStream)System.err);
        exitCode = 1;
    }

    public void showHelp() {
        String msg = "Help\nMediawiki-Japi version 0.1.07\nPlease visit http://mediawiki-japi.bitplan.com for usage instructions";
        this.usage(msg);
    }

    public void showResult(boolean ok, String format, Object ... args) {
        String check;
        String msg = String.format(format, args);
        String string = check = ok ? "\u2705" : "\u274c";
        if (ok) {
            System.out.println(msg + check);
        } else {
            System.err.println(msg + check);
        }
    }

    public boolean testPropertyFile(File propertyFile) {
        WikiUser wikiUser = new WikiUser();
        if (wikiUser.testPropertyFile(propertyFile)) {
            try {
                SSLWiki wiki = new SSLWiki(wikiUser);
                wiki.login();
                boolean versionOk = wiki.getVersion().equals(wikiUser.getVersion());
                this.showResult(versionOk, "\tversion: %s", wiki.getVersion());
                SiteInfo siteInfo = wiki.getSiteInfo();
                System.out.println(String.format("\tsitename: %s", siteInfo.getGeneral().getSitename()));
                System.out.println(String.format("\t    lang: %s", siteInfo.getGeneral().getLang()));
            }
            catch (Exception e) {
                System.err.println(String.format("\t\u274c:%s", e.getMessage()));
                String cmd = String.format("./run -w %s -u %s -e %s -l %s -s '%s' -v '%s' -y --password '**'", wikiUser.getWikiId(), wikiUser.getUsername(), wikiUser.getEmail(), wikiUser.getUrl(), wikiUser.getScriptPath(), wikiUser.getVersion());
                System.err.println(String.format("To update your password your might want to run\n%s", cmd));
                return false;
            }
            return true;
        }
        return false;
    }

    protected int maininstance(String[] args) {
        this.parser = new CmdLineParser((Object)this);
        try {
            boolean credentialMode = false;
            for (String arg : args) {
                if (!"-u".equals(arg)) continue;
                credentialMode = true;
            }
            if (credentialMode) {
                WikiUser wikiUser = new WikiUser();
                return wikiUser.maininstance(args);
            }
            this.username = WikiUser.getSystemUserName();
            this.parser.parseArgument(args);
            if (this.debug) {
                MediawikiMain.showVersion();
            }
            if (this.showVersion) {
                MediawikiMain.showVersion();
            } else if (this.showHelp) {
                this.showHelp();
            } else if (this.test) {
                if (this.all) {
                    for (File propertyFile : WikiUser.getPropertyFiles()) {
                        if (this.testPropertyFile(propertyFile)) continue;
                        ++exitCode;
                    }
                } else {
                    File propFile = WikiUser.getPropertyFile(this.sourceWiki, this.username);
                    if (!this.testPropertyFile(propFile)) {
                        ++exitCode;
                    }
                }
                String msg = String.format("There are %3d problems", exitCode);
                System.err.println(msg);
            } else if (this.targetWiki != null && this.sourceWiki != null && this.pageTitles != null) {
                PushPages.debug = this.debug;
                PushPages pp = new PushPages(this.sourceWiki, this.targetWiki, this.imageLimit, this.login);
                pp.setCheck(this.check);
                pp.setCookie(this.cookie);
                pp.setShowDebug(this.debug);
                pp.push(this.pageTitles);
            } else {
                this.showHelp();
            }
        }
        catch (CmdLineException e) {
            this.usage(e.getMessage());
        }
        catch (Exception e) {
            this.handle(e);
            exitCode = 1;
        }
        return exitCode;
    }

    public static void main(String[] args) {
        Mediawiki.initLog4J();
        try {
            MediawikiMain wiki = new MediawikiMain();
            int result = wiki.maininstance(args);
            if (!testMode && result != 0) {
                System.exit(result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

