/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.mediawiki.japi;

import com.bitplan.mediawiki.japi.SiteInfo;
import com.bitplan.mediawiki.japi.api.Ns;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PageInfo {
    protected static Logger LOGGER = Logger.getLogger("com.bitplan.mediawiki.japi");
    public static boolean debug = false;
    int namespaceId = -999;
    String lang;
    String pageTitle;
    String canonicalPageTitle;
    Ns namespace;
    String nameSpaceName;
    SiteInfo siteinfo;
    public static final String NAMESPACE_REGEX = "([^:]*):";
    public static final Pattern namespacePattern = Pattern.compile("([^:]*):");

    public int getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(int namespaceId) {
        this.namespaceId = namespaceId;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public String getCanonicalPageTitle() {
        return this.canonicalPageTitle;
    }

    public void setCanonicalPageTitle(String canonicalPageTitle) {
        this.canonicalPageTitle = canonicalPageTitle;
    }

    public Ns getNamespace() {
        return this.namespace;
    }

    public void setNamespace(Ns namespace) {
        this.namespace = namespace;
    }

    public String getNameSpaceName() {
        return this.nameSpaceName;
    }

    public void setNameSpaceName(String nameSpaceName) {
        this.nameSpaceName = nameSpaceName;
    }

    public static String getNameSpaceName(String pageTitle) {
        Matcher matcher = namespacePattern.matcher(pageTitle);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public PageInfo(String pageTitle, SiteInfo siteinfo) throws Exception {
        this.pageTitle = pageTitle;
        this.canonicalPageTitle = pageTitle;
        this.siteinfo = siteinfo;
        this.nameSpaceName = PageInfo.getNameSpaceName(pageTitle);
        this.lang = siteinfo.getLang();
        this.namespace = null;
        if (this.nameSpaceName != null) {
            this.namespace = siteinfo.getNamespaces().get(this.nameSpaceName);
            if (this.namespace == null) {
                String lookupName = this.nameSpaceName;
                this.namespace = siteinfo.getNamespacesByCanonicalName().get(lookupName);
            }
            if (this.namespace != null) {
                String canonical = this.namespace.getCanonical();
                this.canonicalPageTitle = pageTitle.replaceFirst(this.nameSpaceName + ":", canonical + ":");
                this.namespaceId = this.namespace.getId();
            } else if (debug) {
                LOGGER.log(Level.WARNING, "namespace for namespacename '" + this.nameSpaceName + "' not found");
                for (Ns ns : siteinfo.getNamespacesByCanonicalName().values()) {
                    LOGGER.log(Level.WARNING, ns.getValue() + "->" + ns.getCanonical());
                }
            }
        }
        this.canonicalPageTitle = this.canonicalPageTitle.replace(" ", "_");
    }

    public String dual() {
        String result = "'" + this.pageTitle + "' canonical '" + this.canonicalPageTitle + "'";
        return result;
    }
}

