/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.mediawiki.japi;

import com.bitplan.mediawiki.japi.SSLWiki;
import com.bitplan.mediawiki.japi.api.Edit;
import com.bitplan.mediawiki.japi.api.Ii;
import com.bitplan.mediawiki.japi.api.Login;
import com.bitplan.mediawiki.japi.api.Page;
import java.awt.Desktop;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class PushPages {
    public static final int DEFAULT_IMAGE_LIMIT = 100;
    private int imageLimit;
    private SSLWiki sourceWiki;
    private SSLWiki targetWiki;
    private String cookie;
    private boolean check = false;
    private boolean showDebug = false;
    public static boolean debug = false;

    public boolean isCheck() {
        return this.check;
    }

    public void setCheck(boolean check) {
        this.check = check;
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public boolean isShowDebug() {
        return this.showDebug;
    }

    public void setShowDebug(boolean showDebug) {
        this.showDebug = showDebug;
    }

    public PushPages(String sourceWikiId, String targetWikiId, boolean login) throws Exception {
        this.init(sourceWikiId, targetWikiId, 100, login);
    }

    public PushPages(String sourceWikiId, String targetWikiId, int imageLimit, boolean login) throws Exception {
        this.init(sourceWikiId, targetWikiId, imageLimit, login);
    }

    public PushPages(SSLWiki sourceWiki, SSLWiki targetWiki, boolean login) throws Exception {
        this.init(sourceWiki, targetWiki, 100, login);
    }

    public PushPages(SSLWiki sourceWiki, SSLWiki targetWiki, int imageLimit, boolean login) throws Exception {
        this.init(sourceWiki, targetWiki, imageLimit, login);
    }

    public void init(String sourceWikiId, String targetWikiId, int imageLimit, boolean login) throws Exception {
        SSLWiki sourceWiki = SSLWiki.ofId(sourceWikiId);
        SSLWiki targetWiki = SSLWiki.ofId(targetWikiId);
        this.init(sourceWiki, targetWiki, imageLimit, login);
    }

    public void init(SSLWiki sourceWiki, SSLWiki targetWiki, int imageLimit, boolean sourceLogin) throws Exception {
        Login login;
        this.sourceWiki = sourceWiki;
        this.targetWiki = targetWiki;
        if (sourceLogin && (login = sourceWiki.login()).getCookieprefix() != null) {
            this.setCookie(login.getCookieprefix());
        }
        targetWiki.login();
        this.imageLimit = imageLimit;
    }

    public void push(String ... pageTitles) throws Exception {
        if (this.showDebug) {
            List<Page> pages = this.sourceWiki.getPages(Arrays.asList(pageTitles));
            for (Page page : pages) {
                this.show4Debug(page);
            }
        }
        for (String pageTitle : pageTitles) {
            this.pushPage(pageTitle);
        }
    }

    public void show4Debug(Page page) {
        String info = String.format("%s:%s", page.getTitle(), page.getPageid());
        System.out.println(info);
    }

    public String getSummary() {
        String summary = String.format("pushed from %s", this.sourceWiki.getSiteurl());
        return summary;
    }

    public void pushPage(String pageTitle) throws Exception {
        String pageContent = this.getPageContent(pageTitle);
        Edit edit = null;
        if (!this.check) {
            edit = this.targetWiki.edit(pageTitle, pageContent, this.getSummary());
        }
        this.pushImages(pageTitle);
        if (edit != null && this.showDebug) {
            String url = this.targetWiki.siteurl + "/" + this.targetWiki.getScriptPath() + "index.php/" + this.targetWiki.normalizeTitle(pageTitle);
            Desktop.getDesktop().browse(new URI(url));
        }
    }

    public String getPageContent(String pageTitle) throws Exception {
        String pageContent = this.sourceWiki.getPageContent(pageTitle);
        return pageContent;
    }

    public void pushImages(String pageTitle) throws Exception {
        List<Ii> imageInfos = this.sourceWiki.getImageInfosForPage(pageTitle, this.imageLimit);
        for (Ii imageInfo : imageInfos) {
            if (this.sourceWiki.siteurl.toLowerCase().startsWith("https:") && imageInfo.getUrl().startsWith("http:")) {
                String url = imageInfo.getUrl();
                url = url.replace("http:", "https:");
                imageInfo.setUrl(url);
            }
            System.out.println(imageInfo.getCanonicaltitle());
            System.out.println(imageInfo.getUrl());
            String contents = this.sourceWiki.getPageContent(imageInfo.getCanonicaltitle());
            File downloaded = this.download(imageInfo);
            if (this.showDebug) {
                Desktop.getDesktop().open(downloaded);
            }
            if (this.check) continue;
            String imageTitle = imageInfo.getCanonicaltitle();
            imageTitle = imageTitle.replaceAll("(Datei|File):", "");
            this.targetWiki.upload(downloaded, imageTitle, contents == null ? "" : contents, imageInfo.getComment());
        }
    }

    public File download(Ii imageInfo) throws Exception {
        String url = imageInfo.getUrl();
        URL uri = new URL(url);
        URLConnection connection = uri.openConnection();
        if (this.cookie != null) {
            connection.addRequestProperty("Cookie", this.cookie);
        }
        InputStream in = connection.getInputStream();
        String suffix = FilenameUtils.getExtension((String)url);
        String prefix = FilenameUtils.getBaseName((String)url);
        prefix = this.targetWiki.normalizeTitle(prefix).replace(".", "");
        File tmpFile = File.createTempFile("download-" + prefix, suffix);
        tmpFile.delete();
        Files.copy(in, Paths.get(tmpFile.toURI()), new CopyOption[0]);
        return tmpFile;
    }
}

