/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.mediawiki.japi;

import com.bitplan.mediawiki.japi.Mediawiki;
import com.bitplan.mediawiki.japi.api.Login;
import com.bitplan.mediawiki.japi.user.WikiUser;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLWiki
extends Mediawiki {
    public static boolean ignoreCertificates = false;
    private WikiUser wikiUser;

    public void init() throws Exception {
        SSLContext ctx = SSLContext.getInstance("TLS");
        if (ignoreCertificates) {
            ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            SSLContext.setDefault(ctx);
        }
        IgnoreHostName hv = new IgnoreHostName();
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
    }

    public SSLWiki(WikiUser wikiUser) throws Exception {
        Mediawiki.initLog4J();
        this.wikiUser = wikiUser;
        this.init();
        super.init(wikiUser.getUrl(), wikiUser.getScriptPath());
        super.setVersion(wikiUser.getVersion());
    }

    public static SSLWiki ofIdAndUser(String wikiId, String user) throws Exception {
        WikiUser wikiUser = WikiUser.getUser(wikiId, user);
        SSLWiki wiki = new SSLWiki(wikiUser);
        return wiki;
    }

    public static SSLWiki ofId(String wikiId) throws Exception {
        String user = System.getProperty("user.name");
        return SSLWiki.ofIdAndUser(wikiId, user);
    }

    public Login login() throws Exception {
        WikiUser wuser = this.wikiUser;
        if (wuser == null) {
            throw new Exception("user for " + this.wikiUser.getWikiId() + "(" + this.getSiteurl() + ") not configured");
        }
        try {
            Login login = this.login(wuser.getUsername(), wuser.getPassword());
            LOGGER.log(Level.INFO, this.siteurl + this.scriptPath + this.apiPath + ":" + login.getResult());
            if (!"Success".equals(login.getResult())) {
                throw new Exception("login for '" + wuser.getUsername() + "' at '" + this.wikiUser.getWikiId() + "(" + this.getSiteurl() + this.getScriptPath() + ")' failed: " + login.getResult());
            }
            return login;
        }
        catch (SSLHandshakeException she) {
            String msg = "login via SSL  to " + this.getSiteurl() + " failed\n";
            msg = msg + "Exception: " + she.getMessage();
            throw new Exception(msg);
        }
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    public static class IgnoreHostName
    implements HostnameVerifier {
        boolean debug = false;
        protected static Logger LOGGER = Logger.getLogger("org.sidif.wiki");

        @Override
        public boolean verify(String hostname, SSLSession sslSession) {
            if (this.debug) {
                LOGGER.log(Level.INFO, "verifying hostname " + hostname + " with IgnoreHostName - will return true");
            }
            return true;
        }
    }
}

