/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.mediawiki.japi;

import com.bitplan.mediawiki.japi.SiteInfo;
import com.bitplan.mediawiki.japi.api.General;
import com.bitplan.mediawiki.japi.api.Ns;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SiteInfoImpl
implements SiteInfo {
    protected static Logger LOGGER = Logger.getLogger("com.bitplan.mediawiki.japi");
    public static boolean debug = true;
    protected String mediawikiVersion;
    protected General generalSiteInfo;
    protected Map<String, Ns> namespaces;
    protected Map<String, Ns> namespacesByCanonicalName;
    protected Map<Integer, Ns> namespacesById;

    public SiteInfoImpl(General general, List<Ns> list) {
        this.generalSiteInfo = general;
        this.initNameSpaces(general, list);
    }

    protected void initNameSpaces(General general, List<Ns> namespaceList) {
        this.namespaces = new LinkedHashMap<String, Ns>();
        this.namespacesById = new LinkedHashMap<Integer, Ns>();
        this.namespacesByCanonicalName = new LinkedHashMap<String, Ns>();
        for (Ns namespace : namespaceList) {
            String namespacename = namespace.getValue();
            this.namespaces.put(namespacename, namespace);
            this.namespacesById.put(namespace.getId(), namespace);
            String canonical = namespace.getCanonical();
            String[] bugs = new String[]{"Attribut", "Property", "Konzept", "Concept", "Kategorie", "Category"};
            for (int i = 0; i < bugs.length; i += 2) {
                if (!bugs[i].equals(canonical) || !bugs[i].equals(namespacename)) continue;
                canonical = bugs[i + 1];
                namespace.setCanonical(bugs[i + 1]);
            }
            this.namespacesByCanonicalName.put(canonical, namespace);
        }
    }

    @Override
    public General getGeneral() {
        return this.generalSiteInfo;
    }

    public void setGeneral(General siteInfo) {
        this.generalSiteInfo = siteInfo;
    }

    @Override
    public Map<String, Ns> getNamespaces() throws Exception {
        if (this.namespaces == null) {
            this.getGeneral();
        }
        return this.namespaces;
    }

    @Override
    public Map<String, Ns> getNamespacesByCanonicalName() throws Exception {
        if (this.namespacesByCanonicalName == null) {
            this.getGeneral();
        }
        return this.namespacesByCanonicalName;
    }

    @Override
    public Map<Integer, Ns> getNamespacesById() throws Exception {
        if (this.namespacesById == null) {
            this.getGeneral();
        }
        return this.namespacesById;
    }

    @Override
    public String mapNamespace(String ns, SiteInfo targetWiki) throws Exception {
        Map<String, Ns> sourceMap = this.getNamespaces();
        Map<Integer, Ns> targetMap = targetWiki.getNamespacesById();
        Ns sourceNs = sourceMap.get(ns);
        if (sourceNs == null) {
            if (debug) {
                LOGGER.log(Level.WARNING, "can not map unknown namespace " + ns);
            }
            return ns;
        }
        Ns targetNs = targetMap.get(sourceNs.getId());
        if (targetNs == null) {
            if (debug) {
                LOGGER.log(Level.WARNING, "missing namespace " + sourceNs.getValue() + " id:" + sourceNs.getId() + " canonical:" + sourceNs.getCanonical());
            }
            return ns;
        }
        return targetNs.getValue();
    }

    @Override
    public String getLang() {
        String lang = this.getGeneral().getLang();
        return lang;
    }

    @Override
    public String getVersion() throws Exception {
        String mediawikiVersion = this.getGeneral().getGenerator();
        return mediawikiVersion;
    }
}

