/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.mediawiki.japi.jaxb;

import com.bitplan.mediawiki.japi.jaxb.JaxbFactoryApi;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;

public class JaxbFactory<T>
implements JaxbFactoryApi<T> {
    final Class<T> classOfT;
    protected static Logger LOGGER = Logger.getLogger("com.bitplan.mediawiki.japi.jaxb");

    public Class<T> getClassOfT() {
        return this.classOfT;
    }

    public JaxbFactory(Class<T> pClassOfT) {
        this.classOfT = pClassOfT;
    }

    public Unmarshaller getUnmarshaller() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{this.classOfT});
        Unmarshaller u = context.createUnmarshaller();
        u.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                return true;
            }
        });
        return u;
    }

    public String fixXML(String xml) {
        String br;
        if ((xml = xml.trim()).contains(br = "<br />")) {
            String[] parts = xml.split(br);
            xml = parts[0];
        }
        return xml;
    }

    public T fromString(Unmarshaller u, String s) throws Exception {
        String xml = this.fixXML(s);
        StringReader stringReader = new StringReader(xml);
        Object result = null;
        try {
            Object unmarshalResult = u.unmarshal((Reader)stringReader);
            if (!this.classOfT.isInstance(unmarshalResult)) {
                String type = "null";
                if (unmarshalResult != null) {
                    type = unmarshalResult.getClass().getName();
                }
                String msg = "unmarshalling returned " + type + " but " + this.classOfT.getName() + " was expected";
                throw new Exception(msg);
            }
            result = unmarshalResult;
        }
        catch (JAXBException jex) {
            String msg = "JAXBException: " + jex.getMessage();
            LOGGER.log(Level.SEVERE, msg);
            LOGGER.log(Level.SEVERE, s);
            throw new Exception(msg, jex);
        }
        return (T)result;
    }

    @Override
    public T fromXML(String xml) throws Exception {
        Unmarshaller u = this.getUnmarshaller();
        u.setProperty("eclipselink.media-type", (Object)"application/xml");
        T result = this.fromString(u, xml);
        return result;
    }

    @Override
    public T fromJson(String json) throws Exception {
        Unmarshaller u = this.getUnmarshaller();
        u.setProperty("eclipselink.media-type", (Object)"application/json");
        T result = this.fromString(u, json);
        return result;
    }

    public Marshaller getMarshaller(T instance) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{instance.getClass()});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        return marshaller;
    }

    public String getString(Marshaller marshaller, T instance) throws JAXBException {
        StringWriter sw = new StringWriter();
        marshaller.marshal(instance, (Writer)sw);
        String result = sw.toString();
        return result;
    }

    @Override
    public String asJson(T instance) throws JAXBException {
        Marshaller marshaller = this.getMarshaller(instance);
        marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
        marshaller.setProperty("eclipselink.json.include-root", (Object)true);
        String result = this.getString(marshaller, instance);
        return result;
    }

    @Override
    public String asXML(T instance) throws JAXBException {
        Marshaller marshaller = this.getMarshaller(instance);
        marshaller.setProperty("eclipselink.media-type", (Object)"application/xml");
        String result = this.getString(marshaller, instance);
        return result;
    }
}

