/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.mediawiki.japi.user;

import com.bitplan.mediawiki.japi.user.Crypt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class WikiUser {
    protected static Logger LOGGER = Logger.getLogger("com.bitplan.mediawiki.japi.user");
    public static boolean testMode = false;
    @Option(name="-h", aliases={"--help"}, usage="help\nshow this usage")
    boolean showHelp = false;
    @Option(name="-s", aliases={"--scriptPath"}, usage="scriptPath")
    String scriptPath = "/";
    @Option(name="-l", aliases={"--url"}, usage="url")
    private String url;
    @Option(name="-u", aliases={"--user"}, usage="username")
    String username;
    @Option(name="-p", aliases={"--password"}, usage="password")
    String password;
    @Option(name="-e", aliases={"--email"}, usage="email")
    String email;
    @Option(name="-w", aliases={"--wikiId"}, usage="wiki id")
    String wikiId;
    @Option(name="-t", aliases={"--test"}, usage="test")
    boolean test = false;
    @Option(name="-a", aliases={"--all"}, usage="all available wikis")
    boolean all = false;
    @Option(name="-v", aliases={"--version"}, usage="version of the wiki")
    String version = null;
    @Option(name="-y", aliases={"--store"}, usage="store without asking")
    boolean yes = false;
    private CmdLineParser parser;

    public WikiUser(String wikiId, String url, String scriptPath) {
        this.wikiId = wikiId;
        this.url = url;
        this.scriptPath = scriptPath;
    }

    public WikiUser() {
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getWikiId() {
        return this.wikiId;
    }

    public void setWikiId(String wikiId) {
        this.wikiId = wikiId;
    }

    public String getInput(String name, BufferedReader br) throws IOException {
        System.out.print("Please Enter " + name + ": ");
        String value = br.readLine();
        return value;
    }

    public static File getPropertyDir() {
        String userPropertiesFileDir = System.getProperty("user.home") + "/.mediawiki-japi";
        File propertydir = new File(userPropertiesFileDir);
        if (!propertydir.exists()) {
            propertydir.mkdirs();
        }
        return propertydir;
    }

    public static List<File> getPropertyFiles() {
        ArrayList<File> files = new ArrayList<File>();
        File propertyDir = WikiUser.getPropertyDir();
        for (String propertyFileName : propertyDir.list()) {
            if (!propertyFileName.endsWith(".ini")) continue;
            files.add(new File(propertyDir, propertyFileName));
        }
        return files;
    }

    public static File getPropertyFile(String wikiId, String user) {
        String userPropertiesFileName = user + "_" + wikiId + ".ini";
        File propFile = new File(WikiUser.getPropertyDir(), userPropertiesFileName);
        return propFile;
    }

    public static Properties getProperties(String wikiId, String user) throws FileNotFoundException, IOException {
        File propFile = WikiUser.getPropertyFile(wikiId, user);
        return WikiUser.getProperties(propFile);
    }

    public static Properties getProperties(File propFile) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        props.load(new FileReader(propFile));
        return props;
    }

    public static WikiUser getUser(String wikiId) {
        String user = WikiUser.getSystemUserName();
        return WikiUser.getUser(wikiId, user);
    }

    public static String getSystemUserName() {
        return System.getProperty("user.name");
    }

    public static WikiUser getUser(String wikiId, String user) {
        WikiUser result = null;
        try {
            Properties props = WikiUser.getProperties(wikiId, user);
            result = new WikiUser();
            result.initFromProperties(props);
        }
        catch (FileNotFoundException e) {
            String msg = WikiUser.help(wikiId, user);
            LOGGER.log(Level.SEVERE, msg);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage());
        }
        catch (GeneralSecurityException e) {
            LOGGER.log(Level.SEVERE, e.getMessage());
        }
        return result;
    }

    public void initFromProperties(Properties props) throws GeneralSecurityException, IOException {
        this.setWikiId(props.getProperty("wikiId"));
        this.setUsername(props.getProperty("user"));
        this.setEmail(props.getProperty("email"));
        this.setUrl(props.getProperty("url"));
        this.setScriptPath(props.getProperty("scriptPath"));
        this.setVersion(props.getProperty("version"));
        Crypt pcf = new Crypt(props.getProperty("cypher"), props.getProperty("salt"));
        this.setPassword(pcf.decrypt(props.getProperty("secret")));
    }

    public void createIniFile() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            if (this.wikiId == null) {
                this.wikiId = this.getInput("wiki id", br);
            }
            if (this.url == null) {
                this.url = this.getInput("url", br);
            }
            if (this.scriptPath == null) {
                this.scriptPath = this.getInput("scriptPath", br);
            }
            if (this.username == null) {
                this.username = this.getInput("username", br);
            }
            if (this.email == null) {
                this.email = this.getInput("email", br);
            }
            if (this.password == null) {
                this.password = this.getInput("password", br);
            }
            File propFile = WikiUser.getPropertyFile(this.wikiId, WikiUser.getSystemUserName());
            if (!this.yes) {
                String remember = this.getInput("shall i store " + this.username + "'s credentials encrypted in " + propFile.getName() + " y/n?", br);
                this.yes = remember.trim().toLowerCase().startsWith("y");
            }
            if (this.yes) {
                Crypt lCrypt = Crypt.getRandomCrypt();
                Properties props = new Properties();
                props.setProperty("wikiId", this.wikiId);
                props.setProperty("cypher", lCrypt.getCypher());
                props.setProperty("salt", lCrypt.getSalt());
                props.setProperty("url", this.url);
                props.setProperty("scriptPath", this.scriptPath);
                props.setProperty("user", this.username);
                props.setProperty("email", this.email);
                if (this.version != null) {
                    props.setProperty("version", this.version);
                }
                props.setProperty("secret", lCrypt.encrypt(this.password));
                FileOutputStream propsStream = new FileOutputStream(propFile);
                props.store(propsStream, "Mediawiki JAPI credentials for " + this.wikiId);
                propsStream.close();
                System.out.println("created/updated properties in " + propFile.getPath());
            }
        }
        catch (IOException e1) {
            LOGGER.log(Level.SEVERE, e1.getMessage());
        }
        catch (GeneralSecurityException e1) {
            LOGGER.log(Level.SEVERE, e1.getMessage());
        }
    }

    public static String help(String wikiId, String user) {
        File propFile = WikiUser.getPropertyFile(wikiId, user);
        String help = "Need to be able to read Credentials for wiki withid \n\t" + wikiId + "\nfrom " + propFile.getPath() + "\n";
        help = help + "Please run \n";
        help = help + "\tjava -cp target/classes com.bitplan.mediawiki.japi.user.WikiUser " + wikiId + "\n";
        help = help + "to create it. Then restart your tests.\n";
        help = help + "see http://mediawiki-japi.bitplan.com/index.php/CommandLine\n";
        help = help + "for more options and details";
        return help;
    }

    public boolean testPropertyFile(File propFile) {
        boolean problem = true;
        try {
            Properties props = WikiUser.getProperties(propFile);
            this.initFromProperties(props);
            problem = this.url == null || this.scriptPath == null;
            String info = String.format("%s %s:\n\turl=%s\n\tscriptPath=%s\n\tuser=%s\n\te-mail=%s", propFile.getName(), problem ? "\u274c" : "\u2705", this.url == null ? "?" : this.url, this.scriptPath == null ? "?" : this.scriptPath, this.username, this.email);
            if (problem) {
                System.err.println(info);
            } else {
                System.out.println(info);
            }
        }
        catch (Exception e) {
            String msg = String.format("error %s with property file %s", e.getMessage(), propFile.getPath());
            System.err.println(msg);
        }
        return !problem;
    }

    public void showHelp() {
        String usageMsg = String.format("  usage: java %s\nPlease visit http://mediawiki-japi.bitplan.com for usage instructions\n", this.getClass().getName());
        System.err.println(usageMsg);
        this.parser.printUsage((OutputStream)System.err);
    }

    public int maininstance(String[] args) {
        int returnCode = 0;
        try {
            this.parser = new CmdLineParser((Object)this);
            this.parser.parseArgument(args);
            if (this.showHelp) {
                this.showHelp();
            } else if (this.test) {
                if (this.all) {
                    for (File propertyFile : WikiUser.getPropertyFiles()) {
                        if (this.testPropertyFile(propertyFile)) continue;
                        ++returnCode;
                    }
                } else {
                    File propFile = WikiUser.getPropertyFile(this.wikiId, this.username);
                    if (!this.testPropertyFile(propFile)) {
                        ++returnCode;
                    }
                }
                String msg = String.format("There are %3d problems", returnCode);
                System.err.println(msg);
            } else {
                this.createIniFile();
            }
        }
        catch (CmdLineException e) {
            this.parser.printUsage((OutputStream)System.err);
            return 1;
        }
        return returnCode;
    }

    public static int main(String[] args) {
        WikiUser wikiUser = new WikiUser();
        return wikiUser.maininstance(args);
    }
}

