/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import com.bitplan.mediawiki.japi.MediaWikiApiImpl;
import com.bitplan.mediawiki.japi.MediawikiApi;
import com.bitplan.mediawiki.japi.SiteInfo;
import com.bitplan.mediawiki.japi.api.Api;
import com.bitplan.mediawiki.japi.api.Bl;
import com.bitplan.mediawiki.japi.api.Delete;
import com.bitplan.mediawiki.japi.api.Edit;
import com.bitplan.mediawiki.japi.api.General;
import com.bitplan.mediawiki.japi.api.Ii;
import com.bitplan.mediawiki.japi.api.Im;
import com.bitplan.mediawiki.japi.api.Img;
import com.bitplan.mediawiki.japi.api.Iu;
import com.bitplan.mediawiki.japi.api.Login;
import com.bitplan.mediawiki.japi.api.P;
import com.bitplan.mediawiki.japi.api.S;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import org.wikipedia.Wiki;

public class Mediawiki
extends MediaWikiApiImpl
implements MediawikiApi {
    Wiki wiki;
    private String domain;
    private String scriptPath;
    private String siteurl;
    private boolean debug;

    @Override
    public String getSiteurl() {
        return this.siteurl;
    }

    @Override
    public void setSiteurl(String siteurl) throws Exception {
        this.siteurl = siteurl;
        URL url = new URL(siteurl);
        this.domain = url.getHost();
        this.domain = this.domain.startsWith("www.") ? this.domain.substring(4) : this.domain;
        this.scriptPath = url.getPath();
        if ("".equals(this.scriptPath)) {
            this.scriptPath = "/w";
        }
        String prot = url.getProtocol();
        this.wiki = new Wiki(this.domain, this.scriptPath, prot + "://");
        this.wiki.setUsingCompressedRequests(false);
    }

    @Override
    public String getScriptPath() {
        return this.scriptPath;
    }

    @Override
    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    @Override
    public void init(String siteurl, String scriptPath) throws Exception {
        this.setSiteurl(siteurl + "/" + scriptPath);
    }

    @Override
    public String getVersion() throws Exception {
        String version = this.getSiteInfo().getVersion();
        return version;
    }

    public General getGeneral() throws Exception {
        Map<String, Object> siteinfo = this.wiki.getSiteInfo();
        String xml = (String)siteinfo.get("xml");
        Api api = super.fromXML(xml);
        General result = api.getQuery().getGeneral();
        return result;
    }

    @Override
    public Login login(String username, String password) throws Exception {
        this.wiki.login(username, password);
        Login result = new Login();
        return result;
    }

    @Override
    public boolean isLoggedIn() {
        boolean result = this.wiki.user != null;
        return result;
    }

    @Override
    public String getPageContent(String pageTitle) throws Exception {
        String result = this.wiki.getPageText(pageTitle);
        return result;
    }

    @Override
    public String getPageHtml(String pageTitle) throws Exception {
        String result = this.wiki.getRenderedText(pageTitle);
        return result;
    }

    @Override
    public String getSectionText(String pageTitle, int sectionNumber) throws Exception {
        return this.wiki.getSectionText(pageTitle, sectionNumber);
    }

    @Override
    public void logout() throws Exception {
        this.wiki.logout();
    }

    @Override
    public Edit edit(String pageTitle, String text, String summary) throws Exception {
        Edit result = this.edit(pageTitle, text, summary, true, false, -2, null, null);
        return result;
    }

    @Override
    public Edit edit(String pageTitle, String text, String summary, boolean minor, boolean bot, int sectionNumber, String sectionTitle, Calendar basetime) throws Exception {
        Edit result = new Edit();
        String pageContent = this.getPageContent(pageTitle);
        if (pageContent != null && pageContent.contains(this.protectionMarker)) {
            LOGGER.log(Level.WARNING, "page " + pageTitle + " is protected!");
        } else if (sectionNumber == -1) {
            this.wiki.edit(pageTitle, text, sectionTitle, minor, bot, sectionNumber, basetime);
        } else {
            this.wiki.edit(pageTitle, text, summary, minor, bot, sectionNumber, basetime);
        }
        return result;
    }

    @Override
    public String getIsoTimeStamp() {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
        df.setTimeZone(tz);
        String nowAsISO = df.format(new Date());
        return nowAsISO;
    }

    @Override
    public void setDebug(boolean pDebug) {
        this.debug = pDebug;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void upload(File file, String filename, String contents, String reason) throws Exception {
        this.wiki.upload(file, filename, contents, reason);
    }

    @Override
    public List<P> getAllPages(String apfrom, int aplimit) throws Exception {
        return null;
    }

    @Override
    public List<S> getSections(String pageTitle) throws Exception {
        return null;
    }

    @Override
    public Ii getImageInfo(String pageTitle) throws Exception {
        return null;
    }

    @Override
    public void upload(Ii ii, String fileName, String pageContent) throws Exception {
    }

    @Override
    public SiteInfo getSiteInfo() throws Exception {
        return null;
    }

    @Override
    public Delete delete(String title, String reason) throws Exception {
        Delete result = new Delete();
        this.wiki.delete(title, reason);
        return result;
    }

    @Override
    public List<Img> getAllImagesByTimeStamp(String aistart, String aiend, int ailimit) {
        return null;
    }

    @Override
    public List<Bl> getBacklinks(String pageTitle, String params, int limit) throws Exception {
        return null;
    }

    @Override
    public List<Iu> getImageUsage(String imageTitle, String params, int limit) throws Exception {
        return null;
    }

    @Override
    public List<Im> getImagesOnPage(String pageTitle, int imLimit) throws Exception {
        return null;
    }

    @Override
    public List<Ii> getImageInfosForPage(String pageTitle, int limit) throws Exception {
        return null;
    }
}

