/*
 * Decompiled with CFR 0.152.
 */
package org.wikipedia;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.HttpRetryException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.CredentialException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.CredentialNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

public class Wiki
implements Serializable {
    public static final int MEDIA_NAMESPACE = -2;
    public static final int SPECIAL_NAMESPACE = -1;
    public static final int MAIN_NAMESPACE = 0;
    public static final int TALK_NAMESPACE = 1;
    public static final int USER_NAMESPACE = 2;
    public static final int USER_TALK_NAMESPACE = 3;
    public static final int PROJECT_NAMESPACE = 4;
    public static final int PROJECT_TALK_NAMESPACE = 5;
    public static final int FILE_NAMESPACE = 6;
    public static final int FILE_TALK_NAMESPACE = 7;
    public static final int MEDIAWIKI_NAMESPACE = 8;
    public static final int MEDIAWIKI_TALK_NAMESPACE = 9;
    public static final int TEMPLATE_NAMESPACE = 10;
    public static final int TEMPLATE_TALK_NAMESPACE = 11;
    public static final int HELP_NAMESPACE = 12;
    public static final int HELP_TALK_NAMESPACE = 13;
    public static final int CATEGORY_NAMESPACE = 14;
    public static final int CATEGORY_TALK_NAMESPACE = 15;
    public static final int ALL_NAMESPACES = 167317762;
    public static final String ALL_LOGS = "";
    public static final String USER_CREATION_LOG = "newusers";
    public static final String UPLOAD_LOG = "upload";
    public static final String DELETION_LOG = "delete";
    public static final String MOVE_LOG = "move";
    public static final String BLOCK_LOG = "block";
    public static final String PROTECTION_LOG = "protect";
    public static final String USER_RIGHTS_LOG = "rights";
    public static final String USER_RENAME_LOG = "renameuser";
    public static final String IMPORT_LOG = "import";
    public static final String PATROL_LOG = "patrol";
    public static final String NO_PROTECTION = "all";
    public static final String SEMI_PROTECTION = "autoconfirmed";
    public static final String FULL_PROTECTION = "sysop";
    public static final int ASSERT_NONE = 0;
    public static final int ASSERT_USER = 1;
    public static final int ASSERT_BOT = 2;
    public static final int ASSERT_NO_MESSAGES = 4;
    public static final int ASSERT_SYSOP = 8;
    public static final int HIDE_ANON = 1;
    public static final int HIDE_BOT = 2;
    public static final int HIDE_SELF = 4;
    public static final int HIDE_MINOR = 8;
    public static final int HIDE_PATROLLED = 16;
    public static final long NEXT_REVISION = -1L;
    public static final long CURRENT_REVISION = -2L;
    public static final long PREVIOUS_REVISION = -3L;
    private static final String version = "0.30";
    private String domain;
    protected String query;
    protected String base;
    protected String apiUrl;
    protected String scriptPath = "/w";
    private boolean wgCapitalLinks = true;
    private String timezone = "UTC";
    private Map<String, String> cookies = new HashMap<String, String>(12);
    User user;
    private int statuscounter = 0;
    private transient LinkedHashMap<String, Integer> namespaces = null;
    private transient List<String> watchlist = null;
    private int max = 500;
    private int slowmax = 50;
    private int throttle = 10000;
    private int maxlag = 5;
    private int assertion = 0;
    private transient int statusinterval = 100;
    private String useragent = "Wiki.java 0.30(https://github.com/MER-C/wiki-java/)";
    private boolean zipped = false;
    private boolean markminor = false;
    private boolean markbot = false;
    private boolean resolveredirect = false;
    private String protocol = "https://";
    private Level loglevel = Level.ALL;
    private static final Logger logger = Logger.getLogger("wiki");
    private boolean retry = true;
    private static final long serialVersionUID = -8745212681497643456L;
    private static final int CONNECTION_CONNECT_TIMEOUT_MSEC = 30000;
    private static final int CONNECTION_READ_TIMEOUT_MSEC = 180000;
    private static final int LOG2_CHUNK_SIZE = 22;

    public Wiki() {
        this("en.wikipedia.org", "/w");
    }

    public Wiki(String domain) {
        this(domain, "/w");
    }

    public Wiki(String domain, String scriptPath) {
        this(domain, scriptPath, "https://");
    }

    public Wiki(String domain, String scriptPath, String protocol) {
        if (domain == null || domain.isEmpty()) {
            domain = "en.wikipedia.org";
        }
        this.domain = domain;
        this.scriptPath = scriptPath;
        this.protocol = protocol;
        logger.setLevel(this.loglevel);
        this.log(Level.CONFIG, "<init>", "Using Wiki.java 0.30");
        this.initVars();
    }

    protected void initVars() {
        StringBuilder basegen = new StringBuilder(this.protocol);
        basegen.append(this.domain);
        basegen.append(this.scriptPath);
        StringBuilder apigen = new StringBuilder(basegen);
        apigen.append("/api.php?format=xml&rawcontinue=1&");
        if (this.maxlag >= 0) {
            apigen.append("maxlag=");
            apigen.append(this.maxlag);
            apigen.append("&");
            basegen.append("/index.php?maxlag=");
            basegen.append(this.maxlag);
            basegen.append("&title=");
        } else {
            basegen.append("/index.php?title=");
        }
        this.base = basegen.toString();
        if ((this.assertion & 2) == 2) {
            apigen.append("assert=bot&");
        } else if ((this.assertion & 1) == 1) {
            apigen.append("assert=user&");
        }
        this.apiUrl = apigen.toString();
        apigen.append("action=query&");
        if (this.resolveredirect) {
            apigen.append("redirects&");
        }
        this.query = apigen.toString();
    }

    public String getDomain() {
        return this.domain;
    }

    public int getThrottle() {
        return this.throttle;
    }

    public void setThrottle(int throttle) {
        this.throttle = throttle;
        this.log(Level.CONFIG, "setThrottle", "Throttle set to " + throttle + " milliseconds");
    }

    @Deprecated
    public String getScriptPath() throws IOException {
        return (String)this.getSiteInfo().get("scriptpath");
    }

    @Deprecated
    public boolean isUsingCapitalLinks() throws IOException {
        return (Boolean)this.getSiteInfo().get("usingcapitallinks");
    }

    public Map<String, Object> getSiteInfo() throws IOException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String line = this.fetch(this.query + "action=query&meta=siteinfo", "getSiteInfo");
        this.wgCapitalLinks = this.parseAttribute(line, "case", 0).equals("first-letter");
        ret.put("usingcapitallinks", this.wgCapitalLinks);
        this.scriptPath = this.parseAttribute(line, "scriptpath", 0);
        ret.put("scriptpath", this.scriptPath);
        this.timezone = this.parseAttribute(line, "timezone", 0);
        ret.put("timezone", this.timezone);
        ret.put("version", this.parseAttribute(line, "generator", 0));
        this.initVars();
        return ret;
    }

    public void setUserAgent(String useragent) {
        this.useragent = useragent;
    }

    public String getUserAgent() {
        return this.useragent;
    }

    public void setUsingCompressedRequests(boolean zipped) {
        this.zipped = zipped;
    }

    public boolean isUsingCompressedRequests() {
        return this.zipped;
    }

    public boolean isResolvingRedirects() {
        return this.resolveredirect;
    }

    public void setResolveRedirects(boolean b) {
        this.resolveredirect = b;
        this.initVars();
    }

    public void setMarkBot(boolean markbot) {
        this.markbot = markbot;
    }

    public boolean isMarkBot() {
        return this.markbot;
    }

    public void setMarkMinor(boolean minor) {
        this.markminor = minor;
    }

    public boolean isMarkMinor() {
        return this.markminor;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Wiki)) {
            return false;
        }
        return this.domain.equals(((Wiki)obj).domain);
    }

    public int hashCode() {
        return this.domain.hashCode() * this.maxlag - this.throttle;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("Wiki[domain=");
        buffer.append(this.domain);
        buffer.append(",user=");
        buffer.append(this.user != null ? this.user.toString() : "null");
        buffer.append(",");
        buffer.append("throttle=");
        buffer.append(this.throttle);
        buffer.append(",maxlag=");
        buffer.append(this.maxlag);
        buffer.append(",assertionMode=");
        buffer.append(this.assertion);
        buffer.append(",statusCheckInterval=");
        buffer.append(this.statusinterval);
        buffer.append(",cookies=");
        buffer.append(this.cookies);
        buffer.append("]");
        return buffer.toString();
    }

    public int getMaxLag() {
        return this.maxlag;
    }

    public void setMaxLag(int lag) {
        this.maxlag = lag;
        this.log(Level.CONFIG, "setMaxLag", "Setting maximum allowable database lag to " + lag);
        this.initVars();
    }

    public int getAssertionMode() {
        return this.assertion;
    }

    public void setAssertionMode(int mode) {
        this.assertion = mode;
        this.log(Level.CONFIG, "setAssertionMode", "Set assertion mode to " + mode);
        this.initVars();
    }

    public int getStatusCheckInterval() {
        return this.statusinterval;
    }

    public void setStatusCheckInterval(int interval) {
        this.statusinterval = interval;
        this.log(Level.CONFIG, "setStatusCheckInterval", "Status check interval set to " + interval);
    }

    public void setLogLevel(Level loglevel) {
        this.loglevel = loglevel;
        logger.setLevel(loglevel);
    }

    public synchronized void login(String username, char[] password) throws IOException, FailedLoginException {
        boolean apihighlimit;
        username = this.normalize(username);
        StringBuilder buffer = new StringBuilder(500);
        buffer.append("lgname=");
        buffer.append(URLEncoder.encode(username, "UTF-8"));
        String response = this.post(this.apiUrl + "action=login", buffer.toString(), "login");
        String wpLoginToken = this.parseAttribute(response, "token", 0);
        buffer.append("&lgpassword=");
        buffer.append(URLEncoder.encode(new String(password), "UTF-8"));
        buffer.append("&lgtoken=");
        buffer.append(URLEncoder.encode(wpLoginToken, "UTF-8"));
        String line = this.post(this.apiUrl + "action=login", buffer.toString(), "login");
        buffer = null;
        if (line.contains("result=\"Success\"")) {
            this.user = new User(username);
            apihighlimit = this.user.isAllowedTo("apihighlimits");
            if (apihighlimit) {
                this.max = 5000;
                this.slowmax = 500;
            }
        } else {
            this.log(Level.WARNING, "login", "Failed to log in as " + username);
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (line.contains("WrongPass") || line.contains("WrongPluginPass")) {
                throw new FailedLoginException("Login failed: incorrect password.");
            }
            if (line.contains("NotExists")) {
                throw new FailedLoginException("Login failed: user does not exist.");
            }
            throw new FailedLoginException("Login failed: unknown reason.");
        }
        this.log(Level.INFO, "login", "Successfully logged in as " + username + ", highLimit = " + apihighlimit);
    }

    public synchronized void login(String username, String password) throws IOException, FailedLoginException {
        this.login(username, password.toCharArray());
    }

    public synchronized void logout() {
        this.cookies.clear();
        this.user = null;
        this.max = 500;
        this.slowmax = 50;
        this.log(Level.INFO, "logout", "Logged out");
    }

    public synchronized void logoutServerSide() throws IOException {
        this.fetch(this.apiUrl + "action=logout", "logoutServerSide");
        this.logout();
    }

    public boolean hasNewMessages() throws IOException {
        String url = this.query + "meta=userinfo&uiprop=hasmsg";
        return this.fetch(url, "hasNewMessages").contains("messages=\"\"");
    }

    public int getCurrentDatabaseLag() throws IOException {
        String line = this.fetch(this.query + "meta=siteinfo&siprop=dbrepllag", "getCurrentDatabaseLag");
        String lag = this.parseAttribute(line, "lag", 0);
        this.log(Level.INFO, "getCurrentDatabaseLag", "Current database replication lag is " + lag + " seconds");
        return Integer.parseInt(lag);
    }

    public Map<String, Integer> getSiteStatistics() throws IOException {
        String text = this.fetch(this.query + "meta=siteinfo&siprop=statistics", "getSiteStatistics");
        HashMap<String, Integer> ret = new HashMap<String, Integer>(20);
        ret.put("pages", Integer.parseInt(this.parseAttribute(text, "pages", 0)));
        ret.put("articles", Integer.parseInt(this.parseAttribute(text, "articles", 0)));
        ret.put("files", Integer.parseInt(this.parseAttribute(text, "images", 0)));
        ret.put("users", Integer.parseInt(this.parseAttribute(text, "users", 0)));
        ret.put("activeusers", Integer.parseInt(this.parseAttribute(text, "activeusers", 0)));
        ret.put("admins", Integer.parseInt(this.parseAttribute(text, "admins", 0)));
        ret.put("jobs", Integer.parseInt(this.parseAttribute(text, "jobs", 0)));
        return ret;
    }

    @Deprecated
    public String version() throws IOException {
        return (String)this.getSiteInfo().get("version");
    }

    public String parse(String markup) throws IOException {
        String response = this.post(this.apiUrl + "action=parse", "prop=text&text=" + URLEncoder.encode(markup, "UTF-8"), "parse");
        int y = response.indexOf(62, response.indexOf("<text")) + 1;
        int z = response.indexOf("</text>");
        return this.decode(response.substring(y, z));
    }

    protected String parseAndCleanup(String in) throws IOException {
        String output = this.parse(in);
        output = output.replace("<p>", ALL_LOGS).replace("</p>", ALL_LOGS);
        output = output.replace("\n", ALL_LOGS);
        int a = output.indexOf("<!--");
        return output.substring(0, a);
    }

    public String random() throws IOException {
        return this.random(0);
    }

    public String random(int ... ns) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("list=random");
        this.constructNamespaceString(url, "rn", ns);
        String line = this.fetch(url.toString(), "random");
        return this.parseAttribute(line, "title", 0);
    }

    public static String[] intersection(String[] a, String[] b) {
        ArrayList<String> aa = new ArrayList<String>(5000);
        aa.addAll(Arrays.asList(a));
        aa.retainAll(Arrays.asList(b));
        return aa.toArray(new String[aa.size()]);
    }

    public static String[] relativeComplement(String[] a, String[] b) {
        ArrayList<String> aa = new ArrayList<String>(5000);
        aa.addAll(Arrays.asList(a));
        aa.removeAll(Arrays.asList(b));
        return aa.toArray(new String[aa.size()]);
    }

    public String getTalkPage(String title) throws IOException {
        int namespace = this.namespace(title);
        if (namespace % 2 == 1) {
            throw new IllegalArgumentException("Cannot fetch talk page of a talk page!");
        }
        if (namespace < 0) {
            throw new IllegalArgumentException("Special: and Media: pages do not have talk pages!");
        }
        if (namespace != 0) {
            title = title.substring(title.indexOf(58) + 1);
        }
        return this.namespaceIdentifier(namespace + 1) + ":" + title;
    }

    public Map getPageInfo(String page) throws IOException {
        return this.getPageInfo(new String[]{page})[0];
    }

    public Map[] getPageInfo(String[] pages) throws IOException {
        String[] titles;
        Map[] info = new HashMap[pages.length];
        StringBuilder url = new StringBuilder(this.query);
        url.append("prop=info&intoken=edit%7Cwatch&inprop=protection%7Cdisplaytitle%7Cwatchers&titles=");
        for (String temp : titles = this.constructTitleString(pages)) {
            String line = this.fetch(url.toString() + temp, "getPageInfo");
            int j = line.indexOf("<page ");
            while (j > 0) {
                int x = line.indexOf("</page>", j);
                String item = line.substring(j, x);
                HashMap<String, Object> tempmap = new HashMap<String, Object>(15);
                boolean exists = !item.contains("missing=\"\"");
                tempmap.put("exists", exists);
                if (exists) {
                    tempmap.put("lastpurged", this.timestampToCalendar(this.parseAttribute(item, "touched", 0), true));
                    tempmap.put("lastrevid", Long.parseLong(this.parseAttribute(item, "lastrevid", 0)));
                    tempmap.put("size", Integer.parseInt(this.parseAttribute(item, "length", 0)));
                    tempmap.put("pageid", Long.parseLong(this.parseAttribute(item, "pageid", 0)));
                } else {
                    tempmap.put("lastedited", null);
                    tempmap.put("lastrevid", -1L);
                    tempmap.put("size", -1);
                    tempmap.put("pageid", -1);
                }
                HashMap<String, Object> protectionstate = new HashMap<String, Object>();
                int z = item.indexOf("<pr ");
                while (z > 0) {
                    String type = this.parseAttribute(item, "type", z);
                    String level = this.parseAttribute(item, "level", z);
                    protectionstate.put(type, level);
                    String expiry = this.parseAttribute(item, "expiry", z);
                    if (expiry.equals("infinity")) {
                        protectionstate.put(type + "expiry", null);
                    } else {
                        protectionstate.put(type + "expiry", this.timestampToCalendar(expiry, true));
                    }
                    if (item.contains("source=\"")) {
                        protectionstate.put("cascadesource", this.parseAttribute(item, "source", z));
                    }
                    ++z;
                    z = item.indexOf("<pr ", z);
                }
                String parsedtitle = this.parseAttribute(item, "title", 0);
                if (this.namespace(parsedtitle) == 8) {
                    protectionstate.put("edit", FULL_PROTECTION);
                    protectionstate.put(MOVE_LOG, FULL_PROTECTION);
                    if (!exists) {
                        protectionstate.put("create", FULL_PROTECTION);
                    }
                }
                protectionstate.put("cascade", item.contains("cascade=\"\""));
                tempmap.put("protection", protectionstate);
                tempmap.put("displaytitle", this.parseAttribute(item, "displaytitle", 0));
                tempmap.put("token", this.parseAttribute(item, "edittoken", 0));
                tempmap.put("timestamp", this.makeCalendar());
                if (this.user != null) {
                    tempmap.put("watchtoken", this.parseAttribute(item, "watchtoken", 0));
                }
                if (item.contains("watchers=\"")) {
                    tempmap.put("watchers", Integer.parseInt(this.parseAttribute(item, "watchers", 0)));
                }
                for (int i = 0; i < pages.length; ++i) {
                    if (!this.normalize(pages[i]).equals(parsedtitle)) continue;
                    info[i] = tempmap;
                }
                ++j;
                j = line.indexOf("<page ", j);
            }
        }
        this.log(Level.INFO, "getPageInfo", "Successfully retrieved page info for " + Arrays.toString(pages));
        return info;
    }

    public int namespace(String title) throws IOException {
        if (this.namespaces == null) {
            this.populateNamespaceCache();
        }
        if (!title.contains(":")) {
            return 0;
        }
        String namespace = title.substring(0, title.indexOf(58));
        if (!this.namespaces.containsKey(namespace)) {
            return 0;
        }
        return this.namespaces.get(namespace);
    }

    public String namespaceIdentifier(int namespace) throws IOException {
        if (this.namespaces == null) {
            this.populateNamespaceCache();
        }
        if (!this.namespaces.containsValue(namespace)) {
            return ALL_LOGS;
        }
        for (Map.Entry<String, Integer> entry : this.namespaces.entrySet()) {
            if (!entry.getValue().equals(namespace)) continue;
            return entry.getKey();
        }
        return ALL_LOGS;
    }

    public LinkedHashMap<String, Integer> getNamespaces() throws IOException {
        if (this.namespaces == null) {
            this.populateNamespaceCache();
        }
        return (LinkedHashMap)this.namespaces.clone();
    }

    protected void populateNamespaceCache() throws IOException {
        String line = this.fetch(this.query + "meta=siteinfo&siprop=namespaces%7Cnamespacealiases", "namespace");
        this.namespaces = new LinkedHashMap(30);
        int a = line.indexOf("<ns ");
        while (a > 0) {
            int ns = Integer.parseInt(this.parseAttribute(line, "id", a));
            int b = line.indexOf(62, a) + 1;
            int c = line.indexOf(60, b);
            this.namespaces.put(this.normalize(this.decode(line.substring(b, c))), ns);
            String canonicalnamespace = this.parseAttribute(line, "canonical", a);
            if (canonicalnamespace != null) {
                this.namespaces.put(canonicalnamespace, ns);
            }
            ++a;
            a = line.indexOf("<ns ", a);
        }
        this.log(Level.INFO, "namespace", "Successfully retrieved namespace list (" + this.namespaces.size() + " namespaces)");
    }

    public boolean[] exists(String[] titles) throws IOException {
        boolean[] ret = new boolean[titles.length];
        Map[] info = this.getPageInfo(titles);
        for (int i = 0; i < titles.length; ++i) {
            ret[i] = (Boolean)info[i].get("exists");
        }
        return ret;
    }

    public String getPageText(String title) throws IOException {
        if (this.namespace(title) < 0) {
            throw new UnsupportedOperationException("Cannot retrieve Special: or Media: pages!");
        }
        String url = this.base + URLEncoder.encode(this.normalize(title), "UTF-8") + "&action=raw";
        String temp = this.fetch(url, "getPageText");
        this.log(Level.INFO, "getPageText", "Successfully retrieved text of " + title);
        return temp;
    }

    public String getSectionText(String title, int number) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("prop=revisions&rvprop=content&titles=");
        url.append(URLEncoder.encode(title, "UTF-8"));
        url.append("&rvsection=");
        url.append(number);
        String text = this.fetch(url.toString(), "getSectionText");
        if (!text.contains("</rev>")) {
            return ALL_LOGS;
        }
        int a = text.indexOf("<rev ");
        a = text.indexOf("xml:space=\"preserve\">", a) + 21;
        int b = text.indexOf("</rev>", a);
        return this.decode(text.substring(a, b));
    }

    public String getRenderedText(String title) throws IOException {
        return this.parse("{{:" + title + "}}");
    }

    public void edit(String title, String text, String summary) throws IOException, LoginException {
        this.edit(title, text, summary, this.markminor, this.markbot, -2, null);
    }

    public void edit(String title, String text, String summary, Calendar basetime) throws IOException, LoginException {
        this.edit(title, text, summary, this.markminor, this.markbot, -2, basetime);
    }

    public void edit(String title, String text, String summary, int section) throws IOException, LoginException {
        this.edit(title, text, summary, this.markminor, this.markbot, section, null);
    }

    public void edit(String title, String text, String summary, int section, Calendar basetime) throws IOException, LoginException {
        this.edit(title, text, summary, this.markminor, this.markbot, section, basetime);
    }

    public synchronized void edit(String title, String text, String summary, boolean minor, boolean bot, int section, Calendar basetime) throws IOException, LoginException {
        long start = System.currentTimeMillis();
        Map info = this.getPageInfo(title);
        if (!this.checkRights(info, "edit") || ((Boolean)info.get("exists")).booleanValue() && !this.checkRights(info, "create")) {
            CredentialException ex = new CredentialException("Permission denied: page is protected.");
            this.log(Level.WARNING, "edit", "Cannot edit - permission denied. " + ex);
            throw ex;
        }
        String wpEditToken = (String)info.get("token");
        StringBuilder buffer = new StringBuilder(300000);
        buffer.append("title=");
        buffer.append(URLEncoder.encode(this.normalize(title), "UTF-8"));
        buffer.append("&text=");
        buffer.append(URLEncoder.encode(text, "UTF-8"));
        if (section != -1) {
            buffer.append("&summary=");
            buffer.append(URLEncoder.encode(summary, "UTF-8"));
        }
        buffer.append("&token=");
        buffer.append(URLEncoder.encode(wpEditToken, "UTF-8"));
        if (basetime != null) {
            buffer.append("&starttimestamp=");
            buffer.append(this.calendarToTimestamp((Calendar)info.get("timestamp")));
            buffer.append("&basetimestamp=");
            buffer.append(this.calendarToTimestamp(basetime));
        }
        if (minor) {
            buffer.append("&minor=1");
        }
        if (bot && this.user.isAllowedTo("bot")) {
            buffer.append("&bot=1");
        }
        if (section == -1) {
            buffer.append("&section=new&sectiontitle=");
            buffer.append(URLEncoder.encode(summary, "UTF-8"));
        } else if (section != -2) {
            buffer.append("&section=");
            buffer.append(section);
        }
        String response = this.post(this.apiUrl + "action=edit", buffer.toString(), "edit");
        if (response.contains("error code=\"editconflict\"")) {
            this.log(Level.WARNING, "edit", "Edit conflict on " + title);
            return;
        }
        try {
            this.checkErrorsAndUpdateStatus(response, "edit");
        }
        catch (IOException e) {
            if (this.retry) {
                this.retry = false;
                this.log(Level.WARNING, "edit", "Exception: " + e.getMessage() + " Retrying...");
                this.edit(title, text, summary, minor, bot, section, basetime);
            }
            this.log(Level.SEVERE, "edit", "EXCEPTION: " + e);
            throw e;
        }
        if (this.retry) {
            this.log(Level.INFO, "edit", "Successfully edited " + title);
        }
        this.retry = true;
        this.throttle(start);
    }

    public void newSection(String title, String subject, String text, boolean minor, boolean bot) throws IOException, LoginException {
        this.edit(title, text, subject, minor, bot, -1, null);
    }

    public void prepend(String title, String stuff, String summary, boolean minor, boolean bot) throws IOException, LoginException {
        StringBuilder text = new StringBuilder(100000);
        text.append(stuff);
        text.append(this.getSectionText(title, 0));
        this.edit(title, text.toString(), summary, minor, bot, 0, null);
    }

    public synchronized void delete(String title, String reason) throws IOException, LoginException {
        long start = System.currentTimeMillis();
        if (this.user == null || !this.user.isAllowedTo(DELETION_LOG)) {
            throw new CredentialNotFoundException("Cannot delete: Permission denied");
        }
        Map info = this.getPageInfo(title);
        if (!((Boolean)info.get("exists")).booleanValue()) {
            this.log(Level.INFO, DELETION_LOG, "Page \"" + title + "\" does not exist.");
            return;
        }
        String deleteToken = (String)info.get("token");
        StringBuilder buffer = new StringBuilder(500);
        buffer.append("title=");
        buffer.append(URLEncoder.encode(this.normalize(title), "UTF-8"));
        buffer.append("&reason=");
        buffer.append(URLEncoder.encode(reason, "UTF-8"));
        buffer.append("&token=");
        buffer.append(URLEncoder.encode(deleteToken, "UTF-8"));
        String response = this.post(this.apiUrl + "action=delete", buffer.toString(), DELETION_LOG);
        try {
            if (!response.contains("<delete title=")) {
                this.checkErrorsAndUpdateStatus(response, DELETION_LOG);
            }
        }
        catch (IOException e) {
            if (this.retry) {
                this.retry = false;
                this.log(Level.WARNING, DELETION_LOG, "Exception: " + e.getMessage() + " Retrying...");
                this.delete(title, reason);
            }
            this.log(Level.SEVERE, DELETION_LOG, "EXCEPTION: " + e);
            throw e;
        }
        if (this.retry) {
            this.log(Level.INFO, DELETION_LOG, "Successfully deleted " + title);
        }
        this.retry = true;
        this.throttle(start);
    }

    public synchronized void undelete(String title, String reason, Revision ... revisions) throws IOException, LoginException {
        long start = System.currentTimeMillis();
        if (this.user == null || !this.user.isAllowedTo("undelete")) {
            throw new CredentialNotFoundException("Cannot undelete: Permission denied");
        }
        String titleenc = URLEncoder.encode(this.normalize(title), "UTF-8");
        String delrev = this.query + "action=query&list=deletedrevs&drlimit=1&drprop=token&titles=" + titleenc;
        if (!delrev.contains("token=\"")) {
            this.log(Level.WARNING, "undelete", "Page \"" + title + "\" has no deleted revisions!");
            return;
        }
        String drtoken = this.parseAttribute(delrev, "token", 0);
        StringBuilder out = new StringBuilder("title=");
        out.append(titleenc);
        out.append("&reason=");
        out.append(URLEncoder.encode(reason, "UTF-8"));
        out.append("&token=");
        out.append(URLEncoder.encode(drtoken, "UTF-8"));
        if (revisions.length != 0) {
            out.append("&timestamps=");
            for (int i = 0; i < revisions.length - 1; ++i) {
                out.append(this.calendarToTimestamp(revisions[i].getTimestamp()));
                out.append("%7C");
            }
            out.append(this.calendarToTimestamp(revisions[revisions.length - 1].getTimestamp()));
        }
        String response = this.post(this.apiUrl + "action=undelete", out.toString(), "undelete");
        try {
            if (!response.contains("<undelete title=")) {
                this.checkErrorsAndUpdateStatus(response, "undelete");
            }
        }
        catch (IOException e) {
            if (this.retry) {
                this.retry = false;
                this.log(Level.WARNING, "undelete", "Exception: " + e.getMessage() + " Retrying...");
                this.undelete(title, reason, revisions);
            }
            this.log(Level.SEVERE, "undelete", "EXCEPTION: " + e);
            throw e;
        }
        if (this.retry) {
            this.log(Level.INFO, "undelete", "Successfully undeleted " + title);
        }
        this.retry = true;
        for (Revision rev : revisions) {
            rev.pageDeleted = false;
        }
        this.throttle(start);
    }

    public void purge(boolean links, String ... titles) throws IOException {
        String[] temp;
        StringBuilder url = new StringBuilder(this.apiUrl);
        url.append("action=purge");
        if (links) {
            url.append("&forcelinkupdate");
        }
        for (String x : temp = this.constructTitleString(titles)) {
            this.post(url.toString(), "&titles=" + x, "purge");
        }
        this.log(Level.INFO, "purge", "Successfully purged " + titles.length + " pages.");
    }

    public String[] getImagesOnPage(String title) throws IOException {
        String url = this.query + "prop=images&imlimit=max&titles=" + URLEncoder.encode(this.normalize(title), "UTF-8");
        String line = this.fetch(url, "getImagesOnPage");
        ArrayList<String> images = new ArrayList<String>(750);
        int a = line.indexOf("<im ");
        while (a > 0) {
            images.add(this.parseAttribute(line, "title", a));
            ++a;
            a = line.indexOf("<im ", a);
        }
        int temp = images.size();
        this.log(Level.INFO, "getImagesOnPage", "Successfully retrieved images used on " + title + " (" + temp + " images)");
        return images.toArray(new String[temp]);
    }

    public String[] getCategories(String title) throws IOException {
        return this.getCategories(title, false, false);
    }

    public String[] getCategories(String title, boolean sortkey, boolean ignoreHidden) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("prop=categories&cllimit=max");
        if (sortkey || ignoreHidden) {
            url.append("&clprop=sortkey%7Chidden");
        }
        url.append("&titles=");
        url.append(URLEncoder.encode(title, "UTF-8"));
        String line = this.fetch(url.toString(), "getCategories");
        ArrayList<String> categories = new ArrayList<String>(750);
        int a = line.indexOf("<cl ");
        while (a > 0) {
            int b = line.indexOf("<cl ", a + 1);
            if (!ignoreHidden || !line.substring(a, b > 0 ? b : line.length()).contains("hidden")) {
                String category = this.parseAttribute(line, "title", a);
                if (sortkey) {
                    category = category + "|" + this.parseAttribute(line, "sortkeyprefix", a);
                }
                categories.add(category);
            }
            a = b;
        }
        int temp = categories.size();
        this.log(Level.INFO, "getCategories", "Successfully retrieved categories of " + title + " (" + temp + " categories)");
        return categories.toArray(new String[temp]);
    }

    public String[] getTemplates(String title, int ... ns) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("prop=templates&tllimit=max&titles=");
        url.append(URLEncoder.encode(this.normalize(title), "UTF-8"));
        this.constructNamespaceString(url, "tl", ns);
        String line = this.fetch(url.toString(), "getTemplates");
        ArrayList<String> templates = new ArrayList<String>(750);
        int a = line.indexOf("<tl ");
        while (a > 0) {
            templates.add(this.parseAttribute(line, "title", a));
            ++a;
            a = line.indexOf("<tl ", a);
        }
        int size = templates.size();
        this.log(Level.INFO, "getTemplates", "Successfully retrieved templates used on " + title + " (" + size + " templates)");
        return templates.toArray(new String[size]);
    }

    public Map<String, String> getInterWikiLinks(String title) throws IOException {
        String url = this.query + "prop=langlinks&lllimit=max&titles=" + URLEncoder.encode(this.normalize(title), "UTF-8");
        String line = this.fetch(url, "getInterwikiLinks");
        HashMap<String, String> interwikis = new HashMap<String, String>(750);
        int a = line.indexOf("<ll ");
        while (a > 0) {
            String language = this.parseAttribute(line, "lang", a);
            int b = line.indexOf(62, a) + 1;
            int c = line.indexOf(60, b);
            String page = this.decode(line.substring(b, c));
            interwikis.put(language, page);
            ++a;
            a = line.indexOf("<ll ", a);
        }
        this.log(Level.INFO, "getInterWikiLinks", "Successfully retrieved interwiki links on " + title);
        return interwikis;
    }

    public String[] getLinksOnPage(String title) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("prop=links&pllimit=max&titles=");
        url.append(URLEncoder.encode(this.normalize(title), "UTF-8"));
        String plcontinue = null;
        ArrayList<String> links = new ArrayList<String>(750);
        do {
            String line = plcontinue == null ? this.fetch(url.toString(), "getLinksOnPage") : this.fetch(url.toString() + "&plcontinue=" + URLEncoder.encode(plcontinue, "UTF-8"), "getLinksOnPage");
            plcontinue = this.parseAttribute(line, "plcontinue", 0);
            int a = line.indexOf("<pl ");
            while (a > 0) {
                links.add(this.parseAttribute(line, "title", a));
                ++a;
                a = line.indexOf("<pl ", a);
            }
        } while (plcontinue != null);
        int size = links.size();
        this.log(Level.INFO, "getLinksOnPage", "Successfully retrieved links used on " + title + " (" + size + " links)");
        return links.toArray(new String[size]);
    }

    public String[] getExternalLinksOnPage(String title) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("prop=extlinks&ellimit=max&titles=");
        url.append(URLEncoder.encode(this.normalize(title), "UTF-8"));
        String eloffset = null;
        ArrayList<String> links = new ArrayList<String>(750);
        do {
            String line = eloffset == null ? this.fetch(url.toString(), "getExternalLinksOnPage") : this.fetch(url.toString() + "&eloffset=" + URLEncoder.encode(eloffset, "UTF-8"), "getExternalLinksOnPage");
            eloffset = this.parseAttribute(line, "eloffset", 0);
            int a = line.indexOf("<el ");
            while (a > 0) {
                int x = line.indexOf(62, a) + 1;
                int y = line.indexOf("</el>", x);
                links.add(this.decode(line.substring(x, y)));
                ++a;
                a = line.indexOf("<el ", a);
            }
        } while (eloffset != null);
        int size = links.size();
        this.log(Level.INFO, "getExternalLinksOnPage", "Successfully retrieved external links used on " + title + " (" + size + " links)");
        return links.toArray(new String[size]);
    }

    public LinkedHashMap<String, String> getSectionMap(String page) throws IOException {
        String url = this.apiUrl + "action=parse&text={{:" + URLEncoder.encode(page, "UTF-8") + "}}__TOC__&prop=sections";
        String line = this.fetch(url, "getSectionMap");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(30);
        int a = line.indexOf("<s ");
        while (a > 0) {
            String title = this.parseAttribute(line, "line", a);
            String number = this.parseAttribute(line, "number", a);
            map.put(number, title);
            ++a;
            a = line.indexOf("<s ", a);
        }
        this.log(Level.INFO, "getSectionMap", "Successfully retrieved section map for " + page);
        return map;
    }

    public Revision getTopRevision(String title) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("prop=revisions&rvlimit=1&rvtoken=rollback&titles=");
        url.append(URLEncoder.encode(this.normalize(title), "UTF-8"));
        url.append("&rvprop=timestamp%7Cuser%7Cids%7Cflags%7Csize%7Ccomment");
        String line = this.fetch(url.toString(), "getTopRevision");
        int a = line.indexOf("<rev ");
        int b = line.indexOf("/>", a);
        if (a < 0) {
            return null;
        }
        return this.parseRevision(line.substring(a, b), title);
    }

    public Revision getFirstRevision(String title) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("prop=revisions&rvlimit=1&rvdir=newer&titles=");
        url.append(URLEncoder.encode(this.normalize(title), "UTF-8"));
        url.append("&rvprop=timestamp%7Cuser%7Cids%7Cflags%7Csize%7Ccomment");
        String line = this.fetch(url.toString(), "getFirstRevision");
        int a = line.indexOf("<rev ");
        int b = line.indexOf("/>", a);
        if (a < 0) {
            return null;
        }
        return this.parseRevision(line.substring(a, b), title);
    }

    public String resolveRedirect(String title) throws IOException {
        return this.resolveRedirects(new String[]{title})[0];
    }

    public String[] resolveRedirects(String[] titles) throws IOException {
        String[] temp;
        StringBuilder url = new StringBuilder(this.query);
        if (!this.resolveredirect) {
            url.append("redirects&");
        }
        url.append("titles=");
        String[] ret = new String[titles.length];
        for (String blah : temp = this.constructTitleString(titles)) {
            String line = this.fetch(url.toString() + blah, "resolveRedirects");
            int j = line.indexOf("<r ");
            while (j > 0) {
                String parsedtitle = this.parseAttribute(line, "from", j);
                for (int i = 0; i < titles.length; ++i) {
                    if (!this.normalize(titles[i]).equals(parsedtitle)) continue;
                    ret[i] = this.parseAttribute(line, "to", j);
                }
                ++j;
                j = line.indexOf("<r ", j);
            }
        }
        return ret;
    }

    public Revision[] getPageHistory(String title) throws IOException {
        return this.getPageHistory(title, null, null, false);
    }

    public Revision[] getPageHistory(String title, Calendar start, Calendar end, boolean reverse) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("prop=revisions&rvlimit=max&titles=");
        url.append(URLEncoder.encode(this.normalize(title), "UTF-8"));
        url.append("&rvprop=timestamp%7Cuser%7Cids%7Cflags%7Csize%7Ccomment");
        if (reverse) {
            url.append("&rvdir=newer");
        }
        if (start != null) {
            url.append(reverse ? "&rvstart=" : "&rvend=");
            url.append(this.calendarToTimestamp(start));
        }
        if (end != null) {
            url.append(reverse ? "&rvend=" : "&rvstart=");
            url.append(this.calendarToTimestamp(end));
        }
        String rvcontinue = null;
        ArrayList<Revision> revisions = new ArrayList<Revision>(1500);
        do {
            String line = rvcontinue == null ? this.fetch(url.toString(), "getPageHistory") : this.fetch(url.toString() + "&rvcontinue=" + rvcontinue, "getPageHistory");
            rvcontinue = this.parseAttribute(line, "rvcontinue", 0);
            int a = line.indexOf("<rev ");
            while (a > 0) {
                int b = line.indexOf("/>", a);
                revisions.add(this.parseRevision(line.substring(a, b), title));
                ++a;
                a = line.indexOf("<rev ", a);
            }
        } while (rvcontinue != null);
        int size = revisions.size();
        Revision[] temp = revisions.toArray(new Revision[size]);
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                temp[i].next = temp[i - 1].revid;
            }
            if (i != size - 1) {
                temp[i].sizediff = temp[i].size - temp[i + 1].size;
                continue;
            }
            temp[i].sizediff = temp[i].size;
        }
        this.log(Level.INFO, "getPageHistory", "Successfully retrieved page history of " + title + " (" + size + " revisions)");
        return temp;
    }

    public Revision[] getDeletedHistory(String title) throws IOException, CredentialNotFoundException {
        return this.getDeletedHistory(title, null, null, false);
    }

    public Revision[] getDeletedHistory(String title, Calendar start, Calendar end, boolean reverse) throws IOException, CredentialNotFoundException {
        if (!this.user.isAllowedTo("deletedhistory")) {
            throw new CredentialNotFoundException("Permission denied: not able to view deleted history");
        }
        StringBuilder url = new StringBuilder(this.query);
        url.append("prop=deletedrevisions&drvprop=ids%7Cuser%7Cflags%7Csize%7Ccomment&drvlimit=max");
        if (reverse) {
            url.append("&drvdir=newer");
        }
        if (start != null) {
            url.append(reverse ? "&drvstart=" : "&drvend=");
            url.append(this.calendarToTimestamp(start));
        }
        if (end != null) {
            url.append(reverse ? "&drvend=" : "&drvstart=");
            url.append(this.calendarToTimestamp(end));
        }
        url.append("&titles=");
        url.append(URLEncoder.encode(title, "UTF-8"));
        String drvcontinue = null;
        ArrayList<Revision> delrevs = new ArrayList<Revision>(500);
        do {
            String response = drvcontinue != null ? this.fetch(url.toString() + "&drvcontinue=" + URLEncoder.encode(drvcontinue, "UTF-8"), "getDeletedHistory") : this.fetch(url.toString(), "getDeletedHistory");
            drvcontinue = this.parseAttribute(response, "drvcontinue", 0);
            int x = response.indexOf("<deletedrevs>");
            if (x < 0) break;
            x = response.indexOf("<page ", x);
            while (x > 0) {
                String deltitle = this.parseAttribute(response, "title", x);
                int y = response.indexOf("</page>", x);
                int z = response.indexOf("<rev ", x);
                while (z < y && z >= 0) {
                    int aa = response.indexOf(" />", z);
                    Revision temp = this.parseRevision(response.substring(z, aa), deltitle);
                    temp.pageDeleted = true;
                    delrevs.add(temp);
                    ++z;
                    z = response.indexOf("<rev ", z);
                }
                ++x;
                x = response.indexOf("<page ", x);
            }
        } while (drvcontinue != null);
        int size = delrevs.size();
        this.log(Level.INFO, "Successfully fetched " + size + " deleted revisions.", "deletedRevs");
        return delrevs.toArray(new Revision[size]);
    }

    public Revision[] deletedContribs(String u) throws IOException, CredentialNotFoundException {
        return this.deletedContribs(u, null, null, false, 167317762);
    }

    public Revision[] deletedContribs(String u, Calendar end, Calendar start, boolean reverse, int ... namespace) throws IOException, CredentialNotFoundException {
        if (!this.user.isAllowedTo("deletedhistory")) {
            throw new CredentialNotFoundException("Permission denied: not able to view deleted history");
        }
        StringBuilder url = new StringBuilder(this.query);
        url.append("list=alldeletedrevisions&adrprop=ids%7Cuser%7Cflags%7Csize%7Ccomment&adrlimit=max");
        if (reverse) {
            url.append("&adrdir=newer");
        }
        if (start != null) {
            url.append(reverse ? "&adrstart=" : "&adrend=");
            url.append(this.calendarToTimestamp(start));
        }
        if (end != null) {
            url.append(reverse ? "&adrend=" : "&adrstart=");
            url.append(this.calendarToTimestamp(end));
        }
        url.append("&adruser=");
        url.append(URLEncoder.encode(u, "UTF-8"));
        this.constructNamespaceString(url, "adr", namespace);
        String adrcontinue = null;
        ArrayList<Revision> delrevs = new ArrayList<Revision>(500);
        do {
            String response = adrcontinue != null ? this.fetch(url.toString() + "&adrcontinue=" + URLEncoder.encode(adrcontinue, "UTF-8"), "deletedContribs") : this.fetch(url.toString(), "deletedContribs");
            adrcontinue = this.parseAttribute(response, "adrcontinue", 0);
            int x = response.indexOf("<deletedrevs>");
            if (x < 0) break;
            x = response.indexOf("<page ", x);
            while (x > 0) {
                String deltitle = this.parseAttribute(response, "title", x);
                int y = response.indexOf("</page>", x);
                int z = response.indexOf("<rev ", x);
                while (z < y && z >= 0) {
                    int aa = response.indexOf(" />", z);
                    Revision temp = this.parseRevision(response.substring(z, aa), deltitle);
                    temp.pageDeleted = true;
                    delrevs.add(temp);
                    ++z;
                    z = response.indexOf("<rev ", z);
                }
                ++x;
                x = response.indexOf("<page ", x);
            }
        } while (adrcontinue != null);
        int size = delrevs.size();
        this.log(Level.INFO, "Successfully fetched " + size + " deleted revisions.", "deletedRevs");
        return delrevs.toArray(new Revision[size]);
    }

    public String[] deletedPrefixIndex(String prefix, int namespace) throws IOException, CredentialNotFoundException {
        if (!this.user.isAllowedTo("deletedhistory") || !this.user.isAllowedTo("deletedtext")) {
            throw new CredentialNotFoundException("Permission denied: not able to view deleted history or text.");
        }
        StringBuilder url = new StringBuilder(this.query);
        url.append("list=deletedrevs&drlimit=max&drunique=1&drdir=newer&drprefix=");
        url.append(URLEncoder.encode(prefix, "UTF-8"));
        url.append("&drnamespace=");
        url.append(namespace);
        String drcontinue = null;
        ArrayList<String> pages = new ArrayList<String>();
        do {
            String text = drcontinue == null ? this.fetch(url.toString(), "deletedPrefixIndex") : this.fetch(url.toString() + "&drcontinue=" + URLEncoder.encode(drcontinue, "UTF-8"), "deletedPrefixIndex");
            drcontinue = this.parseAttribute(text, drcontinue, 0);
            int x = text.indexOf("<page ", 0);
            while (x > 0) {
                pages.add(this.parseAttribute(text, "title", x));
                ++x;
                x = text.indexOf("<page ", x);
            }
        } while (drcontinue != null);
        int size = pages.size();
        this.log(Level.INFO, "deletedPrefixIndex", "Successfully retrieved deleted page list (" + size + " items).");
        return pages.toArray(new String[size]);
    }

    public String getDeletedText(String page) throws IOException, CredentialNotFoundException {
        if (!this.user.isAllowedTo("deletedhistory") || !this.user.isAllowedTo("deletedtext")) {
            throw new CredentialNotFoundException("Permission denied: not able to view deleted history or text.");
        }
        StringBuilder url = new StringBuilder(this.query);
        url.append("list=deletedrevs&drlimit=1&drprop=content&titles=");
        url.append(URLEncoder.encode(page, "UTF-8"));
        String line = this.fetch(url.toString(), "getDeletedText");
        int a = line.indexOf("<rev ");
        a = line.indexOf(">", a) + 1;
        int b = line.indexOf("</rev>", a);
        return line.substring(a, b);
    }

    public void move(String title, String newTitle, String reason) throws IOException, LoginException {
        this.move(title, newTitle, reason, false, true, false);
    }

    public synchronized void move(String title, String newTitle, String reason, boolean noredirect, boolean movetalk, boolean movesubpages) throws IOException, LoginException {
        long start = System.currentTimeMillis();
        if (this.user == null || !this.user.isAllowedTo(MOVE_LOG)) {
            CredentialNotFoundException ex = new CredentialNotFoundException("Permission denied: cannot move pages.");
            this.log(Level.SEVERE, MOVE_LOG, "Cannot move - permission denied: " + ex);
            throw ex;
        }
        if (this.namespace(title) == 14) {
            throw new UnsupportedOperationException("Tried to move a category.");
        }
        Map info = this.getPageInfo(title);
        if (!((Boolean)info.get("exists")).booleanValue()) {
            throw new IllegalArgumentException("Tried to move a non-existant page!");
        }
        if (!this.checkRights(info, MOVE_LOG)) {
            CredentialException ex = new CredentialException("Permission denied: page is protected.");
            this.log(Level.WARNING, MOVE_LOG, "Cannot move - permission denied. " + ex);
            throw ex;
        }
        String wpMoveToken = (String)info.get("token");
        StringBuilder buffer = new StringBuilder(10000);
        buffer.append("from=");
        buffer.append(URLEncoder.encode(title, "UTF-8"));
        buffer.append("&to=");
        buffer.append(URLEncoder.encode(newTitle, "UTF-8"));
        buffer.append("&reason=");
        buffer.append(URLEncoder.encode(reason, "UTF-8"));
        buffer.append("&token=");
        buffer.append(URLEncoder.encode(wpMoveToken, "UTF-8"));
        if (movetalk) {
            buffer.append("&movetalk=1");
        }
        if (noredirect && this.user.isAllowedTo("suppressredirect")) {
            buffer.append("&noredirect=1");
        }
        if (movesubpages && this.user.isAllowedTo("move-subpages")) {
            buffer.append("&movesubpages=1");
        }
        String response = this.post(this.apiUrl + "action=move", buffer.toString(), MOVE_LOG);
        try {
            if (!response.contains("move from")) {
                this.checkErrorsAndUpdateStatus(response, MOVE_LOG);
            }
        }
        catch (IOException e) {
            if (this.retry) {
                this.retry = false;
                this.log(Level.WARNING, MOVE_LOG, "Exception: " + e.getMessage() + " Retrying...");
                this.move(title, newTitle, reason, noredirect, movetalk, movesubpages);
            }
            this.log(Level.SEVERE, MOVE_LOG, "EXCEPTION: " + e);
            throw e;
        }
        if (this.retry) {
            this.log(Level.INFO, MOVE_LOG, "Successfully moved " + title + " to " + newTitle);
        }
        this.retry = true;
        this.throttle(start);
    }

    public synchronized void protect(String page, Map<String, Object> protectionstate, String reason) throws IOException, LoginException {
        if (this.user == null || !this.user.isAllowedTo(PROTECTION_LOG)) {
            throw new CredentialNotFoundException("Cannot protect: permission denied.");
        }
        long start = System.currentTimeMillis();
        Map info = this.getPageInfo(page);
        String protectToken = (String)info.get("token");
        StringBuilder out = new StringBuilder("title=");
        out.append(URLEncoder.encode(page, "UTF-8"));
        out.append("&reason=");
        out.append(URLEncoder.encode(reason, "UTF-8"));
        out.append("&token=");
        out.append(URLEncoder.encode(protectToken, "UTF-8"));
        if (protectionstate.containsKey("cascade")) {
            out.append("&cascade=1");
        }
        out.append("&protections=");
        StringBuilder temp = new StringBuilder();
        for (Map.Entry<String, Object> entry : protectionstate.entrySet()) {
            String key = entry.getKey();
            if (key.contains("expiry") || key.equals("cascade")) continue;
            out.append(key);
            out.append("=");
            out.append(entry.getValue());
            Calendar expiry = (Calendar)protectionstate.get(key + "expiry");
            temp.append(expiry == null ? "never" : this.calendarToTimestamp(expiry));
            out.append("%7C");
            temp.append("%7C");
        }
        out.delete(out.length() - 3, out.length());
        temp.delete(temp.length() - 3, temp.length());
        out.append("&expiry=");
        out.append((CharSequence)temp);
        System.out.println(out);
        String response = this.post(this.apiUrl + "action=protect", out.toString(), PROTECTION_LOG);
        try {
            if (!response.contains("<protect ")) {
                this.checkErrorsAndUpdateStatus(response, PROTECTION_LOG);
            }
        }
        catch (IOException e) {
            if (this.retry) {
                this.retry = false;
                this.log(Level.WARNING, PROTECTION_LOG, "Exception: " + e.getMessage() + " Retrying...");
                this.protect(page, protectionstate, reason);
            }
            this.log(Level.SEVERE, PROTECTION_LOG, "EXCEPTION: " + e);
            throw e;
        }
        if (this.retry) {
            this.log(Level.INFO, "edit", "Successfully protected " + page);
        }
        this.retry = true;
        this.throttle(start);
    }

    public void unprotect(String page, String reason) throws IOException, LoginException {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("edit", NO_PROTECTION);
        state.put(MOVE_LOG, NO_PROTECTION);
        if (this.namespace(page) == 6) {
            state.put(UPLOAD_LOG, NO_PROTECTION);
        }
        state.put("create", NO_PROTECTION);
        this.protect(page, state, reason);
    }

    public String export(String title) throws IOException {
        return this.fetch(this.query + "export&exportnowrap&titles=" + URLEncoder.encode(this.normalize(title), "UTF-8"), "export");
    }

    public Revision getRevision(long oldid) throws IOException {
        return this.getRevisions(new long[]{oldid})[0];
    }

    public Revision[] getRevisions(long[] oldids) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("prop=revisions&rvprop=ids%7Ctimestamp%7Cuser%7Ccomment%7Cflags%7Csize&revids=");
        String[] chunks = new String[oldids.length / this.slowmax + 1];
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < oldids.length; ++i) {
            buffer.append(oldids[i]);
            if (i == oldids.length - 1 || i == this.slowmax - 1) {
                chunks[i / this.slowmax] = buffer.toString();
                buffer = new StringBuilder();
                continue;
            }
            buffer.append("%7C");
        }
        Revision[] revisions = new Revision[oldids.length];
        for (String chunk : chunks) {
            String line = this.fetch(url.toString() + chunk, "getRevision");
            int i = line.indexOf("<page ");
            while (i > 0) {
                int z = line.indexOf("</page>", i);
                String title = this.parseAttribute(line, "title", i);
                int j = line.indexOf("<rev ", i);
                while (j > 0 && j < z) {
                    int y = line.indexOf("/>", j);
                    String blah = line.substring(j, y);
                    Revision rev = this.parseRevision(blah, title);
                    long oldid = rev.getRevid();
                    for (int k = 0; k < oldids.length; ++k) {
                        if (oldids[k] != oldid) continue;
                        revisions[k] = rev;
                    }
                    ++j;
                    j = line.indexOf("<rev ", j);
                }
                ++i;
                i = line.indexOf("<page ", i);
            }
        }
        return revisions;
    }

    public void rollback(Revision revision) throws IOException, LoginException {
        this.rollback(revision, this.markbot, ALL_LOGS);
    }

    public synchronized void rollback(Revision revision, boolean bot, String reason) throws IOException, LoginException {
        if (this.user == null || !this.user.isAllowedTo("rollback")) {
            throw new CredentialNotFoundException("Permission denied: cannot rollback.");
        }
        Revision top = this.getTopRevision(revision.getPage());
        if (!top.equals(revision)) {
            this.log(Level.INFO, "rollback", "Rollback failed: revision is not the most recent");
            return;
        }
        String token = URLEncoder.encode(top.getRollbackToken(), "UTF-8");
        StringBuilder buffer = new StringBuilder(10000);
        buffer.append("title=");
        buffer.append(URLEncoder.encode(this.normalize(revision.getPage()), "UTF-8"));
        buffer.append("&user=");
        buffer.append(URLEncoder.encode(this.normalize(revision.getUser()), "UTF-8"));
        buffer.append("&token=");
        buffer.append(token);
        if (bot && this.user.isAllowedTo("markbotedits")) {
            buffer.append("&markbot=1");
        }
        if (!reason.isEmpty()) {
            buffer.append("&summary=");
            buffer.append(reason);
        }
        String response = this.post(this.apiUrl + "action=rollback", buffer.toString(), "rollback");
        try {
            if (response.contains("alreadyrolled")) {
                this.log(Level.INFO, "rollback", "Edit has already been rolled back.");
            } else if (response.contains("onlyauthor")) {
                this.log(Level.INFO, "rollback", "Cannot rollback as the page only has one author.");
            } else if (!response.contains("rollback title=")) {
                this.checkErrorsAndUpdateStatus(response, "rollback");
            }
        }
        catch (IOException e) {
            if (this.retry) {
                this.retry = false;
                this.log(Level.WARNING, "rollback", "Exception: " + e.getMessage() + " Retrying...");
                this.rollback(revision, bot, reason);
            }
            this.log(Level.SEVERE, "rollback", "EXCEPTION: " + e);
            throw e;
        }
        if (this.retry) {
            this.log(Level.INFO, "rollback", "Successfully reverted edits by " + this.user + " on " + revision.getPage());
        }
        this.retry = true;
    }

    public synchronized void revisionDelete(Boolean hidecontent, Boolean hideuser, Boolean hidereason, String reason, Boolean suppress, Revision[] revisions) throws IOException, LoginException {
        long start = System.currentTimeMillis();
        if (this.user == null || !this.user.isAllowedTo("deleterevision") || !this.user.isAllowedTo("deletelogentry")) {
            throw new CredentialNotFoundException("Permission denied: cannot revision delete.");
        }
        String deltoken = (String)this.getPageInfo(revisions[0].getPage()).get("token");
        StringBuilder out = new StringBuilder("reason=");
        out.append(URLEncoder.encode(reason, "UTF-8"));
        out.append("&type=revision");
        out.append("&ids=");
        for (int i = 0; i < revisions.length - 1; ++i) {
            out.append(revisions[i].getRevid());
            out.append("%7C");
        }
        out.append(revisions[revisions.length - 1].getRevid());
        out.append("&token=");
        out.append(URLEncoder.encode(deltoken, "UTF-8"));
        if (this.user.isAllowedTo("suppressrevision") && suppress != null) {
            if (suppress.booleanValue()) {
                out.append("&suppress=yes");
            } else {
                out.append("&suppress=no");
            }
        }
        out.append("&hide=");
        StringBuilder temp = new StringBuilder("&show=");
        if (hidecontent == Boolean.TRUE) {
            out.append("content%7C");
        } else if (hidecontent == Boolean.FALSE) {
            temp.append("content%7C");
        }
        if (hideuser == Boolean.TRUE) {
            out.append("user%7C");
        } else if (hideuser == Boolean.FALSE) {
            temp.append("user%7C");
        }
        if (hidereason == Boolean.TRUE) {
            out.append("comment");
        } else if (hidereason == Boolean.FALSE) {
            temp.append("comment");
        }
        if (out.lastIndexOf("%7C") == out.length() - 2) {
            out.delete(out.length() - 2, out.length());
        }
        if (temp.lastIndexOf("%7C") == temp.length() - 2) {
            temp.delete(temp.length() - 2, temp.length());
        }
        out.append((CharSequence)temp);
        String response = this.post(this.apiUrl + "action=revisiondelete", out.toString(), "revisionDelete");
        try {
            if (!response.contains("<revisiondelete ")) {
                this.checkErrorsAndUpdateStatus(response, MOVE_LOG);
            }
        }
        catch (IOException e) {
            if (this.retry) {
                this.retry = false;
                this.log(Level.WARNING, "revisionDelete", "Exception: " + e.getMessage() + " Retrying...");
                this.revisionDelete(hidecontent, hideuser, hidereason, reason, suppress, revisions);
            }
            this.log(Level.SEVERE, "revisionDelete", "EXCEPTION: " + e);
            throw e;
        }
        if (this.retry) {
            this.log(Level.INFO, "revisionDelete", "Successfully (un)deleted " + revisions.length + " revisions.");
        }
        this.retry = true;
        for (Revision rev : revisions) {
            if (hideuser != null) {
                rev.userDeleted = hideuser;
            }
            if (hidereason == null) continue;
            rev.summaryDeleted = hidereason;
        }
        this.throttle(start);
    }

    public synchronized void undo(Revision rev, Revision to, String reason, boolean minor, boolean bot) throws IOException, LoginException {
        long start = System.currentTimeMillis();
        if (to != null && !rev.getPage().equals(to.getPage())) {
            throw new IllegalArgumentException("Cannot undo - the revisions supplied are not on the same page!");
        }
        Map info = this.getPageInfo(rev.getPage());
        if (!this.checkRights(info, "edit")) {
            CredentialException ex = new CredentialException("Permission denied: page is protected.");
            this.log(Level.WARNING, "undo", "Cannot edit - permission denied." + ex);
            throw ex;
        }
        String wpEditToken = (String)info.get("token");
        StringBuilder buffer = new StringBuilder(10000);
        buffer.append("title=");
        buffer.append(rev.getPage());
        if (!reason.isEmpty()) {
            buffer.append("&summary=");
            buffer.append(reason);
        }
        buffer.append("&undo=");
        buffer.append(rev.getRevid());
        if (to != null) {
            buffer.append("&undoafter=");
            buffer.append(to.getRevid());
        }
        if (minor) {
            buffer.append("&minor=1");
        }
        if (bot) {
            buffer.append("&bot=1");
        }
        buffer.append("&token=");
        buffer.append(URLEncoder.encode(wpEditToken, "UTF-8"));
        String response = this.post(this.apiUrl + "action=edit", buffer.toString(), "undo");
        try {
            this.checkErrorsAndUpdateStatus(response, "undo");
        }
        catch (IOException e) {
            if (this.retry) {
                this.retry = false;
                this.log(Level.WARNING, "undo", "Exception: " + e.getMessage() + " Retrying...");
                this.undo(rev, to, reason, minor, bot);
            }
            this.log(Level.SEVERE, "undo", "EXCEPTION: " + e);
            throw e;
        }
        if (this.retry) {
            String log = "Successfully undid revision(s) " + rev.getRevid();
            if (to != null) {
                log = log + " - " + to.getRevid();
            }
            this.log(Level.INFO, "undo", log);
        }
        this.retry = true;
        this.throttle(start);
    }

    protected Revision parseRevision(String xml, String title) {
        long oldid = Long.parseLong(this.parseAttribute(xml, " revid", 0));
        Calendar timestamp = this.timestampToCalendar(this.parseAttribute(xml, "timestamp", 0), true);
        if (title.isEmpty()) {
            title = this.parseAttribute(xml, "title", 0);
        }
        String summary = null;
        if (xml.contains("comment=\"")) {
            summary = this.parseAttribute(xml, "comment", 0);
        }
        String user2 = null;
        if (xml.contains("user=\"")) {
            user2 = this.parseAttribute(xml, "user", 0);
        }
        boolean minor = xml.contains("minor=\"\"");
        boolean bot = xml.contains("bot=\"\"");
        boolean rvnew = xml.contains("new=\"\"");
        int size = 0;
        if (xml.contains("newlen=")) {
            size = Integer.parseInt(this.parseAttribute(xml, "newlen", 0));
        } else if (xml.contains("size=\"")) {
            size = Integer.parseInt(this.parseAttribute(xml, "size", 0));
        } else if (xml.contains("len=\"")) {
            size = Integer.parseInt(this.parseAttribute(xml, "len", 0));
        }
        Revision revision = new Revision(oldid, timestamp, title, summary, user2, minor, bot, rvnew, size);
        if (xml.contains("rcid=\"")) {
            revision.setRcid(Long.parseLong(this.parseAttribute(xml, "rcid", 0)));
        }
        if (xml.contains("rollbacktoken=\"")) {
            revision.setRollbackToken(this.parseAttribute(xml, "rollbacktoken", 0));
        }
        if (xml.contains("parentid")) {
            revision.previous = Long.parseLong(this.parseAttribute(xml, "parentid", 0));
        } else if (xml.contains("old_revid")) {
            revision.previous = Long.parseLong(this.parseAttribute(xml, "old_revid", 0));
        }
        if (xml.contains("oldlen=\"")) {
            revision.sizediff = revision.size - Integer.parseInt(this.parseAttribute(xml, "oldlen", 0));
        } else if (xml.contains("sizediff=\"")) {
            revision.sizediff = Integer.parseInt(this.parseAttribute(xml, "sizediff", 0));
        }
        revision.summaryDeleted = xml.contains("commenthidden=\"");
        revision.userDeleted = xml.contains("userhidden=\"");
        return revision;
    }

    @Deprecated
    public byte[] getImage(String title) throws IOException {
        return this.getImage(title, -1, -1);
    }

    public boolean getImage(String title, File file) throws FileNotFoundException, IOException {
        return this.getImage(title, -1, -1, file);
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public byte[] getImage(String title, int width, int height) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean getImage(String title, int width, int height, File file) throws FileNotFoundException, IOException {
        title = title.replaceFirst("^(File|Image|" + this.namespaceIdentifier(6) + "):", ALL_LOGS);
        StringBuilder url = new StringBuilder(this.query);
        url.append("prop=imageinfo&iiprop=url&titles=");
        url.append(URLEncoder.encode(this.normalize("File:" + title), "UTF-8"));
        url.append("&iiurlwidth=");
        url.append(width);
        url.append("&iiurlheight=");
        url.append(height);
        String line = this.fetch(url.toString(), "getImage");
        if (!line.contains("<imageinfo>")) {
            return false;
        }
        String url2 = this.parseAttribute(line, "url", 0);
        this.logurl(url2, "getImage");
        URLConnection connection = this.makeConnection(url2);
        this.setCookies(connection);
        connection.connect();
        try (BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
             BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(file));){
            int c;
            while ((c = in.read()) != -1) {
                outStream.write(c);
            }
            outStream.flush();
        }
        this.log(Level.INFO, "getImage", "Successfully retrieved image \"" + title + "\"");
        return true;
    }

    public Map<String, Object> getFileMetadata(String file) throws IOException {
        file = file.replaceFirst("^(File|Image|" + this.namespaceIdentifier(6) + "):", ALL_LOGS);
        String url = this.query + "prop=imageinfo&iiprop=size%7Cmime%7Cmetadata&titles=" + URLEncoder.encode(this.normalize("File:" + file), "UTF-8");
        String line = this.fetch(url, "getFileMetadata");
        if (line.contains("missing=\"\"")) {
            return null;
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>(30);
        metadata.put("size", new Integer(this.parseAttribute(line, "size", 0)));
        metadata.put("width", new Integer(this.parseAttribute(line, "width", 0)));
        metadata.put("height", new Integer(this.parseAttribute(line, "height", 0)));
        metadata.put("mime", this.parseAttribute(line, "mime", 0));
        while (line.contains("metadata name=\"")) {
            int a = line.indexOf("name=\"") + 6;
            int b = line.indexOf(34, a);
            String name = this.parseAttribute(line, "name", 0);
            String value = this.parseAttribute(line, "value", 0);
            metadata.put(name, value);
            line = line.substring(b);
        }
        return metadata;
    }

    public String[] getDuplicates(String file) throws IOException {
        file = file.replaceFirst("^(File|Image|" + this.namespaceIdentifier(6) + "):", ALL_LOGS);
        String url = this.query + "prop=duplicatefiles&dflimit=max&titles=" + URLEncoder.encode(this.normalize("File:" + file), "UTF-8");
        String line = this.fetch(url, "getDuplicates");
        if (line.contains("missing=\"\"")) {
            return new String[0];
        }
        ArrayList<String> duplicates = new ArrayList<String>(10);
        int a = line.indexOf("<df ");
        while (a > 0) {
            duplicates.add("File:" + this.parseAttribute(line, "name", a));
            ++a;
            a = line.indexOf("<df ", a);
        }
        int size = duplicates.size();
        this.log(Level.INFO, "getDuplicates", "Successfully retrieved duplicates of File:" + file + " (" + size + " files)");
        return duplicates.toArray(new String[size]);
    }

    public LogEntry[] getImageHistory(String title) throws IOException {
        title = title.replaceFirst("^(File|Image|" + this.namespaceIdentifier(6) + "):", ALL_LOGS);
        String url = this.query + "prop=imageinfo&iiprop=timestamp%7Cuser%7Ccomment&iilimit=max&titles=" + URLEncoder.encode(this.normalize("File:" + title), "UTF-8");
        String line = this.fetch(url, "getImageHistory");
        if (line.contains("missing=\"\"")) {
            return new LogEntry[0];
        }
        ArrayList<LogEntry> history = new ArrayList<LogEntry>(40);
        String prefixtitle = this.namespaceIdentifier(6) + ":" + title;
        int a = line.indexOf("<ii ");
        while (a > 0) {
            int b = line.indexOf(62, a);
            LogEntry le = this.parseLogEntry(line.substring(a, b));
            le.target = prefixtitle;
            le.type = UPLOAD_LOG;
            le.action = "overwrite";
            history.add(le);
            ++a;
            a = line.indexOf("<ii ", a);
        }
        int size = history.size();
        LogEntry last = (LogEntry)history.get(size - 1);
        last.action = UPLOAD_LOG;
        history.set(size - 1, last);
        return history.toArray(new LogEntry[size]);
    }

    public byte[] getOldImage(LogEntry entry) throws IOException {
        if (!entry.getType().equals(UPLOAD_LOG)) {
            throw new IllegalArgumentException("You must provide an upload log entry!");
        }
        String title = entry.getTarget();
        String url = this.query + "prop=imageinfo&iilimit=max&iiprop=timestamp%7Curl%7Carchivename&titles=" + URLEncoder.encode(title, "UTF-8");
        String line = this.fetch(url, "getOldImage");
        int a = line.indexOf("<ii ");
        while (a > 0) {
            String timestamp = this.convertTimestamp(this.parseAttribute(line, "timestamp", a));
            if (timestamp.equals(this.calendarToTimestamp(entry.getTimestamp()))) {
                int c;
                url = this.parseAttribute(line, "url", a);
                this.logurl(url, "getOldImage");
                URLConnection connection = this.makeConnection(url);
                this.setCookies(connection);
                connection.connect();
                BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
                String archive = this.parseAttribute(line, "archivename", 0);
                if (archive == null) {
                    archive = title;
                }
                this.log(Level.INFO, "getOldImage", "Successfully retrieved old image \"" + archive + "\"");
                return out.toByteArray();
            }
            ++a;
            a = line.indexOf("<ii ", a);
        }
        return null;
    }

    public LogEntry[] getUploads(User user) throws IOException {
        return this.getUploads(user, null, null);
    }

    public LogEntry[] getUploads(User user, Calendar start, Calendar end) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("list=allimages&ailimit=max&aisort=timestamp&aiprop=timestamp%7Ccomment&aiuser=");
        url.append(URLEncoder.encode(user.getUsername(), "UTF-8"));
        if (start != null) {
            url.append("&aistart=");
            url.append(this.calendarToTimestamp(start));
        }
        if (end != null) {
            url.append("&aiend=");
            url.append(this.calendarToTimestamp(end));
        }
        ArrayList<LogEntry> uploads = new ArrayList<LogEntry>();
        String aicontinue = null;
        do {
            String line = aicontinue == null ? this.fetch(url.toString(), "getUploads") : this.fetch(url.toString() + "&aicontinue=" + aicontinue, "getUploads");
            aicontinue = this.parseAttribute(line, "aicontinue", 0);
            int i = line.indexOf("<img ");
            while (i > 0) {
                int b = line.indexOf("/>", i);
                LogEntry le = this.parseLogEntry(line.substring(i, b));
                le.type = UPLOAD_LOG;
                le.action = UPLOAD_LOG;
                le.user = user;
                uploads.add(le);
                ++i;
                i = line.indexOf("<img ", i);
            }
        } while (aicontinue != null);
        int size = uploads.size();
        this.log(Level.INFO, "getUploads", "Successfully retrieved uploads of " + user.getUsername() + " (" + size + " uploads)");
        return uploads.toArray(new LogEntry[size]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void upload(File file, String filename, String contents, String reason) throws IOException, LoginException {
        long start = System.currentTimeMillis();
        if (this.user == null || !this.user.isAllowedTo(UPLOAD_LOG)) {
            CredentialNotFoundException ex = new CredentialNotFoundException("Permission denied: cannot upload files.");
            this.log(Level.SEVERE, UPLOAD_LOG, "Cannot upload - permission denied." + ex);
            throw ex;
        }
        filename = filename.replaceFirst("^(File|Image|" + this.namespaceIdentifier(6) + "):", ALL_LOGS);
        Map info = this.getPageInfo("File:" + filename);
        if (!this.checkRights(info, UPLOAD_LOG)) {
            CredentialException ex = new CredentialException("Permission denied: page is protected.");
            this.log(Level.WARNING, UPLOAD_LOG, "Cannot upload - permission denied." + ex);
            throw ex;
        }
        String wpEditToken = (String)info.get("token");
        long filesize = file.length();
        long chunks = (filesize >> 22) + 1L;
        String filekey = ALL_LOGS;
        try (FileInputStream fi = new FileInputStream(file);){
            int i = 0;
            while ((long)i < chunks) {
                HashMap<String, Object> params = new HashMap<String, Object>(50);
                params.put("filename", filename);
                params.put("token", wpEditToken);
                params.put("ignorewarnings", "true");
                if (chunks == 1L) {
                    params.put("text", contents);
                    if (!reason.isEmpty()) {
                        params.put("comment", reason);
                    }
                    byte[] by = new byte[fi.available()];
                    fi.read(by);
                    params.put("file\"; filename=\"" + file.getName(), by);
                } else {
                    long offset = i << 22;
                    params.put("stash", "1");
                    params.put("offset", ALL_LOGS + offset);
                    params.put("filesize", ALL_LOGS + filesize);
                    if (i != 0) {
                        params.put("filekey", filekey);
                    }
                    long buffersize = Math.min(0x400000L, filesize - offset);
                    byte[] by = new byte[(int)buffersize];
                    fi.read(by);
                    params.put("chunk\"; filename=\"" + file.getName(), by);
                    wpEditToken = (String)this.getPageInfo("File:" + filename).get("token");
                }
                String response = this.multipartPost(this.apiUrl + "action=upload", params, UPLOAD_LOG);
                try {
                    if (chunks > 1L) {
                        if (!response.contains("filekey=\"")) throw new IOException("No filekey present! Server response was " + response);
                        filekey = this.parseAttribute(response, "filekey", 0);
                    } else {
                        if (response.contains("error code=\"fileexists-shared-forbidden\"")) {
                            CredentialException ex = new CredentialException("Cannot overwrite file hosted on central repository.");
                            this.log(Level.WARNING, UPLOAD_LOG, "Cannot upload - permission denied." + ex);
                            throw ex;
                        }
                        this.checkErrorsAndUpdateStatus(response, UPLOAD_LOG);
                    }
                }
                catch (IOException e) {
                    this.log(Level.SEVERE, UPLOAD_LOG, "EXCEPTION: " + e);
                    throw e;
                }
                ++i;
            }
        }
        if (chunks > 1L) {
            HashMap<String, String> params = new HashMap<String, String>(50);
            params.put("filename", filename);
            params.put("token", wpEditToken);
            params.put("text", contents);
            if (!reason.isEmpty()) {
                params.put("comment", reason);
            }
            params.put("ignorewarnings", "true");
            params.put("filekey", filekey);
            String response = this.multipartPost(this.apiUrl + "action=upload", params, UPLOAD_LOG);
            this.checkErrorsAndUpdateStatus(response, UPLOAD_LOG);
        }
        this.throttle(start);
        this.log(Level.INFO, UPLOAD_LOG, "Successfully uploaded to File:" + filename + ".");
    }

    public boolean userExists(String username) throws IOException {
        username = URLEncoder.encode(this.normalize(username), "UTF-8");
        return this.fetch(this.query + "list=users&ususers=" + username, "userExists").contains("userid=\"");
    }

    public String[] allUsers(String start, int number) throws IOException {
        return this.allUsers(start, number, ALL_LOGS);
    }

    public String[] allUsersWithPrefix(String prefix) throws IOException {
        return this.allUsers(ALL_LOGS, -1, prefix);
    }

    public String[] allUsers(String start, int number, String prefix) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("list=allusers&aulimit=");
        String next = ALL_LOGS;
        if (prefix.isEmpty()) {
            url.append(number > this.slowmax ? this.slowmax : number);
            next = URLEncoder.encode(start, "UTF-8");
        } else {
            url.append(this.slowmax);
            url.append("&auprefix=");
            url.append(URLEncoder.encode(this.normalize(prefix), "UTF-8"));
        }
        ArrayList<String> members = new ArrayList<String>(6667);
        block0: do {
            String temp = url.toString();
            if (!next.isEmpty()) {
                temp = temp + "&aufrom=" + URLEncoder.encode(next, "UTF-8");
            }
            String line = this.fetch(temp, "allUsers");
            next = this.parseAttribute(line, "aufrom", 0);
            int w = line.indexOf("<u ");
            while (w > 0) {
                members.add(this.parseAttribute(line, "name", w));
                if (members.size() == number) {
                    next = null;
                    continue block0;
                }
                ++w;
                w = line.indexOf("<u ", w);
            }
        } while (next != null);
        int size = members.size();
        this.log(Level.INFO, "allUsers", "Successfully retrieved user list (" + size + " users)");
        return members.toArray(new String[size]);
    }

    public User getUser(String username) throws IOException {
        return this.userExists(username) ? new User(this.normalize(username)) : null;
    }

    public User getCurrentUser() {
        return this.user;
    }

    public Revision[] contribs(String user, int ... ns) throws IOException {
        return this.contribs(user, ALL_LOGS, null, null, ns);
    }

    @Deprecated
    public Revision[] rangeContribs(String range) throws IOException {
        int a = range.indexOf(47);
        if (a < 7) {
            throw new NumberFormatException("Not a valid CIDR range!");
        }
        int size = Integer.parseInt(range.substring(a + 1));
        String[] numbers = range.substring(0, a).split("\\.");
        if (numbers.length != 4) {
            throw new NumberFormatException("Not a valid CIDR range!");
        }
        switch (size) {
            case 8: {
                return this.contribs(ALL_LOGS, numbers[0] + ".", null, null, new int[0]);
            }
            case 16: {
                return this.contribs(ALL_LOGS, numbers[0] + "." + numbers[1] + ".", null, null, new int[0]);
            }
            case 24: {
                return this.contribs(ALL_LOGS, numbers[0] + "." + numbers[1] + "." + numbers[2] + ".", null, null, new int[0]);
            }
            case 32: {
                return this.contribs(range.substring(0, range.length() - 3), ALL_LOGS, null, null, new int[0]);
            }
        }
        throw new NumberFormatException("Range is not supported.");
    }

    public Revision[] contribs(String user, String prefix, Calendar end, Calendar start, int ... ns) throws IOException {
        StringBuilder temp = new StringBuilder(this.query);
        temp.append("list=usercontribs&uclimit=max&ucprop=title%7Ctimestamp%7Cflags%7Ccomment%7Cids%7Csize%7Csizediff&");
        if (prefix.isEmpty()) {
            temp.append("ucuser=");
            temp.append(URLEncoder.encode(this.normalize(user), "UTF-8"));
        } else {
            temp.append("ucuserprefix=");
            temp.append(prefix);
        }
        this.constructNamespaceString(temp, "uc", ns);
        if (end != null) {
            temp.append("&ucend=");
            temp.append(this.calendarToTimestamp(end));
        }
        ArrayList<Revision> revisions = new ArrayList<Revision>(7500);
        String uccontinue = ALL_LOGS;
        String ucstart = ALL_LOGS;
        if (start != null) {
            temp.append("&ucstart=");
            temp.append(this.calendarToTimestamp(start));
        }
        do {
            String line;
            uccontinue = (line = this.fetch(temp.toString() + uccontinue + ucstart, "contribs")).contains("uccontinue") ? "&uccontinue=" + URLEncoder.encode(this.parseAttribute(line, "uccontinue", 0), "UTF-8") : null;
            int a = line.indexOf("<item ");
            while (a > 0) {
                int b = line.indexOf(" />", a);
                revisions.add(this.parseRevision(line.substring(a, b), ALL_LOGS));
                ++a;
                a = line.indexOf("<item ", a);
            }
        } while (uccontinue != null);
        int size = revisions.size();
        this.log(Level.INFO, "contribs", "Successfully retrived contributions for " + (prefix.isEmpty() ? user : prefix) + " (" + size + " edits)");
        return revisions.toArray(new Revision[size]);
    }

    public synchronized void emailUser(User user, String message, String subject, boolean emailme) throws IOException, LoginException {
        long start = System.currentTimeMillis();
        if (this.user == null || !this.user.isAllowedTo("sendemail")) {
            throw new CredentialNotFoundException("Permission denied: cannot email.");
        }
        if (!((Boolean)user.getUserInfo().get("emailable")).booleanValue()) {
            this.log(Level.WARNING, "emailUser", "User " + user.getUsername() + " is not emailable");
            return;
        }
        String token = (String)this.getPageInfo("User:" + user.getUsername()).get("token");
        if (token.equals("\\+")) {
            this.log(Level.SEVERE, "emailUser", "Cookies have expired.");
            this.logout();
            throw new CredentialExpiredException("Cookies have expired.");
        }
        StringBuilder buffer = new StringBuilder(20000);
        buffer.append("token=");
        buffer.append(URLEncoder.encode(token, "UTF-8"));
        buffer.append("&target=");
        buffer.append(URLEncoder.encode(user.getUsername(), "UTF-8"));
        if (emailme) {
            buffer.append("&ccme=true");
        }
        buffer.append("&text=");
        buffer.append(URLEncoder.encode(message, "UTF-8"));
        buffer.append("&subject=");
        buffer.append(URLEncoder.encode(subject, "UTF-8"));
        String response = this.post(this.apiUrl + "action=emailuser", buffer.toString(), "emailUser");
        this.checkErrorsAndUpdateStatus(response, "email");
        if (response.contains("error code=\"cantsend\"")) {
            throw new UnsupportedOperationException("Email is disabled for this wiki or you do not have a confirmed email address.");
        }
        this.throttle(start);
        this.log(Level.INFO, "emailUser", "Successfully emailed " + user.getUsername() + ".");
    }

    public synchronized void unblock(String blockeduser, String reason) throws IOException, LoginException {
        long start = System.currentTimeMillis();
        if (this.user == null || !this.user.isA(FULL_PROTECTION)) {
            throw new CredentialNotFoundException("Cannot unblock: permission denied!");
        }
        String temp = this.fetch(this.query + "action=query&meta=tokens", "unblock");
        String token = this.parseAttribute(temp, "csrftoken", 0);
        String request = "user=" + URLEncoder.encode(blockeduser, "UTF-8") + "&reason=" + URLEncoder.encode(reason, "UTF-8") + "&token=" + URLEncoder.encode(token, "UTF-8");
        String response = this.post(this.query + "action=unblock", request, "unblock");
        try {
            if (!response.contains("<unblock ")) {
                this.checkErrorsAndUpdateStatus(response, "unblock");
            } else if (response.contains("code=\"cantunblock\"")) {
                this.log(Level.INFO, "unblock", blockeduser + " is not blocked.");
            } else if (response.contains("code=\"blockedasrange\"")) {
                this.log(Level.SEVERE, "unblock", "IP " + blockeduser + " is rangeblocked.");
                return;
            }
        }
        catch (IOException e) {
            if (this.retry) {
                this.retry = false;
                this.log(Level.WARNING, "undelete", "Exception: " + e.getMessage() + " Retrying...");
                this.unblock(blockeduser, reason);
            }
            this.log(Level.SEVERE, "unblock", "EXCEPTION: " + e);
            throw e;
        }
        if (this.retry) {
            this.log(Level.INFO, "unblock", "Successfully unblocked " + blockeduser);
        }
        this.retry = true;
        this.throttle(start);
    }

    public void watch(String ... titles) throws IOException, CredentialNotFoundException {
        this.watchInternal(false, titles);
        this.watchlist.addAll(Arrays.asList(titles));
    }

    public void unwatch(String ... titles) throws IOException, CredentialNotFoundException {
        this.watchInternal(true, titles);
        this.watchlist.removeAll(Arrays.asList(titles));
    }

    protected void watchInternal(boolean unwatch, String ... titles) throws IOException, CredentialNotFoundException {
        String state;
        String string = state = unwatch ? "unwatch" : "watch";
        if (this.watchlist == null) {
            this.getRawWatchlist();
        }
        for (String titlestring : this.constructTitleString(titles)) {
            StringBuilder request = new StringBuilder("titles=");
            request.append(titlestring);
            if (unwatch) {
                request.append("&unwatch=1");
            }
            request.append("&token=");
            String temp = this.fetch(this.query + "meta=tokens&type=watch", "watchInternal");
            String watchToken = this.parseAttribute(temp, "watchtoken", 0);
            request.append(URLEncoder.encode(watchToken, "UTF-8"));
            this.post(this.apiUrl + "action=watch", request.toString(), state);
        }
        this.log(Level.INFO, state, "Successfully " + state + "ed " + Arrays.toString(titles));
    }

    public String[] getRawWatchlist() throws IOException, CredentialNotFoundException {
        return this.getRawWatchlist(true);
    }

    public String[] getRawWatchlist(boolean cache) throws IOException, CredentialNotFoundException {
        if (this.user == null) {
            throw new CredentialNotFoundException("The watchlist is available for registered users only.");
        }
        if (this.watchlist != null && cache) {
            return this.watchlist.toArray(new String[this.watchlist.size()]);
        }
        String url = this.query + "list=watchlistraw&wrlimit=max";
        String wrcontinue = null;
        this.watchlist = new ArrayList<String>(750);
        do {
            String line = wrcontinue == null ? this.fetch(url, "getRawWatchlist") : this.fetch(url + "&wrcontinue=" + URLEncoder.encode(wrcontinue, "UTF-8"), "getRawWatchlist");
            wrcontinue = this.parseAttribute(line, "wrcontinue", 0);
            int a = line.indexOf("<wr ");
            while (a > 0) {
                String title = this.parseAttribute(line, "title", a);
                if (this.namespace(title) % 2 == 0) {
                    this.watchlist.add(title);
                }
                ++a;
                a = line.indexOf("<wr ", a);
            }
        } while (wrcontinue != null);
        int size = this.watchlist.size();
        this.log(Level.INFO, "getRawWatchlist", "Successfully retrieved raw watchlist (" + size + " items)");
        return this.watchlist.toArray(new String[size]);
    }

    public boolean isWatched(String title) throws IOException, CredentialNotFoundException {
        if (this.watchlist == null) {
            this.getRawWatchlist();
        }
        return this.watchlist.contains(title);
    }

    public Revision[] watchlist() throws IOException, CredentialNotFoundException {
        return this.watchlist(false, new int[0]);
    }

    public Revision[] watchlist(boolean allrev, int ... ns) throws IOException, CredentialNotFoundException {
        if (this.user == null) {
            throw new CredentialNotFoundException("Not logged in");
        }
        StringBuilder url = new StringBuilder(this.query);
        url.append("list=watchlist&wlprop=ids%7Ctitle%7Ctimestamp%7Cuser%7Ccomment%7Csizes&wllimit=max");
        if (allrev) {
            url.append("&wlallrev=true");
        }
        this.constructNamespaceString(url, "wl", ns);
        ArrayList<Revision> wl = new ArrayList<Revision>(667);
        String wlstart = ALL_LOGS;
        do {
            String line = this.fetch(url.toString() + "&wlstart=" + wlstart, "watchlist");
            wlstart = this.parseAttribute(line, "wlstart", 0);
            int i = line.indexOf("<item ");
            while (i > 0) {
                int j = line.indexOf("/>", i);
                wl.add(this.parseRevision(line.substring(i, j), ALL_LOGS));
                ++i;
                i = line.indexOf("<item ", i);
            }
        } while (wlstart != null);
        int size = wl.size();
        this.log(Level.INFO, "watchlist", "Successfully retrieved watchlist (" + size + " items)");
        return wl.toArray(new Revision[size]);
    }

    public String[][] search(String search, int ... namespaces) throws IOException {
        if (namespaces.length == 0) {
            namespaces = new int[]{0};
        }
        StringBuilder url = new StringBuilder(this.query);
        url.append("list=search&srwhat=text&srprop=snippet%7Csectionsnippet&srlimit=max&srsearch=");
        url.append(URLEncoder.encode(search, "UTF-8"));
        this.constructNamespaceString(url, "sr", namespaces);
        url.append("&sroffset=");
        boolean done = false;
        ArrayList<String[]> results = new ArrayList<String[]>(5000);
        while (!done) {
            String line = this.fetch(url.toString() + results.size(), "search");
            if (!line.contains("sroffset=\"")) {
                done = true;
            }
            int x = line.indexOf("<p ");
            while (x > 0) {
                String[] result = new String[]{this.parseAttribute(line, "title", x), line.contains("sectionsnippet=\"") ? this.parseAttribute(line, "sectionsnippet", x) : ALL_LOGS, this.parseAttribute(line, "snippet", x)};
                results.add(result);
                ++x;
                x = line.indexOf("<p ", x);
            }
        }
        this.log(Level.INFO, "search", "Successfully searched for string \"" + search + "\" (" + results.size() + " items found)");
        return (String[][])results.toArray((T[])new String[0][0]);
    }

    public String[] imageUsage(String image, int ... ns) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        image = image.replaceFirst("^(File|Image|" + this.namespaceIdentifier(6) + "):", ALL_LOGS);
        url.append("list=imageusage&iulimit=max&iutitle=");
        url.append(URLEncoder.encode(this.normalize("File:" + image), "UTF-8"));
        this.constructNamespaceString(url, "iu", ns);
        ArrayList<String> pages = new ArrayList<String>(1333);
        String next = ALL_LOGS;
        do {
            if (!pages.isEmpty()) {
                next = "&iucontinue=" + next;
            }
            String line = this.fetch(url + next, "imageUsage");
            next = this.parseAttribute(line, "iucontinue", 0);
            int x = line.indexOf("<iu ");
            while (x > 0) {
                pages.add(this.parseAttribute(line, "title", x));
                ++x;
                x = line.indexOf("<iu ", x);
            }
        } while (next != null);
        int size = pages.size();
        this.log(Level.INFO, "imageUsage", "Successfully retrieved usages of File:" + image + " (" + size + " items)");
        return pages.toArray(new String[size]);
    }

    public String[] whatLinksHere(String title, int ... ns) throws IOException {
        return this.whatLinksHere(title, false, ns);
    }

    public String[] whatLinksHere(String title, boolean redirects, int ... ns) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("list=backlinks&bllimit=max&bltitle=");
        url.append(URLEncoder.encode(this.normalize(title), "UTF-8"));
        this.constructNamespaceString(url, "bl", ns);
        if (redirects) {
            url.append("&blfilterredir=redirects");
        }
        ArrayList<String> pages = new ArrayList<String>(6667);
        String blcontinue = null;
        do {
            String line = blcontinue == null ? this.fetch(url.toString(), "whatLinksHere") : this.fetch(url.toString() + "&blcontinue=" + blcontinue, "whatLinksHere");
            blcontinue = this.parseAttribute(line, "blcontinue", 0);
            int x = line.indexOf("<bl ");
            while (x > 0) {
                pages.add(this.parseAttribute(line, "title", x));
                ++x;
                x = line.indexOf("<bl ", x);
            }
        } while (blcontinue != null);
        int size = pages.size();
        this.log(Level.INFO, "whatLinksHere", "Successfully retrieved " + (redirects ? "redirects to " : "links to ") + title + " (" + size + " items)");
        return pages.toArray(new String[size]);
    }

    public String[] whatTranscludesHere(String title, int ... ns) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("list=embeddedin&eilimit=max&eititle=");
        url.append(URLEncoder.encode(this.normalize(title), "UTF-8"));
        this.constructNamespaceString(url, "ei", ns);
        ArrayList<String> pages = new ArrayList<String>(6667);
        String eicontinue = null;
        do {
            String line = eicontinue == null ? this.fetch(url.toString(), "whatTranscludesHere") : this.fetch(url.toString() + "&eicontinue=" + eicontinue, "whatTranscludesHere");
            eicontinue = this.parseAttribute(line, "eicontinue", 0);
            int x = line.indexOf("<ei ");
            while (x > 0) {
                pages.add(this.parseAttribute(line, "title", x));
                ++x;
                x = line.indexOf("<ei ", x);
            }
        } while (eicontinue != null);
        int size = pages.size();
        this.log(Level.INFO, "whatTranscludesHere", "Successfully retrieved transclusions of " + title + " (" + size + " items)");
        return pages.toArray(new String[size]);
    }

    public String[] getCategoryMembers(String name, int ... ns) throws IOException {
        return this.getCategoryMembers(name, 0, new ArrayList<String>(), ns);
    }

    public String[] getCategoryMembers(String name, boolean subcat, int ... ns) throws IOException {
        return this.getCategoryMembers(name, subcat ? 1 : 0, new ArrayList<String>(), ns);
    }

    public String[] getCategoryMembers(String name, int maxdepth, int ... ns) throws IOException {
        return this.getCategoryMembers(name, maxdepth, new ArrayList<String>(), ns);
    }

    protected String[] getCategoryMembers(String name, int maxdepth, List<String> visitedcategories, int ... ns) throws IOException {
        boolean nocat;
        name = name.replaceFirst("^(Category|" + this.namespaceIdentifier(14) + "):", ALL_LOGS);
        StringBuilder url = new StringBuilder(this.query);
        url.append("list=categorymembers&cmprop=title&cmlimit=max&cmtitle=");
        url.append(URLEncoder.encode(this.normalize("Category:" + name), "UTF-8"));
        boolean bl = nocat = ns.length != 0;
        if (maxdepth > 0 && nocat) {
            for (int i = 0; nocat && i < ns.length; ++i) {
                nocat = ns[i] != 14;
            }
            if (nocat) {
                int[] temp = Arrays.copyOf(ns, ns.length + 1);
                temp[ns.length] = 14;
                this.constructNamespaceString(url, "cm", temp);
            } else {
                this.constructNamespaceString(url, "cm", ns);
            }
        } else {
            this.constructNamespaceString(url, "cm", ns);
        }
        ArrayList<String> members = new ArrayList<String>();
        String next = ALL_LOGS;
        do {
            if (!next.isEmpty()) {
                next = "&cmcontinue=" + URLEncoder.encode(next, "UTF-8");
            }
            String line = this.fetch(url.toString() + next, "getCategoryMembers");
            next = this.parseAttribute(line, "cmcontinue", 0);
            int x = line.indexOf("<cm ");
            while (x > 0) {
                boolean iscat;
                String member = this.parseAttribute(line, "title", x);
                boolean bl2 = iscat = this.namespace(member) == 14;
                if (maxdepth > 0 && iscat && !visitedcategories.contains(member)) {
                    String[] categoryMembers = this.getCategoryMembers(member, --maxdepth, visitedcategories, ns);
                    visitedcategories.add(member);
                    members.addAll(Arrays.asList(categoryMembers));
                }
                if (maxdepth <= 0 || !nocat || !iscat) {
                    members.add(member);
                }
                ++x;
                x = line.indexOf("<cm ", x);
            }
        } while (next != null);
        int size = members.size();
        this.log(Level.INFO, "getCategoryMembers", "Successfully retrieved contents of Category:" + name + " (" + size + " items)");
        return members.toArray(new String[size]);
    }

    public List[] linksearch(String pattern) throws IOException {
        return this.linksearch(pattern, "http", new int[0]);
    }

    public List[] linksearch(String pattern, String protocol, int ... ns) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("list=exturlusage&euprop=title%7curl&eulimit=max&euquery=");
        url.append(pattern);
        url.append("&euprotocol=");
        url.append(protocol);
        this.constructNamespaceString(url, "eu", ns);
        url.append("&euoffset=");
        boolean done = false;
        List[] ret = new ArrayList[]{new ArrayList(667), new ArrayList(667)};
        while (!done) {
            String line = this.fetch(url.toString() + ret[0].size(), "linksearch");
            if (!line.contains("euoffset=\"")) {
                done = true;
            }
            int x = line.indexOf("<eu");
            while (x > 0) {
                String link = this.parseAttribute(line, "url", x);
                ret[0].add(this.parseAttribute(line, "title", x));
                if (link.charAt(0) == '/') {
                    ret[1].add(new URL(protocol + ":" + link));
                } else {
                    ret[1].add(new URL(link));
                }
                ++x;
                x = line.indexOf("<eu ", x);
            }
        }
        this.log(Level.INFO, "linksearch", "Successfully returned instances of external link " + pattern + " (" + ret[0].size() + " links)");
        return ret;
    }

    public LogEntry[] getIPBlockList(String user) throws IOException {
        return this.getIPBlockList(user, null, null);
    }

    public LogEntry[] getIPBlockList(Calendar start, Calendar end) throws IOException {
        return this.getIPBlockList(ALL_LOGS, start, end);
    }

    protected LogEntry[] getIPBlockList(String user, Calendar start, Calendar end) throws IOException {
        if (start != null && end != null && start.before(end)) {
            throw new IllegalArgumentException("Specified start date is before specified end date!");
        }
        String bkstart = this.calendarToTimestamp(start == null ? this.makeCalendar() : start);
        StringBuilder urlBase = new StringBuilder(this.query);
        urlBase.append("list=blocks&bklimit=");
        urlBase.append(this.max);
        if (end != null) {
            urlBase.append("&bkend=");
            urlBase.append(this.calendarToTimestamp(end));
        }
        if (!user.isEmpty()) {
            urlBase.append("&bkusers=");
            urlBase.append(user);
        }
        urlBase.append("&bkstart=");
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>(1333);
        do {
            String line = this.fetch(urlBase.toString() + bkstart, "getIPBlockList");
            bkstart = this.parseAttribute(line, "bkstart", 0);
            int a = line.indexOf("<block ");
            while (a > 0) {
                int b = line.indexOf("/>", a);
                String temp = line.substring(a, b);
                LogEntry le = this.parseLogEntry(temp);
                le.type = BLOCK_LOG;
                le.action = BLOCK_LOG;
                if (le.user == null) {
                    le.target = "#" + this.parseAttribute(temp, "id", 0);
                } else {
                    le.target = this.namespaceIdentifier(2) + ":" + le.user.username;
                }
                le.user = new User(this.parseAttribute(temp, "by", 0));
                entries.add(le);
                ++a;
                a = line.indexOf("<block ", a);
            }
        } while (bkstart != null);
        StringBuilder logRecord = new StringBuilder("Successfully fetched IP block list ");
        if (!user.isEmpty()) {
            logRecord.append(" for ");
            logRecord.append(user);
        }
        if (start != null) {
            logRecord.append(" from ");
            logRecord.append(start.getTime().toString());
        }
        if (end != null) {
            logRecord.append(" to ");
            logRecord.append(end.getTime().toString());
        }
        int size = entries.size();
        logRecord.append(" (");
        logRecord.append(size);
        logRecord.append(" entries)");
        this.log(Level.INFO, "getIPBlockList", logRecord.toString());
        return entries.toArray(new LogEntry[size]);
    }

    public LogEntry[] getLogEntries(int amount) throws IOException {
        return this.getLogEntries(null, null, amount, ALL_LOGS, ALL_LOGS, null, ALL_LOGS, 167317762);
    }

    public LogEntry[] getLogEntries(User user) throws IOException {
        return this.getLogEntries(null, null, Integer.MAX_VALUE, ALL_LOGS, ALL_LOGS, user, ALL_LOGS, 167317762);
    }

    public LogEntry[] getLogEntries(String target) throws IOException {
        return this.getLogEntries(null, null, Integer.MAX_VALUE, ALL_LOGS, ALL_LOGS, null, target, 167317762);
    }

    public LogEntry[] getLogEntries(Calendar start, Calendar end) throws IOException {
        return this.getLogEntries(start, end, Integer.MAX_VALUE, ALL_LOGS, ALL_LOGS, null, ALL_LOGS, 167317762);
    }

    public LogEntry[] getLogEntries(int amount, String type, String action) throws IOException {
        return this.getLogEntries(null, null, amount, type, action, null, ALL_LOGS, 167317762);
    }

    public LogEntry[] getLogEntries(Calendar start, Calendar end, int amount, String log, String action, User user, String target, int namespace) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("list=logevents&leprop=title%7Ctype%7Cuser%7Ctimestamp%7Ccomment%7Cdetails&lelimit=");
        if (amount < 1) {
            throw new IllegalArgumentException("Tried to retrieve less than one log entry!");
        }
        url.append(amount > this.max ? this.max : amount);
        if (!log.equals(ALL_LOGS)) {
            if (action.isEmpty()) {
                url.append("&letype=");
                url.append(log);
            } else {
                url.append("&leaction=");
                url.append(log);
                url.append("/");
                url.append(action);
            }
        }
        if (namespace != 167317762) {
            url.append("&lenamespace=");
            url.append(namespace);
        }
        if (user != null) {
            url.append("&leuser=");
            url.append(URLEncoder.encode(user.getUsername(), "UTF-8"));
        }
        if (!target.isEmpty()) {
            url.append("&letitle=");
            url.append(URLEncoder.encode(this.normalize(target), "UTF-8"));
        }
        String lestart = ALL_LOGS;
        if (start != null) {
            if (end != null && start.before(end)) {
                throw new IllegalArgumentException("Specified start date is before specified end date!");
            }
            lestart = this.calendarToTimestamp(start);
        }
        if (end != null) {
            url.append("&leend=");
            url.append(this.calendarToTimestamp(end));
        }
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>(6667);
        do {
            String line = this.fetch(url.toString() + "&lestart=" + lestart, "getLogEntries");
            lestart = this.parseAttribute(line, "lestart", 0);
            while (line.contains("<item") && entries.size() < amount) {
                int a = line.indexOf("<item");
                int b = line.indexOf("><item", a);
                if (b < 0) {
                    b = line.length();
                }
                entries.add(this.parseLogEntry(line.substring(a, b)));
                line = line.substring(b);
            }
        } while (entries.size() < amount && lestart != null);
        StringBuilder console = new StringBuilder("Successfully retrieved log (type=");
        console.append(log);
        int size = entries.size();
        console.append(", ");
        console.append(size);
        console.append(" entries)");
        this.log(Level.INFO, "getLogEntries", console.toString());
        return entries.toArray(new LogEntry[size]);
    }

    protected LogEntry parseLogEntry(String xml) {
        String type = ALL_LOGS;
        String action = ALL_LOGS;
        if (xml.contains("type=\"")) {
            type = this.parseAttribute(xml, "type", 0);
            if (!xml.contains("actionhidden=\"")) {
                action = this.parseAttribute(xml, "action", 0);
            }
        }
        String reason = xml.contains("commenthidden=\"") ? null : (type.equals(USER_CREATION_LOG) ? ALL_LOGS : (xml.contains("reason=\"") ? this.parseAttribute(xml, "reason", 0) : this.parseAttribute(xml, "comment", 0)));
        User performer = null;
        if (xml.contains("user=\"")) {
            performer = new User(this.parseAttribute(xml, "user", 0));
        }
        String target = null;
        if (xml.contains(" title=\"")) {
            target = this.parseAttribute(xml, "title", 0);
        }
        String timestamp = this.convertTimestamp(this.parseAttribute(xml, "timestamp", 0));
        Object[] details = null;
        if (xml.contains("commenthidden")) {
            details = null;
        } else if (type.equals(MOVE_LOG)) {
            details = this.parseAttribute(xml, "new_title", 0);
        } else if (type.equals(BLOCK_LOG) || xml.contains("<block")) {
            int c;
            int a = xml.indexOf("<block") + 7;
            String s = xml.substring(a);
            int n = c = xml.contains("expiry=\"") ? s.indexOf("expiry=") + 8 : s.indexOf("duration=") + 10;
            if (c > 10) {
                int d = s.indexOf(34, c);
                details = new Object[]{s.contains("anononly"), s.contains("nocreate"), s.contains("noautoblock"), s.contains("noemail"), s.contains("nousertalk"), s.substring(c, d)};
            }
        } else if (type.equals(PROTECTION_LOG)) {
            if (action.equals("unprotect")) {
                details = null;
            } else {
                int a = xml.indexOf("<param>") + 7;
                int b = xml.indexOf("</param>", a);
                details = xml.substring(a, b);
            }
        } else if (type.equals(USER_RENAME_LOG)) {
            int a = xml.indexOf("<param>") + 7;
            int b = xml.indexOf("</param>", a);
            details = this.decode(xml.substring(a, b));
        } else if (type.equals(USER_RIGHTS_LOG)) {
            int a = xml.indexOf("new=\"") + 5;
            int b = xml.indexOf(34, a);
            StringTokenizer tk = new StringTokenizer(xml.substring(a, b), ", ");
            ArrayList<String> temp = new ArrayList<String>();
            while (tk.hasMoreTokens()) {
                temp.add(tk.nextToken());
            }
            details = temp.toArray(new String[temp.size()]);
        }
        return new LogEntry(type, action, reason, performer, target, timestamp, details);
    }

    public String[] prefixIndex(String prefix) throws IOException {
        return this.listPages(prefix, null, 167317762, -1, -1, null);
    }

    public String[] shortPages(int cutoff) throws IOException {
        return this.listPages(ALL_LOGS, null, 0, -1, cutoff, null);
    }

    public String[] shortPages(int cutoff, int namespace) throws IOException {
        return this.listPages(ALL_LOGS, null, namespace, -1, cutoff, null);
    }

    public String[] longPages(int cutoff) throws IOException {
        return this.listPages(ALL_LOGS, null, 0, cutoff, -1, null);
    }

    public String[] longPages(int cutoff, int namespace) throws IOException {
        return this.listPages(ALL_LOGS, null, namespace, cutoff, -1, null);
    }

    public String[] listPages(String prefix, Map<String, Object> protectionstate, int namespace) throws IOException {
        return this.listPages(prefix, protectionstate, namespace, -1, -1, null);
    }

    public String[] listPages(String prefix, Map<String, Object> protectionstate, int namespace, int minimum, int maximum, Boolean redirects) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("list=allpages&aplimit=max");
        if (!prefix.isEmpty()) {
            namespace = this.namespace(prefix);
            if (prefix.contains(":") && namespace != 0) {
                prefix = prefix.substring(prefix.indexOf(58) + 1);
            }
            url.append("&apprefix=");
            url.append(URLEncoder.encode(this.normalize(prefix), "UTF-8"));
        } else if (namespace == 167317762) {
            throw new UnsupportedOperationException("ALL_NAMESPACES not supported in MediaWiki API.");
        }
        url.append("&apnamespace=");
        url.append(namespace);
        if (protectionstate != null) {
            StringBuilder apprtype = new StringBuilder("&apprtype=");
            StringBuilder apprlevel = new StringBuilder("&apprlevel=");
            for (Map.Entry<String, Object> entry : protectionstate.entrySet()) {
                String key = entry.getKey();
                if (key.equals("cascade")) {
                    url.append("&apprfiltercascade=");
                    url.append((Boolean)entry.getValue() != false ? "cascading" : "noncascading");
                    continue;
                }
                if (key.contains("expiry")) continue;
                apprtype.append(key);
                apprtype.append("%7C");
                apprlevel.append((String)entry.getValue());
                apprlevel.append("%7C");
            }
            apprtype.delete(apprtype.length() - 3, apprtype.length());
            apprlevel.delete(apprlevel.length() - 3, apprlevel.length());
            url.append((CharSequence)apprtype);
            url.append((CharSequence)apprlevel);
        }
        if (minimum != -1) {
            url.append("&apminsize=");
            url.append(minimum);
        }
        if (maximum != -1) {
            url.append("&apmaxsize=");
            url.append(maximum);
        }
        if (redirects == Boolean.TRUE) {
            url.append("&apfilterredir=redirects");
        } else if (redirects == Boolean.FALSE) {
            url.append("&apfilterredir=nonredirects");
        }
        ArrayList<String> pages = new ArrayList<String>(6667);
        String next = null;
        do {
            String s = url.toString();
            if (next != null) {
                s = s + "&apcontinue=" + URLEncoder.encode(next, "UTF-8");
            }
            String line = this.fetch(s, "listPages");
            next = maximum < 0 && minimum < 0 && prefix.isEmpty() && protectionstate == null ? null : (line.contains("apcontinue=") ? this.parseAttribute(line, "apcontinue", 0) : null);
            int a = line.indexOf("<p ");
            while (a > 0) {
                pages.add(this.parseAttribute(line, "title", a));
                ++a;
                a = line.indexOf("<p ", a);
            }
        } while (next != null);
        int size = pages.size();
        this.log(Level.INFO, "listPages", "Successfully retrieved page list (" + size + " pages)");
        return pages.toArray(new String[size]);
    }

    public String[] queryPage(String page) throws IOException, CredentialNotFoundException {
        if (page.equals("Unwatchedpages") && (this.user == null || !this.user.isAllowedTo("unwatchedpages"))) {
            throw new CredentialNotFoundException("User does not have the \"unwatchedpages\" permission.");
        }
        String url = this.query + "action=query&list=querypage&qplimit=max&qppage=" + page + "&qpcontinue=";
        String offset = ALL_LOGS;
        ArrayList<String> pages = new ArrayList<String>(1333);
        do {
            String line = this.fetch(url + offset, "queryPage");
            offset = this.parseAttribute(line, "qpoffset", 0);
            int x = line.indexOf("<page ");
            while (x > 0) {
                pages.add(this.parseAttribute(line, "title", x));
                ++x;
                x = line.indexOf("<page ", x);
            }
        } while (offset != null);
        int temp = pages.size();
        this.log(Level.INFO, "queryPage", "Successfully retrieved [[Special:" + page + "]] (" + temp + " pages)");
        return pages.toArray(new String[temp]);
    }

    public Revision[] newPages(int amount) throws IOException {
        return this.recentChanges(amount, 0, true, 0);
    }

    public Revision[] newPages(int amount, int rcoptions) throws IOException {
        return this.recentChanges(amount, rcoptions, true, 0);
    }

    public Revision[] newPages(int amount, int rcoptions, int ... ns) throws IOException {
        return this.recentChanges(amount, rcoptions, true, ns);
    }

    public Revision[] recentChanges(int amount) throws IOException {
        return this.recentChanges(amount, 0, false, 0);
    }

    public Revision[] recentChanges(int amount, int ... ns) throws IOException {
        return this.recentChanges(amount, 0, false, ns);
    }

    public Revision[] recentChanges(int amount, int rcoptions, int ... ns) throws IOException {
        return this.recentChanges(amount, rcoptions, false, ns);
    }

    protected Revision[] recentChanges(int amount, int rcoptions, boolean newpages, int ... ns) throws IOException {
        StringBuilder url = new StringBuilder(this.query);
        url.append("list=recentchanges&rcprop=title%7Cids%7Cuser%7Ctimestamp%7Cflags%7Ccomment%7Csizes&rclimit=max");
        this.constructNamespaceString(url, "rc", ns);
        if (newpages) {
            url.append("&rctype=new");
        }
        if (rcoptions > 0) {
            url.append("&rcshow=");
            if ((rcoptions & 1) == 1) {
                url.append("!anon%7C");
            }
            if ((rcoptions & 4) == 4) {
                url.append("!self%7C");
            }
            if ((rcoptions & 8) == 8) {
                url.append("!minor%7C");
            }
            if ((rcoptions & 0x10) == 16) {
                url.append("!patrolled%7C");
            }
            if ((rcoptions & 2) == 2) {
                url.append("!bot%7C");
            }
            url.delete(url.length() - 3, url.length());
        }
        url.append("&rcstart=");
        String rcstart = this.calendarToTimestamp(this.makeCalendar());
        ArrayList<Revision> revisions = new ArrayList<Revision>(750);
        do {
            String temp = url.toString();
            String line = this.fetch(temp + rcstart, newpages ? "newPages" : "recentChanges");
            rcstart = this.parseAttribute(line, "rcstart", 0);
            int i = line.indexOf("<rc ");
            while (i > 0 && revisions.size() < amount) {
                int j = line.indexOf("/>", i);
                revisions.add(this.parseRevision(line.substring(i, j), ALL_LOGS));
                ++i;
                i = line.indexOf("<rc ", i);
            }
        } while (revisions.size() < amount);
        int temp = revisions.size();
        this.log(Level.INFO, "recentChanges", "Successfully retrieved recent changes (" + temp + " revisions)");
        return revisions.toArray(new Revision[temp]);
    }

    public String[][] getInterWikiBacklinks(String prefix) throws IOException {
        return this.getInterWikiBacklinks(prefix, "|");
    }

    public String[][] getInterWikiBacklinks(String prefix, String title) throws IOException {
        if (title.equals("|") && prefix.isEmpty()) {
            throw new IllegalArgumentException("Interwiki backlinks: title specified without prefix!");
        }
        StringBuilder url = new StringBuilder(this.query);
        url.append("list=iwbacklinks&iwbllimit=max&iwblprefix=");
        url.append(prefix);
        if (!title.equals("|")) {
            url.append("&iwbltitle=");
            url.append(title);
        }
        url.append("&iwblprop=iwtitle%7Ciwprefix");
        String iwblcontinue = ALL_LOGS;
        ArrayList<String[]> links = new ArrayList<String[]>(500);
        do {
            String line = iwblcontinue.isEmpty() ? this.fetch(url.toString(), "getInterWikiBacklinks") : this.fetch(url.toString() + "&iwblcontinue=" + iwblcontinue, "getInterWikiBacklinks");
            iwblcontinue = this.parseAttribute(line, "iwblcontinue", 0);
            int x = line.indexOf("<iw ");
            while (x > 0) {
                links.add(new String[]{this.parseAttribute(line, "title", x), this.parseAttribute(line, "iwprefix", x) + ':' + this.parseAttribute(line, "iwtitle", x)});
                ++x;
                x = line.indexOf("<iw ", x);
            }
        } while (iwblcontinue != null);
        this.log(Level.INFO, "getInterWikiBacklinks", "Successfully retrieved interwiki backlinks (" + links.size() + " interwikis)");
        return (String[][])links.toArray((T[])new String[0][0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String fetch(String url, String caller) throws IOException {
        String temp;
        this.logurl(url, caller);
        URLConnection connection = this.makeConnection(url);
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(180000);
        this.setCookies(connection);
        connection.connect();
        this.grabCookies(connection);
        int lag = connection.getHeaderFieldInt("X-Database-Lag", -5);
        if (lag > this.maxlag) {
            try {
                Wiki wiki = this;
                synchronized (wiki) {
                    int time = connection.getHeaderFieldInt("Retry-After", 10);
                    this.log(Level.WARNING, caller, "Current database lag " + lag + " s exceeds " + this.maxlag + " s, waiting " + time + " s.");
                    Thread.sleep(time * 1000);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.fetch(url, caller);
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(this.zipped ? new GZIPInputStream(connection.getInputStream()) : connection.getInputStream(), "UTF-8"));){
            String line;
            StringBuilder text = new StringBuilder(100000);
            while ((line = in.readLine()) != null) {
                text.append(line);
                text.append("\n");
            }
            temp = text.toString();
        }
        if (temp.contains("<error code=")) {
            if ((this.assertion & 2) == 2 && temp.contains("error code=\"assertbotfailed\"")) {
                throw new AssertionError((Object)"Bot privileges missing or revoked, or session expired.");
            }
            if ((this.assertion & 1) == 1 && temp.contains("error code=\"assertuserfailed\"")) {
                throw new AssertionError((Object)"Session expired.");
            }
            if (!temp.matches("code=\"(rvnosuchsection)")) {
                throw new UnknownError("MW API error. Server response was: " + temp);
            }
        }
        return temp;
    }

    protected String post(String url, String text, String caller) throws IOException {
        this.logurl(url, caller);
        URLConnection connection = this.makeConnection(url);
        this.setCookies(connection);
        connection.setDoOutput(true);
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(180000);
        connection.connect();
        try (OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");){
            out.write(text);
        }
        StringBuilder temp = new StringBuilder(100000);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(this.zipped ? new GZIPInputStream(connection.getInputStream()) : connection.getInputStream(), "UTF-8"));){
            String line;
            this.grabCookies(connection);
            while ((line = in.readLine()) != null) {
                temp.append(line);
                temp.append("\n");
            }
        }
        return temp.toString();
    }

    protected String multipartPost(String url, Map<String, ?> params, String caller) throws IOException {
        this.logurl(url, caller);
        URLConnection connection = this.makeConnection(url);
        String boundary = "----------NEXT PART----------";
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        this.setCookies(connection);
        connection.setDoOutput(true);
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(180000);
        connection.connect();
        boundary = "--" + boundary + "\r\n";
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(bout);){
            out.writeBytes(boundary);
            for (Map.Entry<String, ?> entry : params.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                out.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"\r\n");
                if (value instanceof String) {
                    out.writeBytes("Content-Type: text/plain; charset=UTF-8\r\n\r\n");
                    out.write(((String)value).getBytes("UTF-8"));
                } else if (value instanceof byte[]) {
                    out.writeBytes("Content-Type: application/octet-stream\r\n\r\n");
                    out.write((byte[])value);
                } else {
                    throw new UnsupportedOperationException("Unrecognized data type");
                }
                out.writeBytes("\r\n");
                out.writeBytes(boundary);
            }
            out.writeBytes("--\r\n");
        }
        var8_8 = null;
        try (OutputStream uout = connection.getOutputStream();){
            uout.write(bout.toByteArray());
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        StringBuilder temp = new StringBuilder(100000);
        BufferedReader in = new BufferedReader(new InputStreamReader(this.zipped ? new GZIPInputStream(connection.getInputStream()) : connection.getInputStream(), "UTF-8"));
        Object object = null;
        try {
            String line;
            this.grabCookies(connection);
            while ((line = in.readLine()) != null) {
                temp.append(line);
                temp.append("\n");
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (object != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        return temp.toString();
    }

    protected URLConnection makeConnection(String url) throws IOException {
        return new URL(url).openConnection();
    }

    protected void checkErrorsAndUpdateStatus(String line, String caller) throws IOException, LoginException {
        if (this.statuscounter > this.statusinterval) {
            this.user.getUserInfo();
            if ((this.assertion & 8) == 8 && !this.user.isA(FULL_PROTECTION)) {
                throw new AssertionError((Object)"Sysop privileges missing or revoked, or session expired");
            }
            if ((this.assertion & 4) == 4 && this.hasNewMessages()) {
                throw new AssertionError((Object)"User has new messages");
            }
            this.statuscounter = 0;
        } else {
            ++this.statuscounter;
        }
        if (line.contains("result=\"Success\"")) {
            return;
        }
        if (line.isEmpty()) {
            throw new UnknownError("Received empty response from server!");
        }
        if ((this.assertion & 2) == 2 && line.contains("error code=\"assertbotfailed\"")) {
            throw new AssertionError((Object)"Bot privileges missing or revoked, or session expired.");
        }
        if ((this.assertion & 1) == 1 && line.contains("error code=\"assertuserfailed\"")) {
            throw new AssertionError((Object)"Session expired.");
        }
        if (line.contains("error code=\"permissiondenied\"")) {
            throw new CredentialNotFoundException("Permission denied.");
        }
        if (line.contains("error code=\"ratelimited\"")) {
            this.log(Level.WARNING, caller, "Server-side throttle hit.");
            throw new HttpRetryException("Action throttled.", 503);
        }
        if (line.contains("error code=\"blocked") || line.contains("error code=\"autoblocked\"")) {
            this.log(Level.SEVERE, caller, "Cannot " + caller + " - user is blocked!.");
            throw new AccountLockedException("Current user is blocked!");
        }
        if (line.contains("error code=\"readonly\"")) {
            this.log(Level.WARNING, caller, "Database locked!");
            throw new HttpRetryException("Database locked!", 503);
        }
        if (line.contains("error code=\"unknownerror\"")) {
            throw new UnknownError("Unknown MediaWiki API error, response was " + line);
        }
        throw new IOException("MediaWiki error, response was " + line);
    }

    protected String decode(String in) {
        in = in.replace("&lt;", "<").replace("&gt;", ">");
        in = in.replace("&quot;", "\"");
        in = in.replace("&#039;", "'");
        in = in.replace("&amp;", "&");
        return in;
    }

    protected String parseAttribute(String xml, String attribute, int index) {
        if (xml.contains(attribute + "=\"")) {
            int a = xml.indexOf(attribute + "=\"", index) + attribute.length() + 2;
            int b = xml.indexOf(34, a);
            return this.decode(xml.substring(a, b));
        }
        return null;
    }

    protected void constructNamespaceString(StringBuilder sb, String id, int ... namespaces) {
        int temp = namespaces.length;
        if (temp == 0) {
            return;
        }
        sb.append("&");
        sb.append(id);
        sb.append("namespace=");
        for (int i = 0; i < temp - 1; ++i) {
            sb.append(namespaces[i]);
            sb.append("%7C");
        }
        sb.append(namespaces[temp - 1]);
    }

    protected String[] constructTitleString(String[] titles) throws IOException {
        String[] ret = new String[titles.length / this.slowmax + 1];
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < titles.length; ++i) {
            buffer.append(this.normalize(titles[i]));
            if (i == titles.length - 1 || i % this.slowmax == this.slowmax - 1) {
                ret[i / this.slowmax] = URLEncoder.encode(buffer.toString(), "UTF-8");
                buffer = new StringBuilder();
                continue;
            }
            buffer.append("|");
        }
        return ret;
    }

    public String normalize(String s) throws IOException {
        if (s.startsWith(":")) {
            s = s.substring(1);
        }
        if (s.isEmpty()) {
            return s;
        }
        int ns = this.namespace(s);
        if (ns != 0) {
            int colon = s.indexOf(":");
            s = this.namespaceIdentifier(ns) + s.substring(colon);
        }
        char[] temp = s.toCharArray();
        if (this.wgCapitalLinks) {
            if (ns == 0) {
                temp[0] = Character.toUpperCase(temp[0]);
            } else {
                int index = this.namespaceIdentifier(ns).length() + 1;
                temp[index] = Character.toUpperCase(temp[index]);
            }
        }
        for (int i = 0; i < temp.length; ++i) {
            switch (temp[i]) {
                case '<': 
                case '>': 
                case '[': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    throw new IllegalArgumentException(s + " is an illegal title");
                }
                case '_': {
                    temp[i] = 32;
                }
            }
        }
        String temp2 = new String(temp).trim().replaceAll("\\s+", " ");
        return Normalizer.normalize(temp2, Normalizer.Form.NFC);
    }

    private synchronized void throttle(long start) {
        try {
            long time = (long)this.throttle - System.currentTimeMillis() + start;
            if (time > 0L) {
                Thread.sleep(time);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected boolean checkRights(Map<String, Object> pageinfo, String action) throws IOException {
        Map protectionstate = (Map)pageinfo.get("protection");
        if (protectionstate.containsKey(action)) {
            String level = (String)protectionstate.get(action);
            if (level.equals(SEMI_PROTECTION)) {
                return this.user.isAllowedTo(SEMI_PROTECTION);
            }
            if (level.equals(FULL_PROTECTION)) {
                return this.user.isAllowedTo("editprotected");
            }
        }
        if ((Boolean)protectionstate.get("cascade") == Boolean.TRUE) {
            return this.user.isAllowedTo("editprotected");
        }
        return true;
    }

    protected void setCookies(URLConnection u) {
        StringBuilder cookie = new StringBuilder(100);
        for (Map.Entry<String, String> entry : this.cookies.entrySet()) {
            cookie.append(entry.getKey());
            cookie.append("=");
            cookie.append(entry.getValue());
            cookie.append("; ");
        }
        u.setRequestProperty("Cookie", cookie.toString());
        if (this.zipped) {
            u.setRequestProperty("Accept-encoding", "gzip");
        }
        u.setRequestProperty("User-Agent", this.useragent);
    }

    private void grabCookies(URLConnection u) {
        String headerName;
        int i = 1;
        while ((headerName = u.getHeaderFieldKey(i)) != null) {
            if (headerName.equals("Set-Cookie")) {
                String cookie = u.getHeaderField(i);
                cookie = cookie.substring(0, cookie.indexOf(59));
                String name = cookie.substring(0, cookie.indexOf(61));
                String value = cookie.substring(cookie.indexOf(61) + 1, cookie.length());
                if (!value.equals("deleted")) {
                    this.cookies.put(name, value);
                }
            }
            ++i;
        }
    }

    protected void log(Level level, String method, String text) {
        logger.logp(level, "Wiki", method, "[{0}] {1}", new Object[]{this.domain, text});
    }

    protected void logurl(String url, String method) {
        logger.logp(Level.INFO, "Wiki", method, "Fetching URL {0}", url);
    }

    public Calendar makeCalendar() {
        return new GregorianCalendar(TimeZone.getTimeZone(this.timezone));
    }

    protected String calendarToTimestamp(Calendar c) {
        return String.format("%04d%02d%02d%02d%02d%02d", c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13));
    }

    protected final Calendar timestampToCalendar(String timestamp, boolean api) {
        Calendar calendar = this.makeCalendar();
        if (api) {
            timestamp = this.convertTimestamp(timestamp);
        }
        int year = Integer.parseInt(timestamp.substring(0, 4));
        int month = Integer.parseInt(timestamp.substring(4, 6)) - 1;
        int day = Integer.parseInt(timestamp.substring(6, 8));
        int hour = Integer.parseInt(timestamp.substring(8, 10));
        int minute = Integer.parseInt(timestamp.substring(10, 12));
        int second = Integer.parseInt(timestamp.substring(12, 14));
        calendar.set(year, month, day, hour, minute, second);
        return calendar;
    }

    protected String convertTimestamp(String timestamp) {
        StringBuilder ts = new StringBuilder(timestamp.substring(0, 4));
        ts.append(timestamp.substring(5, 7));
        ts.append(timestamp.substring(8, 10));
        ts.append(timestamp.substring(11, 13));
        ts.append(timestamp.substring(14, 16));
        ts.append(timestamp.substring(17, 19));
        return ts.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.statuscounter = this.statusinterval;
    }

    public class Revision
    implements Comparable<Revision> {
        private boolean minor;
        private boolean bot;
        private boolean rvnew;
        private String summary;
        private long revid;
        private long rcid = -1L;
        private long previous = 0L;
        private long next = 0L;
        private Calendar timestamp;
        private String user;
        private String title;
        private String rollbacktoken = null;
        private int size = 0;
        private int sizediff = 0;
        private boolean summaryDeleted = false;
        private boolean userDeleted = false;
        private boolean contentDeleted = false;
        private boolean pageDeleted = false;

        public Revision(long revid, Calendar timestamp, String title, String summary, String user, boolean minor, boolean bot, boolean rvnew, int size) {
            this.revid = revid;
            this.timestamp = timestamp;
            this.summary = summary;
            this.minor = minor;
            this.user = user;
            this.title = title;
            this.bot = bot;
            this.rvnew = rvnew;
            this.size = size;
        }

        public String getText() throws IOException {
            String temp;
            if (this.revid < 1L) {
                throw new IllegalArgumentException("Log entries have no valid content!");
            }
            if (this.pageDeleted) {
                String url = Wiki.this.query + "prop=deletedrevisions&drvprop=content&revids=" + this.revid;
                temp = Wiki.this.fetch(url, "Revision.getText");
            } else {
                String url = Wiki.this.base + URLEncoder.encode(this.title, "UTF-8") + "&oldid=" + this.revid + "&action=raw";
                temp = Wiki.this.fetch(url, "Revision.getText");
            }
            Wiki.this.log(Level.INFO, "Revision.getText", "Successfully retrieved text of revision " + this.revid);
            return temp;
        }

        public String getRenderedText() throws IOException {
            String temp;
            if (this.revid < 1L) {
                throw new IllegalArgumentException("Log entries have no valid content!");
            }
            if (this.pageDeleted) {
                String url = Wiki.this.query + "prop=deletedrevisions&drvprop=content&drvparse=1&revids=" + this.revid;
                temp = Wiki.this.fetch(url, "Revision.getRenderedText");
            } else {
                String url = Wiki.this.base + "&action=render&oldid=" + this.revid;
                temp = Wiki.this.fetch(url, "Revision.getRenderedText");
            }
            Wiki.this.log(Level.INFO, "Revision.getRenderedText", "Successfully retrieved rendered text of revision " + this.revid);
            return Wiki.this.decode(temp);
        }

        public boolean isContentDeleted() {
            return this.contentDeleted;
        }

        public String diff(Revision other) throws IOException {
            return this.diff(other.revid, Wiki.ALL_LOGS);
        }

        public String diff(String text) throws IOException {
            return this.diff(0L, text);
        }

        public String diff(long oldid) throws IOException {
            return this.diff(oldid, Wiki.ALL_LOGS);
        }

        protected String diff(long oldid, String text) throws IOException {
            StringBuilder temp = new StringBuilder("revids=");
            temp.append(this.revid);
            if (oldid == -1L) {
                temp.append("&rvdiffto=next");
            } else if (oldid == -2L) {
                temp.append("&rvdiffto=cur");
            } else if (oldid == -3L) {
                temp.append("&rvdiffto=prev");
            } else if (oldid == 0L) {
                temp.append("&rvdifftotext=");
                temp.append(text);
            } else {
                temp.append("&rvdiffto=");
                temp.append(oldid);
            }
            String line = Wiki.this.post(Wiki.this.query + "prop=revisions", temp.toString(), "Revision.diff");
            if (line.contains("</diff>")) {
                int a = line.indexOf("<diff");
                a = line.indexOf(">", a) + 1;
                int b = line.indexOf("</diff>", a);
                return Wiki.this.decode(line.substring(a, b));
            }
            return null;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Revision)) {
                return false;
            }
            return this.revid == ((Revision)o).revid;
        }

        public int hashCode() {
            return (int)this.revid * 2 - Wiki.this.hashCode();
        }

        public boolean isMinor() {
            return this.minor;
        }

        public boolean isBot() {
            return this.bot;
        }

        public boolean isNew() {
            return this.rvnew;
        }

        public String getSummary() {
            return this.summary;
        }

        public boolean isSummaryDeleted() {
            return this.summaryDeleted;
        }

        public String getUser() {
            return this.user;
        }

        public boolean isUserDeleted() {
            return this.userDeleted;
        }

        public boolean isPageDeleted() {
            return this.pageDeleted;
        }

        public String getPage() {
            return this.title;
        }

        public long getRevid() {
            return this.revid;
        }

        public Calendar getTimestamp() {
            return this.timestamp;
        }

        public int getSize() {
            return this.size;
        }

        public int getSizeDiff() {
            return this.sizediff;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Revision[oldid=");
            sb.append(this.revid);
            sb.append(",page=\"");
            sb.append(this.title);
            sb.append("\",user=");
            sb.append(this.user == null ? "[hidden]" : this.user);
            sb.append(",userdeleted=");
            sb.append(this.userDeleted);
            sb.append(",timestamp=");
            sb.append(Wiki.this.calendarToTimestamp(this.timestamp));
            sb.append(",summary=\"");
            sb.append(this.summary == null ? "[hidden]" : this.summary);
            sb.append("\",summarydeleted=");
            sb.append(this.summaryDeleted);
            sb.append(",minor=");
            sb.append(this.minor);
            sb.append(",bot=");
            sb.append(this.bot);
            sb.append(",size=");
            sb.append(this.size);
            sb.append(",rcid=");
            sb.append(this.rcid == -1L ? "unset" : Long.valueOf(this.rcid));
            sb.append(",previous=");
            sb.append(this.previous);
            sb.append(",next=");
            sb.append(this.next);
            sb.append(",rollbacktoken=");
            sb.append(this.rollbacktoken == null ? "null" : this.rollbacktoken);
            sb.append("]");
            return sb.toString();
        }

        @Override
        public int compareTo(Revision other) {
            if (this.timestamp.equals(other.timestamp)) {
                return 0;
            }
            return this.timestamp.after(other.timestamp) ? 1 : -1;
        }

        public Revision getPrevious() throws IOException {
            return this.previous == 0L ? null : Wiki.this.getRevision(this.previous);
        }

        public Revision getNext() throws IOException {
            return this.next == 0L ? null : Wiki.this.getRevision(this.next);
        }

        public void setRcid(long rcid) {
            this.rcid = rcid;
        }

        public long getRcid() {
            return this.rcid;
        }

        public void setRollbackToken(String token) {
            this.rollbacktoken = token;
        }

        public String getRollbackToken() {
            return this.rollbacktoken;
        }

        public void rollback() throws IOException, LoginException {
            Wiki.this.rollback(this, false, Wiki.ALL_LOGS);
        }

        public void rollback(boolean bot, String reason) throws IOException, LoginException {
            Wiki.this.rollback(this, bot, reason);
        }
    }

    public class LogEntry
    implements Comparable<LogEntry> {
        private String type;
        private String action;
        private String reason;
        private User user;
        private String target;
        private Calendar timestamp;
        private Object details;

        protected LogEntry(String type, String action, String reason, User user, String target, String timestamp, Object details) {
            this.type = type;
            this.action = action;
            this.reason = reason;
            this.user = user;
            this.target = target;
            this.timestamp = Wiki.this.timestampToCalendar(timestamp, false);
            this.details = details;
        }

        public String getType() {
            return this.type;
        }

        public String getAction() {
            return this.action;
        }

        public String getReason() {
            return this.reason;
        }

        public User getUser() {
            return this.user;
        }

        public String getTarget() {
            return this.target;
        }

        public Calendar getTimestamp() {
            return this.timestamp;
        }

        public Object getDetails() {
            return this.details;
        }

        public String toString() {
            StringBuilder s = new StringBuilder("LogEntry[type=");
            s.append(this.type);
            s.append(",action=");
            s.append(this.action == null ? "[hidden]" : this.action);
            s.append(",user=");
            s.append(this.user == null ? "[hidden]" : this.user.getUsername());
            s.append(",timestamp=");
            s.append(Wiki.this.calendarToTimestamp(this.timestamp));
            s.append(",target=");
            s.append(this.target == null ? "[hidden]" : this.target);
            s.append(",reason=\"");
            s.append(this.reason == null ? "[hidden]" : this.reason);
            s.append("\",details=");
            if (this.details instanceof Object[]) {
                s.append(Arrays.asList((Object[])this.details));
            } else {
                s.append(this.details);
            }
            s.append("]");
            return s.toString();
        }

        @Override
        public int compareTo(LogEntry other) {
            if (this.timestamp.equals(other.timestamp)) {
                return 0;
            }
            return this.timestamp.after(other.timestamp) ? 1 : -1;
        }
    }

    public class User
    implements Cloneable,
    Serializable {
        private String username;
        private String[] rights = null;
        private String[] groups = null;

        protected User(String username) {
            this.username = username;
        }

        public String getUsername() {
            return this.username;
        }

        public Map<String, Object> getUserInfo() throws IOException {
            String info = Wiki.this.fetch(Wiki.this.query + "list=users&usprop=editcount%7Cgroups%7Crights%7Cemailable%7Cblockinfo%7Cgender%7Cregistration&ususers=" + URLEncoder.encode(this.username, "UTF-8"), "getUserInfo");
            HashMap<String, Object> ret = new HashMap<String, Object>(10);
            ret.put("blocked", info.contains("blockedby=\""));
            ret.put("emailable", info.contains("emailable=\""));
            ret.put("editcount", Integer.parseInt(Wiki.this.parseAttribute(info, "editcount", 0)));
            ret.put("gender", (Object)Gender.valueOf(Wiki.this.parseAttribute(info, "gender", 0)));
            String registrationdate = Wiki.this.parseAttribute(info, "registration", 0);
            if (registrationdate != null && !registrationdate.isEmpty()) {
                ret.put("created", Wiki.this.timestampToCalendar(registrationdate, true));
            }
            ArrayList<String> temp = new ArrayList<String>();
            int x = info.indexOf("<g>");
            while (x > 0) {
                int y = info.indexOf("</g>", x);
                temp.add(info.substring(x + 3, y));
                ++x;
                x = info.indexOf("<g>", x);
            }
            String[] temp2 = temp.toArray(new String[temp.size()]);
            if (this.equals(Wiki.this.getCurrentUser())) {
                this.groups = temp2;
            }
            ret.put("groups", temp2);
            temp.clear();
            int x2 = info.indexOf("<r>");
            while (x2 > 0) {
                int y = info.indexOf("</r>", x2);
                temp.add(info.substring(x2 + 3, y));
                ++x2;
                x2 = info.indexOf("<r>", x2);
            }
            temp2 = temp.toArray(new String[temp.size()]);
            if (this.equals(Wiki.this.getCurrentUser())) {
                this.rights = temp2;
            }
            ret.put(Wiki.USER_RIGHTS_LOG, temp2);
            return ret;
        }

        public boolean isAllowedTo(String right) throws IOException {
            if (this.rights == null) {
                this.rights = (String[])this.getUserInfo().get(Wiki.USER_RIGHTS_LOG);
            }
            for (String r : this.rights) {
                if (!r.equals(right)) continue;
                return true;
            }
            return false;
        }

        public boolean isA(String group) throws IOException {
            if (this.groups == null) {
                this.groups = (String[])this.getUserInfo().get("groups");
            }
            for (String g : this.groups) {
                if (!g.equals(group)) continue;
                return true;
            }
            return false;
        }

        public LogEntry[] blockLog() throws IOException {
            return Wiki.this.getLogEntries(null, null, Integer.MAX_VALUE, Wiki.BLOCK_LOG, Wiki.ALL_LOGS, null, "User:" + this.username, 2);
        }

        public boolean isBlocked() throws IOException {
            return Wiki.this.getIPBlockList(this.username, null, null).length != 0;
        }

        public int countEdits() throws IOException {
            return (Integer)this.getUserInfo().get("editcount");
        }

        public Revision[] contribs(int ... ns) throws IOException {
            return Wiki.this.contribs(this.username, ns);
        }

        public User clone() {
            try {
                return (User)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public boolean equals(Object x) {
            return x instanceof User && this.username.equals(((User)x).username);
        }

        public String toString() {
            StringBuilder temp = new StringBuilder("User[username=");
            temp.append(this.username);
            temp.append("groups=");
            temp.append(this.groups != null ? Arrays.toString(this.groups) : "unset");
            temp.append("]");
            return temp.toString();
        }

        public int hashCode() {
            return this.username.hashCode() * 2 + 1;
        }
    }

    public static enum Gender {
        male,
        female,
        unknown;

    }
}

