/*
 * Decompiled with CFR 0.152.
 */
package com.bitso;

import com.bitso.exceptions.BitsoExceptionJSONPayload;
import com.bitso.helpers.Helpers;
import java.math.BigDecimal;
import org.json.JSONArray;
import org.json.JSONObject;

public class BitsoFee {
    public BigDecimal mxnBtcFeeDecimal;
    public BigDecimal mxnBtcFeePercent;
    public BigDecimal mxnEthFeeDecimal;
    public BigDecimal mxnEthFeePercent;

    public BitsoFee(JSONObject o) {
        String book = "";
        if (o.has("payload")) {
            JSONObject payload = o.getJSONObject("payload");
            JSONArray jsonFees = payload.getJSONArray("fees");
            int totalElements = jsonFees.length();
            block8: for (int i = 0; i < totalElements; ++i) {
                JSONObject fee = jsonFees.getJSONObject(i);
                switch (book = Helpers.getString(fee, "book")) {
                    case "btc_mxn": {
                        this.mxnBtcFeeDecimal = Helpers.getBD(fee, "fee_decimal");
                        this.mxnBtcFeePercent = Helpers.getBD(fee, "fee_percent");
                        continue block8;
                    }
                    case "eth_mxn": {
                        this.mxnEthFeeDecimal = Helpers.getBD(fee, "fee_decimal");
                        this.mxnEthFeePercent = Helpers.getBD(fee, "fee_percent");
                        continue block8;
                    }
                    default: {
                        System.out.println(book + " is not an expected book");
                    }
                }
            }
        } else {
            throw new BitsoExceptionJSONPayload(o.toString() + "does not contains payload key");
        }
    }

    public String toString() {
        return Helpers.fieldPrinter(this);
    }
}

