/*
 * Decompiled with CFR 0.152.
 */
package com.bitso;

import com.bitso.helpers.Helpers;
import java.math.BigDecimal;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONObject;

public class BitsoOperation {
    public String entryId;
    public String operationDescription;
    public Date operationDate;
    public BalanceUpdate[] afterOperationBalances;
    public JSONObject details;

    public BitsoOperation(JSONObject o) {
        this.entryId = Helpers.getString(o, "eid");
        this.operationDescription = Helpers.getString(o, "operation");
        this.operationDate = Helpers.getZonedDatetime(o, "created_at");
        this.afterOperationBalances = this.getOperationBalances(o.getJSONArray("balance_updates"));
        this.details = o.getJSONObject("details");
    }

    private BalanceUpdate[] getOperationBalances(JSONArray array) {
        int totalBalances = array.length();
        BalanceUpdate[] balances = new BalanceUpdate[totalBalances];
        for (int i = 0; i < totalBalances; ++i) {
            balances[i] = new BalanceUpdate(array.getJSONObject(i));
        }
        return balances;
    }

    public String toString() {
        return Helpers.fieldPrinter(this);
    }

    private class BalanceUpdate {
        String currency;
        BigDecimal amount;

        public BalanceUpdate(JSONObject o) {
            this.currency = Helpers.getString(o, "currency");
            this.amount = Helpers.getBD(o, "amount");
        }
    }
}

