/*
 * Decompiled with CFR 0.152.
 */
package com.bitso;

import com.bitso.BitsoBook;
import com.bitso.helpers.Helpers;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONObject;

public class BitsoOrderBook {
    public Date orderDate;
    public int sequence;
    public PulicOrder[] asks;
    public PulicOrder[] bids;

    public BitsoOrderBook(JSONObject o) {
        this.orderDate = Helpers.getZonedDatetime(o, "updated_at");
        this.sequence = Helpers.getInt(o, "sequence");
        this.processOrders(o);
    }

    private void processOrders(JSONObject o) {
        int i;
        if (o.has("asks")) {
            JSONArray asksArray = o.getJSONArray("asks");
            int totalAsks = asksArray.length();
            this.asks = new PulicOrder[totalAsks];
            for (i = 0; i < totalAsks; ++i) {
                this.asks[i] = new PulicOrder(asksArray.getJSONObject(i));
            }
        }
        if (o.has("bids")) {
            JSONArray bidsArray = o.getJSONArray("bids");
            int totalBids = bidsArray.length();
            this.bids = new PulicOrder[totalBids];
            for (i = 0; i < totalBids; ++i) {
                this.bids[i] = new PulicOrder(bidsArray.getJSONObject(i));
            }
        }
    }

    public String toString() {
        return Helpers.fieldPrinter(this);
    }

    public static class PulicOrder
    implements Comparable<PulicOrder> {
        public BitsoBook mBook;
        public BigDecimal mPrice;
        public BigDecimal mAmount;
        public String mOrderId;

        public PulicOrder(JSONObject o) {
            this.mBook = Helpers.getBook(Helpers.getString(o, "book"));
            this.mPrice = Helpers.getBD(o, "price");
            this.mAmount = Helpers.getBD(o, "amount");
            this.mOrderId = o.has("oid") ? Helpers.getString(o, "oid") : "";
        }

        public String toString() {
            return Helpers.fieldPrinter(this);
        }

        @Override
        public int compareTo(PulicOrder o) {
            return this.mPrice.compareTo(o.mPrice);
        }

        public static class Comparators {
            public static Comparator<PulicOrder> PRICE = new Comparator<PulicOrder>(){

                @Override
                public int compare(PulicOrder o1, PulicOrder o2) {
                    return o1.mPrice.compareTo(o2.mPrice);
                }
            };
        }
    }
}

