/*
 * Decompiled with CFR 0.152.
 */
package com.bitso.websockets;

import com.bitso.BitsoBook;
import com.bitso.exceptions.BitsoExceptionNotExpectedValue;
import com.bitso.helpers.Helpers;
import com.bitso.websockets.BitsoChannels;
import org.json.JSONObject;

public class BitsoStreamUpdate {
    protected BitsoChannels bitsoChannel;
    protected BitsoBook bitsoBook;

    public BitsoChannels getBitsoChannel() {
        return this.bitsoChannel;
    }

    public BitsoBook getBitsoBook() {
        return this.bitsoBook;
    }

    public BitsoStreamUpdate(JSONObject jsonObject) {
        this.bitsoChannel = this.getStream(Helpers.getString(jsonObject, "type"));
        this.bitsoBook = Helpers.getBook(Helpers.getString(jsonObject, "book"));
    }

    protected BitsoChannels getStream(String stream) {
        switch (stream) {
            case "diff-orders": {
                return BitsoChannels.DIFF_ORDERS;
            }
            case "orders": {
                return BitsoChannels.ORDERS;
            }
            case "trades": {
                return BitsoChannels.TRADES;
            }
        }
        String exceptionMessage = stream + "is not a supported stream";
        throw new BitsoExceptionNotExpectedValue(exceptionMessage);
    }
}

