/*
 * Decompiled with CFR 0.152.
 */
package com.bizo.asperatus.logging.error;

import com.bizo.asperatus.model.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MachineInfo {
    public static final Map<String, String> info = Collections.unmodifiableMap(MachineInfo.getMachineInfo());
    private static final List<Dimension> allDimensions = Collections.unmodifiableList(MachineInfo.toDimensions(info));
    public static final List<Dimension> defaultDimensions = Collections.unmodifiableList(MachineInfo.with("Application", "Version").toDimensions());

    private MachineInfo() {
    }

    public static MachineInfoBuilder with(String ... stringArray) {
        return new MachineInfoBuilder().with(stringArray);
    }

    public static MachineInfoBuilder with(Collection<String> collection) {
        return new MachineInfoBuilder().with(collection);
    }

    public static MachineInfoBuilder without(String ... stringArray) {
        return new MachineInfoBuilder().without(stringArray);
    }

    public static MachineInfoBuilder without(Collection<String> collection) {
        return new MachineInfoBuilder().without(collection);
    }

    private static final Map<String, String> ENV_MAPPING() {
        return new HashMap<String, String>(){
            {
                this.put("APPLICATION", "Application");
                this.put("STAGE", "Stage");
                this.put("EC2_INSTANCE_ID", "InstanceId");
                this.put("EC2_REGION", "Region");
                this.put("VERSION", "Version");
            }
        };
    }

    private static final Map<String, String> getMachineInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : MachineInfo.ENV_MAPPING().entrySet()) {
            String string = System.getProperty(entry.getKey(), System.getenv(entry.getKey()));
            if (string == null) continue;
            hashMap.put(entry.getValue(), string);
        }
        return hashMap;
    }

    private static final List<Dimension> toDimensions(Map<String, String> map) {
        ArrayList<Dimension> arrayList = new ArrayList<Dimension>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            arrayList.add(new Dimension(entry.getKey(), entry.getValue()));
        }
        return arrayList;
    }

    public static final class MachineInfoBuilder {
        private final Collection<Dimension> defaults;
        private Set<String> includes = new HashSet<String>();
        private Set<String> excludes = new HashSet<String>();

        MachineInfoBuilder(Collection<Dimension> collection) {
            this.defaults = collection;
        }

        MachineInfoBuilder() {
            this(allDimensions);
        }

        public MachineInfoBuilder with(Collection<String> collection) {
            this.includes.addAll(collection);
            return this;
        }

        public MachineInfoBuilder without(Collection<String> collection) {
            this.excludes.addAll(collection);
            return this;
        }

        public MachineInfoBuilder with(String ... stringArray) {
            this.includes.addAll(Arrays.asList(stringArray));
            return this;
        }

        public MachineInfoBuilder without(String ... stringArray) {
            this.excludes.addAll(Arrays.asList(stringArray));
            return this;
        }

        public List<Dimension> toDimensions() {
            ArrayList<Dimension> arrayList = new ArrayList<Dimension>(this.includes.size());
            for (Dimension dimension : this.defaults) {
                if (!this.includes.contains(dimension.getName()) || this.excludes.contains(dimension.getName())) continue;
                arrayList.add(dimension);
            }
            return arrayList;
        }
    }
}

