/*
 * Decompiled with CFR 0.152.
 */
package com.bizo.asperatus.rates;

import com.bizo.asperatus.model.Dimension;
import com.bizo.asperatus.model.Unit;
import com.bizo.asperatus.rates.RateTracker;
import com.bizo.asperatus.tracker.MetricTracker;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AsperatusRateTrackerScheduler {
    private static final Logger LOGGER = Logger.getLogger(AsperatusRateTrackerScheduler.class.getName());
    private final ScheduledExecutorService executor;
    private final Runnable runnable;
    private ScheduledFuture<?> currentFuture = null;
    private int frequency = 1;
    private TimeUnit frequencyUnit = TimeUnit.MINUTES;

    public AsperatusRateTrackerScheduler(final MetricTracker metricTracker, final String string, final List<Dimension> list, final RateTracker rateTracker, ScheduledExecutorService scheduledExecutorService) {
        this.executor = scheduledExecutorService;
        this.runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    double d = rateTracker.getRateAndResetPeriod();
                    metricTracker.track(string, (Number)d, Unit.CountSecond, list);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Exception flushing rate to Asperatus for metric " + string, exception);
                }
            }
        };
    }

    public void start() {
        if (this.currentFuture != null) {
            throw new IllegalStateException("This AsperatusRateTrackerScheduler has already been started.");
        }
        this.currentFuture = this.executor.scheduleAtFixedRate(this.runnable, this.frequency, this.frequency, this.frequencyUnit);
    }

    public void stop() {
        if (this.currentFuture == null) {
            throw new IllegalStateException("This AsperatusRateTrackerScheduler has already been stopped.");
        }
        this.currentFuture.cancel(true);
    }

    public boolean isStarted() {
        return this.currentFuture != null;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int n) {
        if (this.isStarted()) {
            throw new IllegalStateException("The AsperatusRateTrackerScheduler must be stopped to adjust the frequency.");
        }
        this.frequency = n;
    }

    public TimeUnit getFrequencyUnit() {
        return this.frequencyUnit;
    }

    public void setFrequencyUnit(TimeUnit timeUnit) {
        if (this.isStarted()) {
            throw new IllegalStateException("The AsperatusRateTrackerScheduler must be stopped to adjust the frequencyUnit.");
        }
        this.frequencyUnit = timeUnit;
    }
}

