/*
 * Decompiled with CFR 0.152.
 */
package com.bizo.asperatus.rates;

import com.bizo.asperatus.rates.RateTracker;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ThreadSafeRateTracker
implements RateTracker {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock trackLock = this.lock.readLock();
    private final Lock flushLock = this.lock.writeLock();
    private final AtomicLong counter = new AtomicLong(0L);
    private final Stopwatch stopwatch;

    public ThreadSafeRateTracker() {
        this(Stopwatch.createUnstarted());
    }

    public ThreadSafeRateTracker(Stopwatch stopwatch) {
        Preconditions.checkNotNull((Object)stopwatch);
        this.stopwatch = stopwatch;
        this.stopwatch.start();
    }

    @Override
    public void track() {
        this.trackLock.lock();
        try {
            this.counter.incrementAndGet();
        }
        finally {
            this.trackLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getRateAndResetPeriod() {
        double d;
        double d2;
        this.flushLock.lock();
        try {
            this.stopwatch.stop();
            d2 = this.stopwatch.elapsed(TimeUnit.SECONDS);
            d = this.counter.getAndSet(0L);
            this.stopwatch.reset();
            this.stopwatch.start();
        }
        finally {
            this.flushLock.unlock();
        }
        return d / d2;
    }
}

