/*
 * Decompiled with CFR 0.152.
 */
package com.bizo.asperatus.tracker.impl;

import com.bizo.asperatus.model.Dimension;
import com.bizo.asperatus.model.Unit;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

final class Aggregation {
    private final String name;
    private final double count;
    private final double sum;
    private final double min;
    private final double max;
    private final Unit unit;
    private final List<Dimension> dimensions;

    public Aggregation(String string, double d, double d2, double d3, double d4, List<Dimension> list) {
        this(string, d, d2, d3, d4, Unit.Count, list);
    }

    public Aggregation(String string, double d, double d2, double d3, double d4, Unit unit, List<Dimension> list) {
        this.name = string;
        this.count = d;
        this.sum = d2;
        this.min = d3;
        this.max = d4;
        this.unit = unit;
        this.dimensions = list;
    }

    public String getName() {
        return this.name;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public double getCount() {
        return this.count;
    }

    public double getSum() {
        return this.sum;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.count);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.dimensions == null ? 0 : this.dimensions.hashCode());
        l = Double.doubleToLongBits(this.max);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.min);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        l = Double.doubleToLongBits(this.sum);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.unit == null ? 0 : this.unit.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Aggregation aggregation = (Aggregation)object;
        if (Double.doubleToLongBits(this.count) != Double.doubleToLongBits(aggregation.count)) {
            return false;
        }
        if (this.dimensions == null ? aggregation.dimensions != null : !this.dimensions.equals(aggregation.dimensions)) {
            return false;
        }
        if (Double.doubleToLongBits(this.max) != Double.doubleToLongBits(aggregation.max)) {
            return false;
        }
        if (Double.doubleToLongBits(this.min) != Double.doubleToLongBits(aggregation.min)) {
            return false;
        }
        if (this.name == null ? aggregation.name != null : !this.name.equals(aggregation.name)) {
            return false;
        }
        if (Double.doubleToLongBits(this.sum) != Double.doubleToLongBits(aggregation.sum)) {
            return false;
        }
        return this.unit == aggregation.unit;
    }
}

