/*
 * Decompiled with CFR 0.152.
 */
package com.bizo.asperatus.tracker.impl;

import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.StatisticSet;
import com.bizo.asperatus.model.Unit;
import com.bizo.asperatus.tracker.impl.Aggregation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class AggregationUtils {
    private AggregationUtils() {
    }

    public static List<MetricDatum> toMetricDatum(List<Aggregation> list) {
        ArrayList<MetricDatum> arrayList = new ArrayList<MetricDatum>(list.size());
        for (Aggregation aggregation : list) {
            arrayList.add(AggregationUtils.toMetricDatum(aggregation));
        }
        return arrayList;
    }

    public static MetricDatum toMetricDatum(Aggregation aggregation) {
        MetricDatum metricDatum = new MetricDatum();
        for (com.bizo.asperatus.model.Dimension dimension : aggregation.getDimensions()) {
            Dimension dimension2 = new Dimension();
            dimension2.setName(dimension.getName());
            dimension2.setValue(dimension.getValue());
            metricDatum.withDimensions(new Dimension[]{dimension2});
        }
        metricDatum.setUnit(aggregation.getUnit().getValue());
        metricDatum.setMetricName(aggregation.getName());
        StatisticSet statisticSet = new StatisticSet();
        statisticSet.setSum(Double.valueOf(aggregation.getSum()));
        statisticSet.setSampleCount(Double.valueOf(aggregation.getCount()));
        statisticSet.setMaximum(Double.valueOf(aggregation.getMax()));
        statisticSet.setMinimum(Double.valueOf(aggregation.getMin()));
        metricDatum.setStatisticValues(statisticSet);
        return metricDatum;
    }

    public static Aggregation toAggregation(MetricDatum metricDatum) {
        Object object2;
        ArrayList<com.bizo.asperatus.model.Dimension> arrayList = new ArrayList<com.bizo.asperatus.model.Dimension>(metricDatum.getDimensions().size());
        for (Object object2 : metricDatum.getDimensions()) {
            arrayList.add(new com.bizo.asperatus.model.Dimension(object2.getName(), object2.getValue()));
        }
        StatisticSet statisticSet = metricDatum.getStatisticValues();
        object2 = Unit.fromValue(metricDatum.getUnit());
        return new Aggregation(metricDatum.getMetricName(), statisticSet.getSampleCount(), statisticSet.getSum(), statisticSet.getMinimum(), statisticSet.getMaximum(), (Unit)((Object)object2), arrayList);
    }

    public static List<Aggregation> toAggregation(Collection<MetricDatum> collection) {
        ArrayList<Aggregation> arrayList = new ArrayList<Aggregation>(collection.size());
        for (MetricDatum metricDatum : collection) {
            arrayList.add(AggregationUtils.toAggregation(metricDatum));
        }
        return arrayList;
    }
}

