/*
 * Decompiled with CFR 0.152.
 */
package com.bizo.asperatus.tracker.impl;

import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.bizo.asperatus.model.CompoundDimension;
import com.bizo.asperatus.model.Unit;
import com.bizo.asperatus.tracker.AbstractMetricTracker;
import com.bizo.asperatus.tracker.MetricTracker;
import com.bizo.asperatus.tracker.impl.Aggregation;
import com.bizo.asperatus.tracker.impl.AggregationUtils;
import com.bizo.asperatus.tracker.impl.MetricKey;
import com.bizo.asperatus.tracker.impl.MetricStatistics;
import com.bizo.asperatus.tracker.impl.RetryingScheduler;
import com.bizo.asperatus.tracker.impl.buffer.InMemoryTracker;
import com.bizo.asperatus.tracker.impl.buffer.MetricBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CWMetricTracker
extends AbstractMetricTracker
implements MetricTracker {
    private static final Logger log = Logger.getLogger(CWMetricTracker.class.getName());
    private final AmazonCloudWatch cloudwatch;
    private final String namespace;
    private final MetricBuffer buffer = new InMemoryTracker();
    private final ScheduledExecutorService executor;

    public CWMetricTracker(AmazonCloudWatch amazonCloudWatch, String string, ScheduledExecutorService scheduledExecutorService, long l, TimeUnit timeUnit) {
        this.cloudwatch = amazonCloudWatch;
        this.namespace = string;
        this.executor = scheduledExecutorService;
        scheduledExecutorService.scheduleAtFixedRate(new PushStatsTask(scheduledExecutorService), l, l, timeUnit);
    }

    @Override
    public void track(String string, Number number, Unit unit, Collection<CompoundDimension> collection) {
        this.buffer.track(string, number, unit, collection);
    }

    @Override
    public void close() {
        if (this.executor.isShutdown()) {
            return;
        }
        try {
            Future<?> future = this.executor.submit(new PushStatsTask(this.executor));
            future.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            log.log(Level.SEVERE, "Exception closing asperatus", executionException);
        }
        catch (TimeoutException timeoutException) {
            log.log(Level.SEVERE, "Exception closing asperatus", timeoutException);
        }
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private static final Aggregation toAggregation(MetricKey metricKey, MetricStatistics metricStatistics) {
        return new Aggregation(metricKey.getMetricName(), metricStatistics.getSamples(), metricStatistics.getSum(), metricStatistics.getMin(), metricStatistics.getMax(), metricStatistics.getUnit(), metricKey.getDimension().getDimensions());
    }

    private final class CloudwatchSubmitTask
    implements Callable<Boolean> {
        private final List<Aggregation> agg;

        public CloudwatchSubmitTask(List<Aggregation> list) {
            this.agg = list;
        }

        @Override
        public Boolean call() throws Exception {
            PutMetricDataRequest putMetricDataRequest = new PutMetricDataRequest();
            putMetricDataRequest.setNamespace(CWMetricTracker.this.namespace);
            putMetricDataRequest.setMetricData(AggregationUtils.toMetricDatum(this.agg));
            CWMetricTracker.this.cloudwatch.putMetricData(putMetricDataRequest);
            return Boolean.TRUE;
        }

        public String toString() {
            return String.format("CloudwatchSubmitTask[ns=%s,agg=%s]", this.agg, CWMetricTracker.this.namespace);
        }
    }

    private final class PushStatsTask
    implements Runnable {
        private static final int MAX_PER_REQUEST = 10;
        private static final int NUM_RETRIES = 5;
        private static final int RETRY_DELAY_SEC = 30;
        private final RetryingScheduler scheduler;

        private PushStatsTask(ScheduledExecutorService scheduledExecutorService) {
            this.scheduler = new RetryingScheduler(scheduledExecutorService);
        }

        @Override
        public void run() {
            Map<MetricKey, MetricStatistics> map = CWMetricTracker.this.buffer.reset();
            if (map.isEmpty()) {
                return;
            }
            ArrayList<Aggregation> arrayList = new ArrayList<Aggregation>();
            for (Map.Entry<MetricKey, MetricStatistics> entry : map.entrySet()) {
                Aggregation aggregation = CWMetricTracker.toAggregation(entry.getKey(), entry.getValue());
                arrayList.add(aggregation);
                if (arrayList.size() < 10) continue;
                this.submit(arrayList);
                arrayList.clear();
            }
            this.submit(arrayList);
        }

        private void submit(List<Aggregation> list) {
            if (list.size() > 0) {
                CloudwatchSubmitTask cloudwatchSubmitTask = new CloudwatchSubmitTask(new ArrayList<Aggregation>(list));
                this.scheduler.schedule(cloudwatchSubmitTask, 5, 30);
            }
        }
    }
}

