/*
 * Decompiled with CFR 0.152.
 */
package com.bizo.asperatus.tracker.impl;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.bizo.asperatus.tracker.Env;
import com.bizo.asperatus.tracker.MetricTracker;
import com.bizo.asperatus.tracker.impl.CWMetricTracker;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class CWMetricTrackerBuilder {
    private String application;
    private String stage = Env.envOrProperty("STAGE", "dev");
    private String region = Env.envOrProperty("EC2_REGION", "us-east-1");
    private ScheduledExecutorService executor;
    private long flushDelay = 60L;
    private TimeUnit flushUnit = TimeUnit.SECONDS;
    private AWSCredentialsProvider credentialsProvider = new DefaultAWSCredentialsProviderChain();

    public MetricTracker toMetricTracker() {
        if (this.application == null) {
            throw new IllegalStateException("Must set application before constructing.");
        }
        String string = String.format("%s-%s", this.application, this.stage);
        String string2 = String.format("monitoring.%s.amazonaws.com", this.region);
        if (this.executor == null) {
            this.executor = Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("asperatus-metrics-%d").build());
        }
        AmazonCloudWatchClient amazonCloudWatchClient = new AmazonCloudWatchClient(this.credentialsProvider);
        amazonCloudWatchClient.setEndpoint(string2);
        final CWMetricTracker cWMetricTracker = new CWMetricTracker((AmazonCloudWatch)amazonCloudWatchClient, string, this.executor, this.flushDelay, this.flushUnit);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                cWMetricTracker.close();
            }
        });
        return cWMetricTracker;
    }

    public AWSCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public CWMetricTrackerBuilder withCredentialsProvider(AWSCredentialsProvider aWSCredentialsProvider) {
        this.credentialsProvider = aWSCredentialsProvider;
        return this;
    }

    public String getApplication() {
        return this.application;
    }

    public CWMetricTrackerBuilder withApplication(String string) {
        this.application = string;
        return this;
    }

    public String getStage() {
        return this.stage;
    }

    public CWMetricTrackerBuilder withStage(String string) {
        this.stage = string;
        return this;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public CWMetricTrackerBuilder withExecutor(ScheduledExecutorService scheduledExecutorService) {
        this.executor = scheduledExecutorService;
        return this;
    }

    public long getFlushDelay() {
        return this.flushDelay;
    }

    public TimeUnit getFlushUnit() {
        return this.flushUnit;
    }

    public CWMetricTrackerBuilder withFlushDelay(long l, TimeUnit timeUnit) {
        this.flushDelay = l;
        this.flushUnit = timeUnit;
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    public CWMetricTrackerBuilder withRegion(String string) {
        this.region = string;
        return this;
    }
}

