/*
 * Decompiled with CFR 0.152.
 */
package com.bizo.asperatus.tracker.impl;

import com.bizo.asperatus.model.CompoundDimension;
import com.bizo.asperatus.model.Dimension;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public final class MetricKey {
    private final String metricName;
    private final CompoundDimension dimension;

    public MetricKey(String string, CompoundDimension compoundDimension) {
        this.metricName = (String)Preconditions.checkNotNull((Object)string);
        this.dimension = (CompoundDimension)Preconditions.checkNotNull((Object)compoundDimension);
    }

    public MetricKey(String string, Dimension dimension) {
        this(string, new CompoundDimension(dimension));
    }

    public String getMetricName() {
        return this.metricName;
    }

    public CompoundDimension getDimension() {
        return this.dimension;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.dimension.hashCode();
        n = 31 * n + this.metricName.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MetricKey metricKey = (MetricKey)object;
        return this.metricName.equals(metricKey.metricName) && this.dimension.equals(metricKey.dimension);
    }
}

