/*
 * Decompiled with CFR 0.152.
 */
package com.bizo.asperatus.tracker.impl;

import com.bizo.asperatus.model.Unit;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class MetricStatistics {
    private final Unit unit;
    private long samples = 0L;
    private float sum = 0.0f;
    private float min = Float.MAX_VALUE;
    private float max = Float.MIN_VALUE;

    public MetricStatistics(Unit unit) {
        this.unit = unit;
    }

    public void add(Number number) {
        float f = number.floatValue();
        this.min = Math.min(this.min, f);
        this.max = Math.max(this.max, f);
        this.sum += f;
        ++this.samples;
    }

    public long getSamples() {
        return this.samples;
    }

    public float getSum() {
        return this.sum;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public String toString() {
        return String.format("MStats[unit:%s,samples=%d,sum=%2.2f,min=%2.2f,max=%2.2f]", new Object[]{this.unit, this.samples, Float.valueOf(this.sum), Float.valueOf(this.min), Float.valueOf(this.max)});
    }

    public boolean equals(Object object) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)object);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

