/*
 * Decompiled with CFR 0.152.
 */
package com.bizo.asperatus.tracker.impl;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RetryingScheduler {
    private static final Logger logger = Logger.getLogger(RetryingScheduler.class.getName());
    private final ScheduledExecutorService executor;

    public RetryingScheduler(ScheduledExecutorService scheduledExecutorService) {
        this.executor = scheduledExecutorService;
    }

    public void schedule(Callable<?> callable, int n, int n2) {
        this.schedule(callable, 0, n, n2);
    }

    public void schedule(Callable<?> callable, int n, int n2, int n3) {
        this.executor.schedule(new RetryWrapper(callable, n2, n3, null), (long)n, TimeUnit.SECONDS);
    }

    private final class RetryWrapper
    implements Runnable {
        private final Callable<?> call;
        private final int retry;
        private final int retryDelay;
        private final Exception lastThrown;

        private RetryWrapper(Callable<?> callable, int n, int n2, Exception exception) {
            this.call = callable;
            this.retry = n;
            this.retryDelay = n2;
            this.lastThrown = exception;
        }

        @Override
        public void run() {
            if (this.retry <= 0) {
                logger.log(Level.WARNING, String.format("Failed to run task: %s", this.call), this.lastThrown);
                return;
            }
            try {
                this.call.call();
            }
            catch (Exception exception) {
                logger.log(Level.FINEST, String.format("Failed to run task: %s", this.call), exception);
                RetryingScheduler.this.executor.schedule(new RetryWrapper(this.call, this.retry - 1, this.retryDelay, exception), (long)this.retryDelay, TimeUnit.SECONDS);
            }
        }
    }
}

