/*
 * Decompiled with CFR 0.152.
 */
package com.bizo.asperatus.tracker.impl.buffer;

import com.bizo.asperatus.model.CompoundDimension;
import com.bizo.asperatus.model.Unit;
import com.bizo.asperatus.tracker.AbstractMetricTracker;
import com.bizo.asperatus.tracker.impl.MetricKey;
import com.bizo.asperatus.tracker.impl.MetricStatistics;
import com.bizo.asperatus.tracker.impl.buffer.MetricBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public final class InMemoryTracker
extends AbstractMetricTracker
implements MetricBuffer {
    private final AtomicReference<Map<MetricKey, MetricStatistics>> stats = new AtomicReference(new HashMap());

    @Override
    public synchronized void track(String string, Number number, Unit unit, Collection<CompoundDimension> collection) {
        for (CompoundDimension compoundDimension : collection) {
            this.getOrCreateStats(new MetricKey(string, compoundDimension), unit).add(number);
        }
    }

    private MetricStatistics getOrCreateStats(MetricKey metricKey, Unit unit) {
        MetricStatistics metricStatistics = this.stats.get().get(metricKey);
        if (metricStatistics == null) {
            metricStatistics = new MetricStatistics(unit);
            this.stats.get().put(metricKey, metricStatistics);
        }
        return metricStatistics;
    }

    @Override
    public synchronized Map<MetricKey, MetricStatistics> reset() {
        return this.stats.getAndSet(new HashMap());
    }
}

