/*
 * Decompiled with CFR 0.152.
 */
package com.bjoernkw.schematic;

import com.bjoernkw.schematic.Column;
import com.bjoernkw.schematic.Table;
import io.github.wimdeblauwe.hsbt.mvc.HxRequest;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/schematic/tables"})
public class TablesController {
    private static final String TABLE_VIEW_MODEL_NAME = "tables";
    private static final String ER_DIAGRAM_VIEW_MODEL_NAME = "erDiagram";
    private static final String TABLE_VIEW_FRAGMENT_NAME = "fragments/tables";
    private static final String ER_DIAGRAM_RESULT_SET_COLUMN_NAME = "mermaid_diagram_line";
    private final JdbcTemplate jdbcTemplate;
    private final DataSource dataSource;

    public TablesController(JdbcTemplate jdbcTemplate, DataSource dataSource) {
        this.jdbcTemplate = jdbcTemplate;
        this.dataSource = dataSource;
    }

    @GetMapping
    public String showDatabaseStructure(Model model) {
        model.addAttribute(TABLE_VIEW_MODEL_NAME, this.getTables());
        model.addAttribute(ER_DIAGRAM_VIEW_MODEL_NAME, (Object)this.generateERDiagram());
        return "index";
    }

    @GetMapping(params={"sqlQuery"})
    @HxRequest
    public String queryDatabase(@RequestParam String sqlQuery, Model model) {
        ArrayList<Table> tables = new ArrayList<Table>();
        Table queryResultTable = new Table();
        tables.add(queryResultTable);
        queryResultTable.setTableName("queryResult");
        queryResultTable.setQueryResult(true);
        List queryResultRows = this.jdbcTemplate.queryForList(sqlQuery);
        queryResultTable.setRows(queryResultRows);
        ArrayList<Column> columns = new ArrayList<Column>();
        queryResultRows.stream().findFirst().ifPresent(row -> row.forEach((columnKey, columnValue) -> {
            Column column = new Column();
            column.setColumnName((String)columnKey);
            columns.add(column);
        }));
        queryResultTable.setColumns(columns);
        tables.addAll(this.getTables());
        model.addAttribute(TABLE_VIEW_MODEL_NAME, tables);
        return TABLE_VIEW_FRAGMENT_NAME;
    }

    @DeleteMapping(value={"/{tableName}"})
    @HxRequest
    public String dropTable(@PathVariable String tableName, Model model) {
        List<Table> availableTables = this.getTables();
        if (availableTables.stream().anyMatch(table -> table.getTableName().equals(tableName))) {
            this.jdbcTemplate.execute("DROP TABLE " + tableName);
        }
        model.addAttribute(TABLE_VIEW_MODEL_NAME, this.getTables());
        return TABLE_VIEW_FRAGMENT_NAME;
    }

    @DeleteMapping(value={"/{tableName}/truncate"})
    @HxRequest
    public String truncateTable(@PathVariable String tableName, Model model) {
        List<Table> availableTables = this.getTables();
        if (availableTables.stream().anyMatch(table -> table.getTableName().equals(tableName))) {
            this.jdbcTemplate.execute("TRUNCATE TABLE " + tableName);
        }
        model.addAttribute(TABLE_VIEW_MODEL_NAME, this.getTables());
        return TABLE_VIEW_FRAGMENT_NAME;
    }

    @ExceptionHandler(value={SQLException.class})
    @HxRequest
    public String error(SQLException sqlException, Model model) {
        model.addAttribute("error", (Object)sqlException.getMessage());
        model.addAttribute(TABLE_VIEW_MODEL_NAME, this.getTables());
        return TABLE_VIEW_FRAGMENT_NAME;
    }

    private List<Table> getTables() {
        List tables = this.jdbcTemplate.query("SELECT table_name FROM INFORMATION_SCHEMA.Tables WHERE lower(table_schema) = 'public' AND table_type = 'BASE TABLE'", (RowMapper)new BeanPropertyRowMapper(Table.class));
        tables.forEach(table -> {
            table.setColumns(this.jdbcTemplate.query("SELECT column_name, data_type FROM INFORMATION_SCHEMA.Columns WHERE table_name = ?", (RowMapper)new BeanPropertyRowMapper(Column.class), new Object[]{table.getTableName()}));
            table.setRows(this.jdbcTemplate.queryForList("SELECT * FROM " + table.getTableName() + " FETCH FIRST 10 ROWS ONLY"));
        });
        return tables;
    }

    private String generateERDiagram() {
        String driverClassName = "";
        try {
            driverClassName = DriverManager.getDriver(this.dataSource.getConnection().getMetaData().getURL()).getClass().toString();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (driverClassName.equals("class org.postgresql.Driver")) {
            String sqlQuery = "    SELECT E'erDiagram\\n' AS mermaid_diagram_line\n    UNION ALL\n    SELECT\n        format(E'\\t%s {\\n%s\\n\\t}\\n',\n            c.relname,\n            string_agg(format(E'\\t\\t%s %s',\n                t.typname,\n                a.attname\n            ), E'\\n'))\n    FROM\n        pg_class c\n        JOIN pg_namespace n ON n.oid = c.relnamespace\n        LEFT JOIN pg_attribute a ON c.oid = a.attrelid AND a.attnum > 0 AND NOT a.attisdropped\n        LEFT JOIN pg_type t ON a.atttypid = t.oid\n    WHERE\n        c.relkind IN ('r', 'p')\n        AND NOT c.relispartition\n        AND n.nspname !~ '^pg_' AND n.nspname <> 'information_schema'\n    GROUP BY c.relname\n    UNION ALL\n    SELECT\n        format(E'\\t%s }|..|| %s : %s\\n', c1.relname, c2.relname, c.conname)\n    FROM\n        pg_constraint c\n        JOIN pg_class c1 ON c.conrelid = c1.oid AND c.contype = 'f'\n        JOIN pg_class c2 ON c.confrelid = c2.oid\n    WHERE\n        NOT c1.relispartition AND NOT c2.relispartition;\n";
            StringBuilder output = new StringBuilder();
            List queryResultRows = this.jdbcTemplate.queryForList(sqlQuery);
            for (Map queryResultRow : queryResultRows) {
                output.append(queryResultRow.get(ER_DIAGRAM_RESULT_SET_COLUMN_NAME));
            }
            return output.toString();
        }
        return ER_DIAGRAM_VIEW_MODEL_NAME;
    }
}

