/**
 * blackduck-common-api
 *
 * Copyright (c) 2019 Synopsys, Inc.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.synopsys.integration.blackduck.api.generated.component;

import com.synopsys.integration.blackduck.api.core.BlackDuckComponent;
import com.synopsys.integration.blackduck.api.generated.component.Cvss3TemporalMetricsView;
import com.synopsys.integration.blackduck.api.generated.enumeration.VulnerabilityCvss3AttackComplexityType;
import com.synopsys.integration.blackduck.api.generated.enumeration.VulnerabilityCvss3AttackVectorType;
import com.synopsys.integration.blackduck.api.generated.enumeration.VulnerabilityCvss3IntegrityImpactType;
import com.synopsys.integration.blackduck.api.generated.enumeration.VulnerabilityCvss3ScopeType;
import com.synopsys.integration.blackduck.api.generated.enumeration.VulnerabilityCvss3UserInteractionType;

//this file should not be edited - if changes are necessary, the generator should be updated, then this file should be re-created
public class VulnerabilityCvss3View extends BlackDuckComponent {
    private VulnerabilityCvss3AttackComplexityType attackComplexity;
    private VulnerabilityCvss3AttackVectorType attackVector;
    private VulnerabilityCvss3IntegrityImpactType availabilityImpact;
    private java.math.BigDecimal baseScore;
    private VulnerabilityCvss3IntegrityImpactType confidentialityImpact;
    private java.math.BigDecimal exploitabilitySubscore;
    private java.math.BigDecimal impactSubscore;
    private VulnerabilityCvss3IntegrityImpactType integrityImpact;
    private VulnerabilityCvss3IntegrityImpactType privilegesRequired;
    private VulnerabilityCvss3ScopeType scope;
    private Cvss3TemporalMetricsView temporalMetrics;
    private VulnerabilityCvss3UserInteractionType userInteraction;
    private String vector;

    public VulnerabilityCvss3AttackComplexityType getAttackComplexity() {
        return attackComplexity;
    }

    public void setAttackComplexity(VulnerabilityCvss3AttackComplexityType attackComplexity) {
        this.attackComplexity = attackComplexity;
    }

    public VulnerabilityCvss3AttackVectorType getAttackVector() {
        return attackVector;
    }

    public void setAttackVector(VulnerabilityCvss3AttackVectorType attackVector) {
        this.attackVector = attackVector;
    }

    public VulnerabilityCvss3IntegrityImpactType getAvailabilityImpact() {
        return availabilityImpact;
    }

    public void setAvailabilityImpact(VulnerabilityCvss3IntegrityImpactType availabilityImpact) {
        this.availabilityImpact = availabilityImpact;
    }

    public java.math.BigDecimal getBaseScore() {
        return baseScore;
    }

    public void setBaseScore(java.math.BigDecimal baseScore) {
        this.baseScore = baseScore;
    }

    public VulnerabilityCvss3IntegrityImpactType getConfidentialityImpact() {
        return confidentialityImpact;
    }

    public void setConfidentialityImpact(VulnerabilityCvss3IntegrityImpactType confidentialityImpact) {
        this.confidentialityImpact = confidentialityImpact;
    }

    public java.math.BigDecimal getExploitabilitySubscore() {
        return exploitabilitySubscore;
    }

    public void setExploitabilitySubscore(java.math.BigDecimal exploitabilitySubscore) {
        this.exploitabilitySubscore = exploitabilitySubscore;
    }

    public java.math.BigDecimal getImpactSubscore() {
        return impactSubscore;
    }

    public void setImpactSubscore(java.math.BigDecimal impactSubscore) {
        this.impactSubscore = impactSubscore;
    }

    public VulnerabilityCvss3IntegrityImpactType getIntegrityImpact() {
        return integrityImpact;
    }

    public void setIntegrityImpact(VulnerabilityCvss3IntegrityImpactType integrityImpact) {
        this.integrityImpact = integrityImpact;
    }

    public VulnerabilityCvss3IntegrityImpactType getPrivilegesRequired() {
        return privilegesRequired;
    }

    public void setPrivilegesRequired(VulnerabilityCvss3IntegrityImpactType privilegesRequired) {
        this.privilegesRequired = privilegesRequired;
    }

    public VulnerabilityCvss3ScopeType getScope() {
        return scope;
    }

    public void setScope(VulnerabilityCvss3ScopeType scope) {
        this.scope = scope;
    }

    public Cvss3TemporalMetricsView getTemporalMetrics() {
        return temporalMetrics;
    }

    public void setTemporalMetrics(Cvss3TemporalMetricsView temporalMetrics) {
        this.temporalMetrics = temporalMetrics;
    }

    public VulnerabilityCvss3UserInteractionType getUserInteraction() {
        return userInteraction;
    }

    public void setUserInteraction(VulnerabilityCvss3UserInteractionType userInteraction) {
        this.userInteraction = userInteraction;
    }

    public String getVector() {
        return vector;
    }

    public void setVector(String vector) {
        this.vector = vector;
    }

}
