/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.api.core;

import com.synopsys.integration.blackduck.api.core.BlackDuckResponse;
import com.synopsys.integration.blackduck.api.generated.component.ResourceLink;
import com.synopsys.integration.blackduck.api.generated.component.ResourceMetadata;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class BlackDuckView
extends BlackDuckResponse {
    private ResourceMetadata _meta;

    public ResourceMetadata getMeta() {
        return this._meta;
    }

    public void setMeta(ResourceMetadata meta) {
        this._meta = meta;
    }

    public boolean hasLink(String linkKey) {
        if (null == this._meta || null == this._meta.getLinks()) {
            return false;
        }
        return this._meta.getLinks().stream().map(ResourceLink::getRel).anyMatch(linkKey::equals);
    }

    public Optional<String> getFirstLink(String linkKey) {
        if (null == this._meta || null == this._meta.getLinks()) {
            return Optional.empty();
        }
        return this._meta.getLinks().stream().filter(resourceLink -> resourceLink.getRel().equals(linkKey)).findFirst().map(ResourceLink::getHref);
    }

    public List<String> getLinks(String linkKey) {
        return this.getResourceLinks().stream().map(ResourceLink::getHref).collect(Collectors.toList());
    }

    public Optional<ResourceMetadata> getResourceMetadata() {
        if (null == this._meta) {
            return Optional.empty();
        }
        return Optional.of(this._meta);
    }

    public List<ResourceLink> getResourceLinks() {
        if (null == this._meta || null == this._meta.getLinks()) {
            return Collections.emptyList();
        }
        return this._meta.getLinks();
    }

    public List<String> getAvailableLinks() {
        return this.getResourceLinks().stream().map(ResourceLink::getRel).collect(Collectors.toList());
    }

    public List<String> getAllowedMethods() {
        if (null == this._meta || null == this._meta.getAllow()) {
            return Collections.emptyList();
        }
        return this._meta.getAllow();
    }

    public Optional<String> getHref() {
        if (null == this._meta || null == this._meta.getHref()) {
            return Optional.empty();
        }
        return Optional.of(this._meta.getHref());
    }
}

