/*
 * Decompiled with CFR 0.152.
 */
package com.blacklocus.metrics;

import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsync;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.cloudwatch.model.StatisticSet;
import com.blacklocus.metrics.DemuxedKey;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Sampling;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudWatchReporter
extends ScheduledReporter {
    private static final Logger LOG = LoggerFactory.getLogger(CloudWatchReporter.class);
    public static final String NAME_TOKEN_DELIMITER_RGX = "\\s";
    public static final String NAME_TOKEN_DELIMITER = " ";
    public static final String NAME_DIMENSION_SEPARATOR = "=";
    public static final String NAME_PERMUTE_MARKER = "*";
    public static final String METRIC_TYPE_DIMENSION = "type";
    public static final String VALID_NAME_TOKEN_RGX = "[^\\s=\\*]+\\*?";
    public static final String VALID_DIMENSION_PART_RGX = "[^\\s=\\*]+";
    private final String metricNamespace;
    private final AmazonCloudWatchAsync cloudWatch;
    private final Map<Counting, Long> lastPolledCounts = new HashMap<Counting, Long>();
    static final MetricFilter ALL = new MetricFilter(){

        public boolean matches(String name, Metric metric) {
            return true;
        }
    };

    public CloudWatchReporter(MetricRegistry registry, AmazonCloudWatchAsync cloudWatch) {
        this(registry, null, cloudWatch);
    }

    public CloudWatchReporter(MetricRegistry registry, String metricNamespace, AmazonCloudWatchAsync cloudWatch) {
        this(registry, metricNamespace, ALL, cloudWatch);
    }

    public CloudWatchReporter(MetricRegistry registry, String metricNamespace, MetricFilter metricFilter, AmazonCloudWatchAsync cloudWatch) {
        super(registry, "CloudWatchReporter:" + metricNamespace, metricFilter, TimeUnit.MINUTES, TimeUnit.MINUTES);
        this.metricNamespace = metricNamespace;
        this.cloudWatch = cloudWatch;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        try {
            ArrayList<MetricDatum> data = new ArrayList<MetricDatum>(gauges.size() + counters.size() + meters.size() + 2 * histograms.size() + 2 * timers.size());
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(entry, "gauge", data);
            }
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.reportCounter(entry, "counterSum", data);
            }
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                this.reportCounter(entry, "meterSum", data);
            }
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                this.reportCounter(entry, "histogramCount", data);
                this.reportSampling(entry, "histogramSet", 1.0, data);
            }
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.reportCounter(entry, "timerCount", data);
                this.reportSampling(entry, "timerSet", 1.0E-6, data);
            }
            Collection nonEmptyData = Collections2.filter(data, (Predicate)new Predicate<MetricDatum>(){

                public boolean apply(MetricDatum input) {
                    if (input == null) {
                        return false;
                    }
                    if (input.getStatisticValues() != null) {
                        return input.getStatisticValues().getSampleCount() > 0.0;
                    }
                    return true;
                }
            });
            Iterable iterable = Iterables.partition((Iterable)nonEmptyData, (int)20);
            ArrayList cloudWatchFutures = Lists.newArrayListWithExpectedSize((int)data.size());
            for (List dataSubset : iterable) {
                cloudWatchFutures.add(this.cloudWatch.putMetricDataAsync(new PutMetricDataRequest().withNamespace(this.metricNamespace).withMetricData((Collection)dataSubset)));
            }
            for (Future cloudWatchFuture : cloudWatchFutures) {
                try {
                    cloudWatchFuture.get();
                }
                catch (Exception e) {
                    LOG.error("Exception reporting metrics to CloudWatch. The data sent in this CloudWatch API request may have been discarded.", (Throwable)e);
                }
            }
            LOG.debug("Sent {} metric data to CloudWatch. namespace: {}", (Object)data.size(), (Object)this.metricNamespace);
        }
        catch (RuntimeException e) {
            LOG.error("Error marshalling CloudWatch metrics.", (Throwable)e);
        }
    }

    void reportGauge(Map.Entry<String, Gauge> gaugeEntry, String type, List<MetricDatum> data) {
        Gauge gauge = gaugeEntry.getValue();
        Object valueObj = gauge.getValue();
        if (valueObj == null) {
            return;
        }
        String valueStr = valueObj.toString();
        if (NumberUtils.isNumber((String)valueStr)) {
            final Number value = NumberUtils.createNumber((String)valueStr);
            DemuxedKey key = new DemuxedKey(gaugeEntry.getKey());
            Iterables.addAll(data, key.newDatums(type, new Function<MetricDatum, MetricDatum>(){

                public MetricDatum apply(MetricDatum datum) {
                    return datum.withValue(Double.valueOf(value.doubleValue()));
                }
            }));
        }
    }

    void reportCounter(Map.Entry<String, ? extends Counting> entry, String type, List<MetricDatum> data) {
        Counting metric = entry.getValue();
        final long diff = this.diffLast(metric);
        if (diff == 0L) {
            return;
        }
        DemuxedKey key = new DemuxedKey(entry.getKey());
        Iterables.addAll(data, key.newDatums(type, new Function<MetricDatum, MetricDatum>(){

            public MetricDatum apply(MetricDatum datum) {
                return datum.withValue(Double.valueOf(diff)).withUnit(StandardUnit.Count);
            }
        }));
    }

    void reportSampling(Map.Entry<String, ? extends Sampling> entry, String type, double rescale, List<MetricDatum> data) {
        Sampling metric = entry.getValue();
        Snapshot snapshot = metric.getSnapshot();
        double scaledSum = (double)this.sum(snapshot.getValues()) * rescale;
        final StatisticSet statisticSet = new StatisticSet().withSum(Double.valueOf(scaledSum)).withSampleCount(Double.valueOf(snapshot.size())).withMinimum(Double.valueOf((double)snapshot.getMin() * rescale)).withMaximum(Double.valueOf((double)snapshot.getMax() * rescale));
        DemuxedKey key = new DemuxedKey(entry.getKey());
        Iterables.addAll(data, key.newDatums(type, new Function<MetricDatum, MetricDatum>(){

            public MetricDatum apply(MetricDatum datum) {
                return datum.withStatisticValues(statisticSet);
            }
        }));
    }

    private long diffLast(Counting metric) {
        long count = metric.getCount();
        Long lastCount = this.lastPolledCounts.get(metric);
        this.lastPolledCounts.put(metric, count);
        if (lastCount == null) {
            lastCount = 0L;
        }
        return count - lastCount;
    }

    private long sum(long[] values) {
        long sum = 0L;
        for (long value : values) {
            sum += value;
        }
        return sum;
    }
}

