/*
 * Decompiled with CFR 0.152.
 */
package com.blacklocus.metrics;

import com.amazonaws.services.cloudwatch.model.Dimension;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MetricNameBuilder {
    private final List<String> names = new ArrayList<String>();
    private final List<String> dimensions = new ArrayList<String>();

    public MetricNameBuilder() {
    }

    public MetricNameBuilder(String nameSpec) {
        this.add(nameSpec);
    }

    public MetricNameBuilder addNameToken(String nameToken) throws MetricsNameSyntaxException {
        if (!(nameToken = nameToken.trim()).matches("[^\\s=\\*]+\\*?")) {
            throw new MetricsNameSyntaxException("Name must match [^\\s=\\*]+\\*?");
        }
        this.names.add(nameToken);
        return this;
    }

    public MetricNameBuilder addNameToken(String nameToken, boolean permute) throws MetricsNameSyntaxException {
        if (permute && !nameToken.endsWith("*")) {
            nameToken = nameToken + "*";
        } else if (!permute && nameToken.endsWith("*")) {
            nameToken = nameToken.substring(0, nameToken.length() - 1);
        }
        return this.addNameToken(nameToken);
    }

    public MetricNameBuilder add(String nameSpec) throws MetricsNameSyntaxException {
        for (String token : nameSpec.split("\\s")) {
            if (token.contains("=")) {
                String[] dimensionTuple = token.split("=", 2);
                this.addDimension(dimensionTuple[0], dimensionTuple[1]);
                continue;
            }
            this.addNameToken(token);
        }
        return this;
    }

    public MetricNameBuilder addDimension(Dimension dimension) throws MetricsNameSyntaxException {
        return this.addDimension(dimension, false);
    }

    public MetricNameBuilder addDimension(Dimension dimension, boolean permute) throws MetricsNameSyntaxException {
        return this.addDimension(dimension.getName(), dimension.getValue(), false);
    }

    public MetricNameBuilder addDimension(String name, String value) throws MetricsNameSyntaxException {
        return this.addDimension(name, value, false);
    }

    public MetricNameBuilder addDimension(String name, String value, boolean permute) throws MetricsNameSyntaxException {
        if (!name.matches("[^\\s=\\*]+")) {
            throw new MetricsNameSyntaxException("Dimension name must match [^\\s=\\*]+");
        }
        if (!value.matches("[^\\s=\\*]+")) {
            throw new MetricsNameSyntaxException("Dimension name must match [^\\s=\\*]+");
        }
        this.dimensions.add(name + "=" + value + (permute ? "*" : ""));
        return this;
    }

    public String build() {
        return this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator iterator = Iterables.concat(this.names, this.dimensions).iterator();
        while (iterator.hasNext()) {
            sb.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static class MetricsNameSyntaxException
    extends RuntimeException {
        public MetricsNameSyntaxException(String message) {
            super(message);
        }
    }
}

