/*
 * Decompiled with CFR 0.152.
 */
package com.blacklocus.metrics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;

class PermutableChain<T>
implements Iterable<Iterable<T>> {
    final T token;
    final boolean permutable;
    final PermutableChain<T> nextSegment;

    PermutableChain(T token, boolean permutable, PermutableChain<T> nextSegment) {
        this.token = token;
        this.permutable = permutable;
        this.nextSegment = nextSegment;
    }

    @Override
    public Iterator<Iterable<T>> iterator() {
        return new Iterator<Iterable<T>>(){
            int permutation;
            Iterator<Iterable<T>> nextSegmentIt;
            {
                this.permutation = PermutableChain.this.permutable ? 2 : 1;
                this.nextSegmentIt = PermutableChain.this.nextSegment == null ? null : PermutableChain.this.nextSegment.iterator();
            }

            @Override
            public boolean hasNext() {
                boolean isTail;
                boolean bl = isTail = this.nextSegmentIt == null;
                if (isTail) {
                    return this.permutation > 0;
                }
                return this.permutation > 0 && this.nextSegmentIt != null && this.nextSegmentIt.hasNext();
            }

            @Override
            public Iterable<T> next() {
                boolean isTail;
                assert (this.permutation > 0 && this.permutation <= 2);
                boolean bl = isTail = this.nextSegmentIt == null;
                if (isTail) {
                    if (this.permutation == 2) {
                        this.permutation = 1;
                        return Collections.emptyList();
                    }
                    assert (this.permutation == 1);
                    this.permutation = 0;
                    return ImmutableList.of(PermutableChain.this.token);
                }
                if (this.permutation == 2) {
                    Iterable next = this.nextSegmentIt.next();
                    if (!this.nextSegmentIt.hasNext()) {
                        this.permutation = 1;
                        this.nextSegmentIt = PermutableChain.this.nextSegment.iterator();
                    }
                    return next;
                }
                assert (this.permutation == 1);
                Iterable next = Iterables.concat((Iterable)ImmutableList.of(PermutableChain.this.token), this.nextSegmentIt.next());
                if (!this.nextSegmentIt.hasNext()) {
                    this.permutation = 0;
                    this.nextSegmentIt = null;
                }
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Nope.");
            }
        };
    }
}

