/*
 * Decompiled with CFR 0.152.
 */
package com.blacklocus.metrics;

import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsync;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.cloudwatch.model.StatisticSet;
import com.blacklocus.metrics.DemuxedKey;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Sampling;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudWatchReporter
extends ScheduledReporter {
    private static final Logger LOG = LoggerFactory.getLogger(CloudWatchReporter.class);
    @Deprecated
    public static final String NAME_TOKEN_DELIMITER_RGX = "\\s";
    @Deprecated
    public static final String NAME_TOKEN_DELIMITER = " ";
    @Deprecated
    public static final String NAME_DIMENSION_SEPARATOR = "=";
    @Deprecated
    public static final String NAME_PERMUTE_MARKER = "*";
    @Deprecated
    public static final String VALID_NAME_TOKEN_RGX = "[^\\s=\\*]+\\*?";
    @Deprecated
    public static final String VALID_DIMENSION_PART_RGX = "[^\\s=\\*]+";
    @Deprecated
    public static final String METRIC_TYPE_DIMENSION = "type";
    @Deprecated
    public static final String DEF_DIM_VAL_COUNTER_COUNT = "counterSum";
    @Deprecated
    public static final String DEF_DIM_VAL_METER_COUNT = "meterSum";
    @Deprecated
    public static final String DEF_DIM_VAL_HISTO_SAMPLES = "histogramCount";
    @Deprecated
    public static final String DEF_DIM_VAL_HISTO_STATS = "histogramSet";
    @Deprecated
    public static final String DEF_DIM_VAL_TIMER_SAMPLES = "timerCount";
    @Deprecated
    public static final String DEF_DIM_VAL_TIMER_STATS = "timerSet";
    @Deprecated
    static final MetricFilter ALL = MetricFilter.ALL;
    private final String metricNamespace;
    private final AmazonCloudWatchAsync cloudWatch;
    private final Map<Counting, Long> lastPolledCounts = new HashMap<Counting, Long>();
    private String dimensions;
    private boolean timestampLocal = false;
    private Predicate<MetricDatum> reporterFilter = Predicates.alwaysTrue();
    private String typeDimName = "type";
    private String typeDimValGauge = "gauge";
    private String typeDimValCounterCount = "counterSum";
    private String typeDimValMeterCount = "meterSum";
    private String typeDimValHistoSamples = "histogramCount";
    private String typeDimValHistoStats = "histogramSet";
    private String typeDimValTimerSamples = "timerCount";
    private String typeDimValTimerStats = "timerSet";

    public CloudWatchReporter(MetricRegistry registry, AmazonCloudWatchAsync cloudWatch) {
        this(registry, null, cloudWatch);
    }

    public CloudWatchReporter(MetricRegistry registry, String metricNamespace, AmazonCloudWatchAsync cloudWatch) {
        this(registry, metricNamespace, MetricFilter.ALL, cloudWatch);
    }

    public CloudWatchReporter(MetricRegistry registry, String metricNamespace, MetricFilter metricFilter, AmazonCloudWatchAsync cloudWatch) {
        super(registry, "CloudWatchReporter:" + metricNamespace, metricFilter, TimeUnit.MINUTES, TimeUnit.MINUTES);
        this.metricNamespace = metricNamespace;
        this.cloudWatch = cloudWatch;
    }

    public CloudWatchReporter withDimensions(String dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public CloudWatchReporter withTimestampLocal(boolean timestampLocal) {
        this.timestampLocal = timestampLocal;
        return this;
    }

    public CloudWatchReporter withTypeDimName(String typeDimName) {
        this.typeDimName = typeDimName;
        return this;
    }

    public CloudWatchReporter withTypeDimValGauge(String typeDimValGauge) {
        this.typeDimValGauge = typeDimValGauge;
        return this;
    }

    public CloudWatchReporter withTypeDimValCounterCount(String typeDimValCounterCount) {
        this.typeDimValCounterCount = typeDimValCounterCount;
        return this;
    }

    public CloudWatchReporter withTypeDimValMeterCount(String typeDimValMeterCount) {
        this.typeDimValMeterCount = typeDimValMeterCount;
        return this;
    }

    public CloudWatchReporter withTypeDimValHistoSamples(String typeDimValHistoSamples) {
        this.typeDimValHistoSamples = typeDimValHistoSamples;
        return this;
    }

    public CloudWatchReporter withTypeDimValHistoStats(String typeDimValHistoStats) {
        this.typeDimValHistoStats = typeDimValHistoStats;
        return this;
    }

    public CloudWatchReporter withTypeDimValTimerSamples(String typeDimValTimerSamples) {
        this.typeDimValTimerSamples = typeDimValTimerSamples;
        return this;
    }

    public CloudWatchReporter withTypeDimValTimerStats(String typeDimValTimerStats) {
        this.typeDimValTimerStats = typeDimValTimerStats;
        return this;
    }

    public CloudWatchReporter withReporterFilter(Predicate<MetricDatum> reporterFilter) {
        this.reporterFilter = reporterFilter;
        return this;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        try {
            ArrayList<MetricDatum> data = new ArrayList<MetricDatum>(gauges.size() + counters.size() + meters.size() + 2 * histograms.size() + 2 * timers.size());
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(entry, this.typeDimValGauge, data);
            }
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.reportCounter(entry, this.typeDimValCounterCount, data);
            }
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                this.reportCounter(entry, this.typeDimValMeterCount, data);
            }
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                this.reportCounter(entry, this.typeDimValHistoSamples, data);
                this.reportSampling(entry, this.typeDimValHistoStats, 1.0, data);
            }
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.reportCounter(entry, this.typeDimValTimerSamples, data);
                this.reportSampling(entry, this.typeDimValTimerStats, 1.0E-6, data);
            }
            Collection nonEmptyData = Collections2.filter(data, (Predicate)new Predicate<MetricDatum>(){

                public boolean apply(MetricDatum input) {
                    if (input == null) {
                        return false;
                    }
                    if (input.getStatisticValues() != null) {
                        return input.getStatisticValues().getSampleCount() > 0.0;
                    }
                    return true;
                }
            });
            if (this.timestampLocal) {
                Date date = new Date();
                for (MetricDatum datum : nonEmptyData) {
                    datum.withTimestamp(date);
                }
            }
            Collection collection = Collections2.filter((Collection)nonEmptyData, this.reporterFilter);
            Iterable dataPartitions = Iterables.partition((Iterable)collection, (int)20);
            ArrayList cloudWatchFutures = Lists.newArrayListWithExpectedSize((int)data.size());
            for (List dataSubset : dataPartitions) {
                cloudWatchFutures.add(this.cloudWatch.putMetricDataAsync(new PutMetricDataRequest().withNamespace(this.metricNamespace).withMetricData((Collection)dataSubset)));
            }
            for (Future cloudWatchFuture : cloudWatchFutures) {
                try {
                    cloudWatchFuture.get();
                }
                catch (Exception e) {
                    LOG.error("Exception reporting metrics to CloudWatch. The data in this CloudWatch API request may have been discarded, did not make it to CloudWatch.", (Throwable)e);
                }
            }
            LOG.debug("Sent {} metric data to CloudWatch. namespace: {}", (Object)data.size(), (Object)this.metricNamespace);
        }
        catch (RuntimeException e) {
            LOG.error("Error marshalling CloudWatch metrics.", (Throwable)e);
        }
    }

    void reportGauge(Map.Entry<String, Gauge> gaugeEntry, String typeDimValue, List<MetricDatum> data) {
        Gauge gauge = gaugeEntry.getValue();
        Object valueObj = gauge.getValue();
        if (valueObj == null) {
            return;
        }
        String valueStr = valueObj.toString();
        if (NumberUtils.isNumber((String)valueStr)) {
            final Number value = NumberUtils.createNumber((String)valueStr);
            DemuxedKey key = new DemuxedKey(this.appendGlobalDimensions(gaugeEntry.getKey()));
            Iterables.addAll(data, key.newDatums(this.typeDimName, typeDimValue, new Function<MetricDatum, MetricDatum>(){

                public MetricDatum apply(MetricDatum datum) {
                    return datum.withValue(Double.valueOf(value.doubleValue()));
                }
            }));
        }
    }

    void reportCounter(Map.Entry<String, ? extends Counting> entry, String typeDimValue, List<MetricDatum> data) {
        Counting metric = entry.getValue();
        final long diff = this.diffLast(metric);
        if (diff == 0L) {
            return;
        }
        DemuxedKey key = new DemuxedKey(this.appendGlobalDimensions(entry.getKey()));
        Iterables.addAll(data, key.newDatums(this.typeDimName, typeDimValue, new Function<MetricDatum, MetricDatum>(){

            public MetricDatum apply(MetricDatum datum) {
                return datum.withValue(Double.valueOf(diff)).withUnit(StandardUnit.Count);
            }
        }));
    }

    void reportSampling(Map.Entry<String, ? extends Sampling> entry, String typeDimValue, double rescale, List<MetricDatum> data) {
        Sampling metric = entry.getValue();
        Snapshot snapshot = metric.getSnapshot();
        double scaledSum = (double)this.sum(snapshot.getValues()) * rescale;
        final StatisticSet statisticSet = new StatisticSet().withSum(Double.valueOf(scaledSum)).withSampleCount(Double.valueOf(snapshot.size())).withMinimum(Double.valueOf((double)snapshot.getMin() * rescale)).withMaximum(Double.valueOf((double)snapshot.getMax() * rescale));
        DemuxedKey key = new DemuxedKey(this.appendGlobalDimensions(entry.getKey()));
        Iterables.addAll(data, key.newDatums(this.typeDimName, typeDimValue, new Function<MetricDatum, MetricDatum>(){

            public MetricDatum apply(MetricDatum datum) {
                return datum.withStatisticValues(statisticSet);
            }
        }));
    }

    private long diffLast(Counting metric) {
        long count = metric.getCount();
        Long lastCount = this.lastPolledCounts.get(metric);
        this.lastPolledCounts.put(metric, count);
        if (lastCount == null) {
            lastCount = 0L;
        }
        return count - lastCount;
    }

    private long sum(long[] values) {
        long sum = 0L;
        for (long value : values) {
            sum += value;
        }
        return sum;
    }

    private String appendGlobalDimensions(String metric) {
        if (StringUtils.isBlank((CharSequence)StringUtils.trim((String)this.dimensions))) {
            return metric;
        }
        return metric + NAME_TOKEN_DELIMITER + this.dimensions;
    }
}

