/*
 * Decompiled with CFR 0.152.
 */
package com.blacklocus.metrics;

import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsync;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsyncClient;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.blacklocus.metrics.CloudWatchReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;

public class CloudWatchReporterBuilder {
    private MetricRegistry registry;
    private String namespace;
    private AmazonCloudWatchAsync client;
    private MetricFilter filter;
    private String dimensions;
    private Boolean timestampLocal;
    private String typeDimName;
    private String typeDimValGauge;
    private String typeDimValCounterCount;
    private String typeDimValMeterCount;
    private String typeDimValHistoSamples;
    private String typeDimValHistoStats;
    private String typeDimValTimerSamples;
    private String typeDimValTimerStats;
    private Predicate<MetricDatum> reporterFilter;

    public CloudWatchReporterBuilder withRegistry(MetricRegistry registry) {
        this.registry = registry;
        return this;
    }

    public CloudWatchReporterBuilder withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public CloudWatchReporterBuilder withClient(AmazonCloudWatchAsync client) {
        this.client = client;
        return this;
    }

    public CloudWatchReporterBuilder withFilter(MetricFilter filter) {
        this.filter = filter;
        return this;
    }

    public CloudWatchReporterBuilder withDimensions(String dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public CloudWatchReporterBuilder withTimestampLocal(Boolean timestampLocal) {
        this.timestampLocal = timestampLocal;
        return this;
    }

    public CloudWatchReporterBuilder withTypeDimName(String typeDimName) {
        this.typeDimName = typeDimName;
        return this;
    }

    public CloudWatchReporterBuilder withTypeDimValGauge(String typeDimValGauge) {
        this.typeDimValGauge = typeDimValGauge;
        return this;
    }

    public CloudWatchReporterBuilder withTypeDimValCounterCount(String typeDimValCounterCount) {
        this.typeDimValCounterCount = typeDimValCounterCount;
        return this;
    }

    public CloudWatchReporterBuilder withTypeDimValMeterCount(String typeDimValMeterCount) {
        this.typeDimValMeterCount = typeDimValMeterCount;
        return this;
    }

    public CloudWatchReporterBuilder withTypeDimValHistoSamples(String typeDimValHistoSamples) {
        this.typeDimValHistoSamples = typeDimValHistoSamples;
        return this;
    }

    public CloudWatchReporterBuilder withTypeDimValHistoStats(String typeDimValHistoStats) {
        this.typeDimValHistoStats = typeDimValHistoStats;
        return this;
    }

    public CloudWatchReporterBuilder withTypeDimValTimerSamples(String typeDimValTimerSamples) {
        this.typeDimValTimerSamples = typeDimValTimerSamples;
        return this;
    }

    public CloudWatchReporterBuilder withTypeDimValTimerStats(String typeDimValTimerStats) {
        this.typeDimValTimerStats = typeDimValTimerStats;
        return this;
    }

    public CloudWatchReporterBuilder withReporterFilter(Predicate<MetricDatum> reporterFilter) {
        this.reporterFilter = reporterFilter;
        return this;
    }

    public CloudWatchReporterBuilder copy() {
        return new CloudWatchReporterBuilder().withRegistry(this.registry).withNamespace(this.namespace).withClient(this.client).withFilter(this.filter).withDimensions(this.dimensions).withTimestampLocal(this.timestampLocal).withTypeDimName(this.typeDimName).withTypeDimValGauge(this.typeDimValGauge).withTypeDimValCounterCount(this.typeDimValCounterCount).withTypeDimValMeterCount(this.typeDimValMeterCount).withTypeDimValHistoSamples(this.typeDimValHistoSamples).withTypeDimValHistoStats(this.typeDimValHistoStats).withTypeDimValTimerSamples(this.typeDimValTimerSamples).withTypeDimValTimerStats(this.typeDimValTimerStats).withReporterFilter(this.reporterFilter);
    }

    public CloudWatchReporter build() {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.namespace) ? 1 : 0) != 0, (Object)"Metric namespace is required.");
        String resolvedNamespace = this.namespace;
        MetricRegistry resolvedRegistry = null != this.registry ? this.registry : new MetricRegistry();
        MetricFilter resolvedFilter = null != this.filter ? this.filter : MetricFilter.ALL;
        AmazonCloudWatchAsync resolvedCloudWatchClient = null != this.client ? this.client : new AmazonCloudWatchAsyncClient();
        String resolvedDimensions = null != this.dimensions ? this.dimensions : null;
        Boolean resolvedTimestampLocal = null != this.timestampLocal ? this.timestampLocal : false;
        String resolvedTypeDimName = null != this.typeDimName ? this.typeDimName : "metricType";
        String resolvedTypeDimValGauge = null != this.typeDimValGauge ? this.typeDimValGauge : "gauge";
        String resolvedTypeDimValCounterCount = null != this.typeDimValCounterCount ? this.typeDimValCounterCount : "counterCount";
        String resolvedTypeDimValMeterCount = null != this.typeDimValMeterCount ? this.typeDimValMeterCount : "meterCount";
        String resolvedTypeDimValHistoSamples = null != this.typeDimValHistoSamples ? this.typeDimValHistoSamples : "histoSamples";
        String resolvedTypeDimValHistoStats = null != this.typeDimValHistoStats ? this.typeDimValHistoStats : "histoStats";
        String resolvedTypeDimValTimerSamples = null != this.typeDimValTimerSamples ? this.typeDimValTimerSamples : "timerSamples";
        String resolvedTypeDimValTimerStats = null != this.typeDimValTimerStats ? this.typeDimValTimerStats : "timerStats";
        Predicate<MetricDatum> resolvedReporterFilter = null != this.reporterFilter ? this.reporterFilter : Predicates.alwaysTrue();
        return new CloudWatchReporter(resolvedRegistry, resolvedNamespace, resolvedFilter, resolvedCloudWatchClient).withDimensions(resolvedDimensions).withTimestampLocal(resolvedTimestampLocal).withTypeDimName(resolvedTypeDimName).withTypeDimValGauge(resolvedTypeDimValGauge).withTypeDimValCounterCount(resolvedTypeDimValCounterCount).withTypeDimValMeterCount(resolvedTypeDimValMeterCount).withTypeDimValHistoSamples(resolvedTypeDimValHistoSamples).withTypeDimValHistoStats(resolvedTypeDimValHistoStats).withTypeDimValTimerSamples(resolvedTypeDimValTimerSamples).withTypeDimValTimerStats(resolvedTypeDimValTimerStats).withReporterFilter(resolvedReporterFilter);
    }
}

