/*
 * Decompiled with CFR 0.152.
 */
package com.blacklocus.metrics;

import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.blacklocus.metrics.PermutableChain;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

class DemuxedKey {
    final PermutableChain<String> nameChain;
    final PermutableChain<Dimension> dimensionChain;

    DemuxedKey(String s) {
        String[] segments = s.split("\\s");
        PermutableChain<String> names = null;
        PermutableChain<Dimension> dimensions = null;
        for (int i = segments.length - 1; i >= 0; --i) {
            String segment = segments[i];
            boolean permutable = segment.endsWith("*");
            if (permutable) {
                segment = segment.substring(0, segment.length() - 1);
            }
            if (segment.contains("=")) {
                String[] dimensionParts = segment.split("=", 2);
                Dimension dimension = new Dimension().withName(dimensionParts[0]).withValue(dimensionParts[1]);
                dimensions = new PermutableChain<Dimension>(dimension, permutable, dimensions);
                continue;
            }
            assert (!segment.contains("*"));
            names = new PermutableChain<String>(segment, permutable, names);
        }
        this.nameChain = names;
        this.dimensionChain = dimensions;
    }

    Iterable<MetricDatum> newDatums(String typeName, String typeValue, Function<MetricDatum, MetricDatum> datumSpecification) {
        PermutableChain<Dimension> withDimensionChain = new PermutableChain<Dimension>(new Dimension().withName(typeName).withValue(typeValue), false, this.dimensionChain);
        ArrayList<MetricDatum> data = new ArrayList<MetricDatum>();
        for (Iterable<String> iterable : this.nameChain) {
            String name = StringUtils.join(iterable, (String)" ");
            if (StringUtils.isBlank((CharSequence)name)) continue;
            for (Iterable<Dimension> iterable2 : withDimensionChain) {
                data.add((MetricDatum)datumSpecification.apply((Object)new MetricDatum().withMetricName(name).withDimensions((Collection)Lists.newArrayList(iterable2))));
            }
        }
        return data;
    }
}

