/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import androidx.core.content.ContextCompat;
import com.blacksquircle.ui.editorkit.exception.LineException;
import com.blacksquircle.ui.editorkit.widget.TextProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0005\u001a\n\u0010\n\u001a\u00020\t*\u00020\u0005\u001a\n\u0010\u000b\u001a\u00020\t*\u00020\u0005\u001a\n\u0010\f\u001a\u00020\t*\u00020\u0005\u001a\u0012\u0010\r\u001a\u00020\t*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0005\u001a\u0012\u0010\u0012\u001a\u00020\t*\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0004\u001a\n\u0010\u0014\u001a\u00020\u0011*\u00020\u0005\u001a\n\u0010\u0015\u001a\u00020\u0011*\u00020\u0005\u001a\n\u0010\u0016\u001a\u00020\u0011*\u00020\u0005\u001a\n\u0010\u0017\u001a\u00020\u0011*\u00020\u0005\u001a\n\u0010\u0018\u001a\u00020\t*\u00020\u0005\u001a\n\u0010\u0019\u001a\u00020\t*\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"LABEL_COPY", "", "LABEL_CUT", "selectedText", "", "Lcom/blacksquircle/ui/editorkit/widget/TextProcessor;", "getSelectedText", "(Lcom/blacksquircle/ui/editorkit/widget/TextProcessor;)Ljava/lang/CharSequence;", "copy", "", "cut", "deleteLine", "duplicateLine", "gotoLine", "lineNumber", "", "hasPrimaryClip", "", "insert", "delta", "moveCaretToEndOfLine", "moveCaretToNextWord", "moveCaretToPrevWord", "moveCaretToStartOfLine", "paste", "selectLine", "editorkit_release"})
public final class ExtensionsKt {
    @NotNull
    private static final String LABEL_CUT = "CUT";
    @NotNull
    private static final String LABEL_COPY = "COPY";

    @NotNull
    public static final CharSequence getSelectedText(@NotNull TextProcessor $this$selectedText) {
        Intrinsics.checkNotNullParameter((Object)$this$selectedText, (String)"<this>");
        return $this$selectedText.getText().subSequence($this$selectedText.getSelectionStart(), $this$selectedText.getSelectionEnd());
    }

    public static final void insert(@NotNull TextProcessor $this$insert, @NotNull CharSequence delta) {
        Intrinsics.checkNotNullParameter((Object)$this$insert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
        $this$insert.getText().replace($this$insert.getSelectionStart(), $this$insert.getSelectionEnd(), delta);
    }

    /*
     * WARNING - void declaration
     */
    public static final void cut(@NotNull TextProcessor $this$cut) {
        void $this$getSystemService$iv;
        Intrinsics.checkNotNullParameter((Object)$this$cut, (String)"<this>");
        Context context = $this$cut.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        boolean $i$f$getSystemService = false;
        ClipboardManager clipboardManager = (ClipboardManager)ContextCompat.getSystemService((Context)$this$getSystemService$iv, ClipboardManager.class);
        ClipData clipData = ClipData.newPlainText((CharSequence)LABEL_CUT, (CharSequence)ExtensionsKt.getSelectedText($this$cut));
        ClipboardManager clipboardManager2 = clipboardManager;
        if (clipboardManager2 != null) {
            clipboardManager2.setPrimaryClip(clipData);
        }
        $this$cut.getText().replace($this$cut.getSelectionStart(), $this$cut.getSelectionEnd(), (CharSequence)"");
    }

    /*
     * WARNING - void declaration
     */
    public static final void copy(@NotNull TextProcessor $this$copy) {
        void $this$getSystemService$iv;
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"<this>");
        Context context = $this$copy.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        boolean $i$f$getSystemService = false;
        ClipboardManager clipboardManager = (ClipboardManager)ContextCompat.getSystemService((Context)$this$getSystemService$iv, ClipboardManager.class);
        ClipData clipData = ClipData.newPlainText((CharSequence)LABEL_COPY, (CharSequence)ExtensionsKt.getSelectedText($this$copy));
        ClipboardManager clipboardManager2 = clipboardManager;
        if (clipboardManager2 != null) {
            clipboardManager2.setPrimaryClip(clipData);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void paste(@NotNull TextProcessor $this$paste) {
        ClipData clipData;
        void $this$getSystemService$iv;
        ClipboardManager clipboardManager;
        Intrinsics.checkNotNullParameter((Object)$this$paste, (String)"<this>");
        Context context = $this$paste.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        boolean $i$f$getSystemService22 = false;
        ClipboardManager $i$f$getSystemService22 = clipboardManager = (ClipboardManager)ContextCompat.getSystemService((Context)$this$getSystemService$iv, ClipboardManager.class);
        ClipData.Item clipData2 = $i$f$getSystemService22 == null ? null : ((clipData = $i$f$getSystemService22.getPrimaryClip()) == null ? null : clipData.getItemAt(0));
        clipData = clipData2;
        CharSequence clipText = clipData == null ? null : clipData.coerceToText($this$paste.getContext());
        $this$paste.getText().replace($this$paste.getSelectionStart(), $this$paste.getSelectionEnd(), clipText);
    }

    public static final void selectLine(@NotNull TextProcessor $this$selectLine) {
        Intrinsics.checkNotNullParameter((Object)$this$selectLine, (String)"<this>");
        int currentLine = $this$selectLine.getLines().getLineForIndex($this$selectLine.getSelectionStart());
        int lineStart = $this$selectLine.getLines().getIndexForStartOfLine(currentLine);
        int lineEnd = $this$selectLine.getLines().getIndexForEndOfLine(currentLine);
        $this$selectLine.setSelection(lineStart, lineEnd);
    }

    public static final void deleteLine(@NotNull TextProcessor $this$deleteLine) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteLine, (String)"<this>");
        int currentLine = $this$deleteLine.getLines().getLineForIndex($this$deleteLine.getSelectionStart());
        int lineStart = $this$deleteLine.getLines().getIndexForStartOfLine(currentLine);
        int lineEnd = $this$deleteLine.getLines().getIndexForEndOfLine(currentLine);
        $this$deleteLine.getText().delete(lineStart, lineEnd);
    }

    public static final void duplicateLine(@NotNull TextProcessor $this$duplicateLine) {
        Intrinsics.checkNotNullParameter((Object)$this$duplicateLine, (String)"<this>");
        int currentLine = $this$duplicateLine.getLines().getLineForIndex($this$duplicateLine.getSelectionStart());
        int lineStart = $this$duplicateLine.getLines().getIndexForStartOfLine(currentLine);
        int lineEnd = $this$duplicateLine.getLines().getIndexForEndOfLine(currentLine);
        CharSequence lineText = $this$duplicateLine.getText().subSequence(lineStart, lineEnd);
        $this$duplicateLine.getText().insert(lineEnd, (CharSequence)("\n" + lineText));
    }

    public static final boolean moveCaretToStartOfLine(@NotNull TextProcessor $this$moveCaretToStartOfLine) {
        Intrinsics.checkNotNullParameter((Object)$this$moveCaretToStartOfLine, (String)"<this>");
        int currentLine = $this$moveCaretToStartOfLine.getLines().getLineForIndex($this$moveCaretToStartOfLine.getSelectionStart());
        int lineStart = $this$moveCaretToStartOfLine.getLines().getIndexForStartOfLine(currentLine);
        $this$moveCaretToStartOfLine.setSelection(lineStart);
        return true;
    }

    public static final boolean moveCaretToEndOfLine(@NotNull TextProcessor $this$moveCaretToEndOfLine) {
        Intrinsics.checkNotNullParameter((Object)$this$moveCaretToEndOfLine, (String)"<this>");
        int currentLine = $this$moveCaretToEndOfLine.getLines().getLineForIndex($this$moveCaretToEndOfLine.getSelectionEnd());
        int lineEnd = $this$moveCaretToEndOfLine.getLines().getIndexForEndOfLine(currentLine);
        $this$moveCaretToEndOfLine.setSelection(lineEnd);
        return true;
    }

    public static final boolean moveCaretToPrevWord(@NotNull TextProcessor $this$moveCaretToPrevWord) {
        Intrinsics.checkNotNullParameter((Object)$this$moveCaretToPrevWord, (String)"<this>");
        if ($this$moveCaretToPrevWord.getSelectionStart() > 0) {
            int i;
            boolean isLetterDigitOrUnderscore;
            int currentChar;
            int n = currentChar = $this$moveCaretToPrevWord.getText().charAt($this$moveCaretToPrevWord.getSelectionStart() - 1);
            boolean bl = false;
            boolean bl2 = isLetterDigitOrUnderscore = Character.isLetterOrDigit((char)n) || currentChar == 95;
            if (isLetterDigitOrUnderscore) {
                n = $this$moveCaretToPrevWord.getSelectionStart();
                if (0 <= n) {
                    do {
                        char c;
                        i = n--;
                        char c2 = c = $this$moveCaretToPrevWord.getText().charAt(i - 1);
                        boolean bl3 = false;
                        if (Character.isLetterOrDigit(c2) || c == '_') continue;
                        $this$moveCaretToPrevWord.setSelection(i);
                        break;
                    } while (0 <= n);
                }
            } else {
                n = $this$moveCaretToPrevWord.getSelectionStart();
                if (0 <= n) {
                    do {
                        char c;
                        i = n--;
                        char c3 = c = $this$moveCaretToPrevWord.getText().charAt(i - 1);
                        boolean bl4 = false;
                        if (!Character.isLetterOrDigit(c3) && c != '_') continue;
                        $this$moveCaretToPrevWord.setSelection(i);
                        break;
                    } while (0 <= n);
                }
            }
        }
        return true;
    }

    public static final boolean moveCaretToNextWord(@NotNull TextProcessor $this$moveCaretToNextWord) {
        Intrinsics.checkNotNullParameter((Object)$this$moveCaretToNextWord, (String)"<this>");
        if ($this$moveCaretToNextWord.getSelectionStart() < $this$moveCaretToNextWord.getText().length()) {
            boolean isLetterDigitOrUnderscore;
            int currentChar;
            int n = currentChar = $this$moveCaretToNextWord.getText().charAt($this$moveCaretToNextWord.getSelectionStart());
            int n2 = 0;
            boolean bl = isLetterDigitOrUnderscore = Character.isLetterOrDigit((char)n) || currentChar == 95;
            if (isLetterDigitOrUnderscore) {
                n = $this$moveCaretToNextWord.getSelectionStart();
                if (n < (n2 = $this$moveCaretToNextWord.getText().length())) {
                    do {
                        char c;
                        int i = n++;
                        char c2 = c = $this$moveCaretToNextWord.getText().charAt(i);
                        boolean bl2 = false;
                        if (Character.isLetterOrDigit(c2) || c == '_') continue;
                        $this$moveCaretToNextWord.setSelection(i);
                        break;
                    } while (n < n2);
                }
            } else {
                n = $this$moveCaretToNextWord.getSelectionStart();
                if (n < (n2 = $this$moveCaretToNextWord.getText().length())) {
                    do {
                        char c;
                        int i = n++;
                        char c3 = c = $this$moveCaretToNextWord.getText().charAt(i);
                        boolean bl3 = false;
                        if (!Character.isLetterOrDigit(c3) && c != '_') continue;
                        $this$moveCaretToNextWord.setSelection(i);
                        break;
                    } while (n < n2);
                }
            }
        }
        return true;
    }

    public static final void gotoLine(@NotNull TextProcessor $this$gotoLine, int lineNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$gotoLine, (String)"<this>");
        int line = lineNumber - 1;
        if (line < 0 || line >= $this$gotoLine.getLines().getLineCount() - 1) {
            throw new LineException(lineNumber);
        }
        $this$gotoLine.setSelection($this$gotoLine.getLines().getIndexForLine(line));
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean hasPrimaryClip(@NotNull TextProcessor $this$hasPrimaryClip) {
        boolean bl;
        void $this$getSystemService$iv;
        Intrinsics.checkNotNullParameter((Object)$this$hasPrimaryClip, (String)"<this>");
        Context context = $this$hasPrimaryClip.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        boolean $i$f$getSystemService = false;
        ClipboardManager clipboardManager = (ClipboardManager)ContextCompat.getSystemService((Context)$this$getSystemService$iv, ClipboardManager.class);
        context = clipboardManager;
        return context == null ? false : (bl = context.hasPrimaryClip());
    }
}

