/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.plugin.autocomplete;

import android.graphics.Rect;
import android.text.Layout;
import android.util.Log;
import android.widget.ListAdapter;
import com.blacksquircle.ui.editorkit.plugin.autocomplete.SuggestionAdapter;
import com.blacksquircle.ui.editorkit.plugin.autocomplete.SymbolsTokenizer;
import com.blacksquircle.ui.editorkit.plugin.base.EditorPlugin;
import com.blacksquircle.ui.editorkit.widget.TextProcessor;
import com.blacksquircle.ui.language.base.Language;
import com.blacksquircle.ui.language.base.provider.SuggestionProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\r\n\u0002\b\f\u0018\u0000 /2\u00020\u0001:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0012\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u000bH\u0002J(\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\rH\u0016J*\u0010\"\u001a\u00020\u000b2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\rH\u0016J \u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020$H\u0016J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010-\u001a\u00020\u000bH\u0016J\b\u0010.\u001a\u00020\u000bH\u0002R(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u00060"}, d2={"Lcom/blacksquircle/ui/editorkit/plugin/autocomplete/AutoCompletePlugin;", "Lcom/blacksquircle/ui/editorkit/plugin/base/EditorPlugin;", "()V", "value", "Lcom/blacksquircle/ui/editorkit/plugin/autocomplete/SuggestionAdapter;", "suggestionAdapter", "getSuggestionAdapter", "()Lcom/blacksquircle/ui/editorkit/plugin/autocomplete/SuggestionAdapter;", "setSuggestionAdapter", "(Lcom/blacksquircle/ui/editorkit/plugin/autocomplete/SuggestionAdapter;)V", "addLine", "", "lineNumber", "", "lineStart", "lineLength", "clearLines", "getVisibleHeight", "onAttached", "editText", "Lcom/blacksquircle/ui/editorkit/widget/TextProcessor;", "onDetached", "onDropDownSizeChange", "width", "height", "onLanguageChanged", "language", "Lcom/blacksquircle/ui/language/base/Language;", "onPopupChangePosition", "onSizeChanged", "w", "h", "oldw", "oldh", "onTextChanged", "text", "", "start", "before", "count", "onTextReplaced", "newStart", "newEnd", "newText", "removeLine", "showDropDown", "updateAdapter", "Companion", "editorkit_release"})
public final class AutoCompletePlugin
extends EditorPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private SuggestionAdapter suggestionAdapter;
    @NotNull
    public static final String PLUGIN_ID = "autocomplete-6743";

    public AutoCompletePlugin() {
        super(PLUGIN_ID);
    }

    @Nullable
    public final SuggestionAdapter getSuggestionAdapter() {
        return this.suggestionAdapter;
    }

    public final void setSuggestionAdapter(@Nullable SuggestionAdapter value) {
        this.suggestionAdapter = value;
        this.updateAdapter();
    }

    @Override
    public void onAttached(@NotNull TextProcessor editText) {
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        super.onAttached(editText);
        editText.setTokenizer(new SymbolsTokenizer());
        editText.setAdapter((ListAdapter)this.suggestionAdapter);
        Log.d((String)PLUGIN_ID, (String)"AutoComplete plugin loaded successfully!");
    }

    @Override
    public void onDetached(@NotNull TextProcessor editText) {
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        editText.setTokenizer(null);
        editText.setAdapter(null);
        super.onDetached(editText);
    }

    @Override
    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.onDropDownSizeChange(w, h);
    }

    @Override
    public void onTextChanged(@Nullable CharSequence text, int start, int before, int count) {
        super.onTextChanged(text, start, before, count);
        this.onPopupChangePosition();
    }

    @Override
    public void addLine(int lineNumber, int lineStart, int lineLength) {
        SuggestionProvider suggestionProvider;
        super.addLine(lineNumber, lineStart, lineLength);
        Language language = this.getLanguage();
        if (language != null && (suggestionProvider = language.getProvider()) != null) {
            Object object = this.getEditText().getText();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"editText.text");
            object = (CharSequence)object;
            int n = lineStart + lineLength;
            boolean bl = false;
            suggestionProvider.processLine(lineNumber, ((Object)object.subSequence(lineStart, n)).toString());
        }
    }

    @Override
    public void removeLine(int lineNumber) {
        SuggestionProvider suggestionProvider;
        super.removeLine(lineNumber);
        Language language = this.getLanguage();
        if (language != null && (suggestionProvider = language.getProvider()) != null) {
            suggestionProvider.deleteLine(this.getLines().getIndexForLine(lineNumber));
        }
    }

    @Override
    public void clearLines() {
        SuggestionProvider suggestionProvider;
        super.clearLines();
        Language language = this.getLanguage();
        if (language != null && (suggestionProvider = language.getProvider()) != null) {
            suggestionProvider.clearLines();
        }
    }

    @Override
    public void onTextReplaced(int newStart, int newEnd, @NotNull CharSequence newText) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        super.onTextReplaced(newStart, newEnd, newText);
        int startLine = this.getLines().getLineForIndex(newStart);
        int endLine = this.getLines().getLineForIndex(newText.length() + newStart);
        int n = startLine;
        if (n <= endLine) {
            int currentLine;
            do {
                SuggestionProvider suggestionProvider;
                Language language;
                int lineEnd;
                currentLine = n++;
                int lineStart = this.getLines().getIndexForStartOfLine(currentLine);
                if (lineStart > (lineEnd = this.getLines().getIndexForEndOfLine(currentLine)) || lineEnd > this.getEditText().getText().length() || (language = this.getLanguage()) == null || (suggestionProvider = language.getProvider()) == null) continue;
                Object object = this.getEditText().getText();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"editText.text");
                object = (CharSequence)object;
                boolean bl = false;
                suggestionProvider.processLine(currentLine, ((Object)object.subSequence(lineStart, lineEnd)).toString());
            } while (currentLine != endLine);
        }
    }

    @Override
    public void onLanguageChanged(@Nullable Language language) {
        SuggestionProvider suggestionProvider;
        super.onLanguageChanged(language);
        Language language2 = language;
        if (language2 != null && (suggestionProvider = language2.getProvider()) != null) {
            SuggestionProvider suggestionProvider2 = suggestionProvider;
            boolean bl = false;
            boolean bl2 = false;
            SuggestionProvider provider = suggestionProvider2;
            boolean bl3 = false;
            SuggestionAdapter suggestionAdapter = this.getSuggestionAdapter();
            if (suggestionAdapter != null) {
                suggestionAdapter.setSuggestionProvider(provider);
            }
        }
    }

    @Override
    public void showDropDown() {
        if (!this.getEditText().isPopupShowing() && this.getEditText().hasFocus()) {
            super.showDropDown();
        }
    }

    private final void updateAdapter() {
        SuggestionAdapter suggestionAdapter;
        if (this.isAttached() && (suggestionAdapter = this.suggestionAdapter) != null) {
            SuggestionProvider suggestionProvider;
            SuggestionAdapter suggestionAdapter2 = suggestionAdapter;
            boolean bl = false;
            boolean bl2 = false;
            SuggestionAdapter adapter = suggestionAdapter2;
            boolean bl3 = false;
            Language language = this.getLanguage();
            if (language != null && (suggestionProvider = language.getProvider()) != null) {
                SuggestionProvider suggestionProvider2 = suggestionProvider;
                boolean bl4 = false;
                boolean bl5 = false;
                SuggestionProvider provider = suggestionProvider2;
                boolean bl6 = false;
                adapter.setSuggestionProvider(provider);
            }
            this.getEditText().setAdapter((ListAdapter)adapter);
        }
    }

    private final void onDropDownSizeChange(int width, int height) {
        this.getEditText().setDropDownWidth(width * 1 / 2);
        this.getEditText().setDropDownHeight(height * 1 / 2);
        this.onPopupChangePosition();
    }

    private final void onPopupChangePosition() {
        Layout layout = this.getEditText().getLayout();
        if (layout == null) {
            return;
        }
        Layout layout2 = layout;
        int line = layout2.getLineForOffset(this.getEditText().getSelectionStart());
        float x = layout2.getPrimaryHorizontal(this.getEditText().getSelectionStart());
        int y = layout2.getLineBaseline(line);
        float offsetHorizontal = x + (float)this.getEditText().getPaddingStart();
        this.getEditText().setDropDownHorizontalOffset((int)offsetHorizontal);
        int offsetVertical = y - this.getEditText().getScrollY();
        int temp = offsetVertical + this.getEditText().getDropDownHeight();
        this.getEditText().setDropDownVerticalOffset(temp > this.getVisibleHeight() ? offsetVertical - this.getEditText().getDropDownHeight() : offsetVertical);
    }

    private final int getVisibleHeight() {
        Rect rect = new Rect();
        this.getEditText().getWindowVisibleDisplayFrame(rect);
        return rect.bottom - rect.top;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/blacksquircle/ui/editorkit/plugin/autocomplete/AutoCompletePlugin$Companion;", "", "()V", "PLUGIN_ID", "", "editorkit_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

