/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.plugin.pinchzoom;

import android.util.Log;
import android.view.MotionEvent;
import com.blacksquircle.ui.editorkit.plugin.base.EditorPlugin;
import com.blacksquircle.ui.editorkit.widget.TextProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/blacksquircle/ui/editorkit/plugin/pinchzoom/PinchZoomPlugin;", "Lcom/blacksquircle/ui/editorkit/plugin/base/EditorPlugin;", "()V", "isDoingPinchZoom", "", "maxTextSize", "", "getMaxTextSize", "()F", "setMaxTextSize", "(F)V", "minTextSize", "getMinTextSize", "setMinTextSize", "pinchFactor", "getDistanceBetweenTouches", "event", "Landroid/view/MotionEvent;", "onAttached", "", "editText", "Lcom/blacksquircle/ui/editorkit/widget/TextProcessor;", "onTouchEvent", "updateTextSize", "size", "Companion", "editorkit_release"})
public final class PinchZoomPlugin
extends EditorPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float minTextSize = 10.0f;
    private float maxTextSize = 20.0f;
    private boolean isDoingPinchZoom;
    private float pinchFactor = 1.0f;
    @NotNull
    public static final String PLUGIN_ID = "pinchzoom-0361";
    public static final float DEFAULT_MIN_TEXT_SIZE = 10.0f;
    public static final float DEFAULT_MAX_TEXT_SIZE = 20.0f;

    public PinchZoomPlugin() {
        super(PLUGIN_ID);
    }

    public final float getMinTextSize() {
        return this.minTextSize;
    }

    public final void setMinTextSize(float f) {
        this.minTextSize = f;
    }

    public final float getMaxTextSize() {
        return this.maxTextSize;
    }

    public final void setMaxTextSize(float f) {
        this.maxTextSize = f;
    }

    @Override
    public void onAttached(@NotNull TextProcessor editText) {
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        super.onAttached(editText);
        Log.d((String)PLUGIN_ID, (String)"PinchZoom plugin loaded successfully!");
    }

    @Override
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int n = event.getAction();
        switch (n) {
            case 1: 
            case 3: {
                this.isDoingPinchZoom = false;
                break;
            }
            case 2: {
                if (event.getPointerCount() != 2) break;
                float distance = this.getDistanceBetweenTouches(event);
                if (!this.isDoingPinchZoom) {
                    float scaledDensity = this.requireContext().getResources().getDisplayMetrics().scaledDensity;
                    float textSize = this.getEditText().getTextSize();
                    this.pinchFactor = textSize / scaledDensity / distance;
                    this.isDoingPinchZoom = true;
                }
                return this.updateTextSize(this.pinchFactor * distance);
            }
        }
        return false;
    }

    private final float getDistanceBetweenTouches(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        float f = x * x + y * y;
        boolean bl = false;
        return (float)Math.sqrt(f);
    }

    private final boolean updateTextSize(float size) {
        this.getEditText().setTextSize(size < this.minTextSize ? this.minTextSize : (size > this.maxTextSize ? this.maxTextSize : size));
        return true;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/blacksquircle/ui/editorkit/plugin/pinchzoom/PinchZoomPlugin$Companion;", "", "()V", "DEFAULT_MAX_TEXT_SIZE", "", "DEFAULT_MIN_TEXT_SIZE", "PLUGIN_ID", "", "editorkit_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

