/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.widget.internal;

import android.content.Context;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.core.text.PrecomputedTextCompat;
import androidx.core.widget.TextViewCompat;
import com.blacksquircle.ui.editorkit.R;
import com.blacksquircle.ui.editorkit.model.LinesCollection;
import com.blacksquircle.ui.editorkit.widget.internal.LineNumbersEditText;
import com.blacksquircle.ui.editorkit.widget.internal.ScrollableEditText;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000]\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000*\u0001\u001b\b&\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0016J\u0012\u0010\"\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J*\u0010%\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0016J*\u0010*\u001a\u00020\u001e2\b\u0010#\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0016J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J \u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020&H\u0016J\u0010\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u000203H\u0016J\u000e\u00101\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020&R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001c\u00a8\u00064"}, d2={"Lcom/blacksquircle/ui/editorkit/widget/internal/LineNumbersEditText;", "Lcom/blacksquircle/ui/editorkit/widget/internal/ScrollableEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "lines", "Lcom/blacksquircle/ui/editorkit/model/LinesCollection;", "getLines", "()Lcom/blacksquircle/ui/editorkit/model/LinesCollection;", "value", "", "softKeyboard", "getSoftKeyboard", "()Z", "setSoftKeyboard", "(Z)V", "textChangeEnd", "textChangeStart", "textChangedNewText", "", "textContent", "Landroid/text/SpannableStringBuilder;", "textWatcher", "com/blacksquircle/ui/editorkit/widget/internal/LineNumbersEditText$textWatcher$1", "Lcom/blacksquircle/ui/editorkit/widget/internal/LineNumbersEditText$textWatcher$1;", "addLine", "", "lineNumber", "lineStart", "lineLength", "doAfterTextChanged", "text", "Landroid/text/Editable;", "doBeforeTextChanged", "", "start", "count", "after", "doOnTextChanged", "before", "removeLine", "replaceText", "newStart", "newEnd", "newText", "setTextContent", "textParams", "Landroidx/core/text/PrecomputedTextCompat;", "editorkit_release"})
public abstract class LineNumbersEditText
extends ScrollableEditText {
    private boolean softKeyboard;
    @NotNull
    private final LinesCollection lines;
    @NotNull
    private final SpannableStringBuilder textContent;
    @NotNull
    private final textWatcher.1 textWatcher;
    private int textChangeStart;
    private int textChangeEnd;
    @NotNull
    private String textChangedNewText;

    @JvmOverloads
    public LineNumbersEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.lines = new LinesCollection();
        this.textContent = new SpannableStringBuilder((CharSequence)"");
        this.textWatcher = new TextWatcher(this){
            final /* synthetic */ LineNumbersEditText this$0;
            {
                this.this$0 = $receiver;
            }

            public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
                this.this$0.doBeforeTextChanged(s, start, count, after);
            }

            public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
                this.this$0.doOnTextChanged(s, start, before, count);
            }

            public void afterTextChanged(@Nullable Editable s) {
                this.this$0.doAfterTextChanged(s);
            }
        };
        this.textChangedNewText = "";
        this.setGravity(0x800033);
        this.setInputType(655361);
    }

    public /* synthetic */ LineNumbersEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.autoCompleteTextViewStyle;
        }
        this(context, attributeSet, n);
    }

    public final boolean getSoftKeyboard() {
        return this.softKeyboard;
    }

    public final void setSoftKeyboard(boolean value) {
        this.softKeyboard = value;
        this.setImeOptions(value ? 0 : 0x10000000);
    }

    @NotNull
    public final LinesCollection getLines() {
        return this.lines;
    }

    public void doBeforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
        this.textChangeStart = start;
        this.textChangeEnd = start + count;
    }

    public void doOnTextChanged(@Nullable CharSequence text, int start, int before, int count) {
        CharSequence charSequence = text;
        this.textChangedNewText = String.valueOf(charSequence == null ? null : charSequence.subSequence(start, start + count));
        this.replaceText(this.textChangeStart, this.textChangeEnd, this.textChangedNewText);
    }

    public void doAfterTextChanged(@Nullable Editable text) {
    }

    public void setTextContent(@NotNull PrecomputedTextCompat textParams) {
        Intrinsics.checkNotNullParameter((Object)textParams, (String)"textParams");
        this.removeTextChangedListener(this.textWatcher);
        this.setText((CharSequence)textParams);
        this.textContent.clear();
        int n = this.textContent.length();
        String string = textParams.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textParams.toString()");
        this.replaceText(0, n, string);
        this.lines.clear();
        int lineNumber = 0;
        int lineStart = 0;
        Editable editable = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)editable, (String)"text");
        Iterable $this$forEach$iv = StringsKt.lines((CharSequence)((CharSequence)editable));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            this.addLine(lineNumber, lineStart, line.length());
            lineStart += line.length() + 1;
            int n2 = lineNumber;
            lineNumber = n2 + 1;
        }
        this.lines.add(lineNumber, lineStart);
        this.addTextChangedListener(this.textWatcher);
    }

    public void replaceText(int newStart, int newEnd, @NotNull CharSequence newText) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        int start = newStart < 0 ? 0 : newStart;
        int end = newEnd >= this.textContent.length() ? this.textContent.length() : newEnd;
        int newCharCount = newText.length() - (end - start);
        int startLine = this.lines.getLineForIndex(start);
        int n = start;
        if (n < end) {
            do {
                int i;
                if (this.textContent.charAt(i = n++) != '\n') continue;
                this.removeLine(startLine + 1);
            } while (n < end);
        }
        this.lines.shiftIndexes(this.lines.getLineForIndex(start) + 1, newCharCount);
        n = 0;
        int n2 = newText.length() + -1;
        if (n <= n2) {
            do {
                int i;
                if (newText.charAt(i = n++) != '\n') continue;
                this.lines.add(this.lines.getLineForIndex(start + i) + 1, start + i + 1);
            } while (n <= n2);
        }
        this.textContent.replace(start, end, newText);
    }

    public void addLine(int lineNumber, int lineStart, int lineLength) {
        this.lines.add(lineNumber, lineStart);
    }

    public void removeLine(int lineNumber) {
        this.lines.remove(lineNumber);
    }

    public final void setTextContent(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        PrecomputedTextCompat.Params params = TextViewCompat.getTextMetricsParams((TextView)((TextView)this));
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"getTextMetricsParams(this)");
        PrecomputedTextCompat.Params textParams = params;
        PrecomputedTextCompat precomputedText = PrecomputedTextCompat.create((CharSequence)text, (PrecomputedTextCompat.Params)textParams);
        Intrinsics.checkNotNullExpressionValue((Object)precomputedText, (String)"precomputedText");
        this.setTextContent(precomputedText);
    }

    @JvmOverloads
    public LineNumbersEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public LineNumbersEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

