/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.widget.internal;

import android.content.Context;
import android.text.Editable;
import android.text.Spanned;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.core.text.PrecomputedTextCompat;
import com.blacksquircle.ui.editorkit.R;
import com.blacksquircle.ui.editorkit.model.ErrorSpan;
import com.blacksquircle.ui.editorkit.model.FindParams;
import com.blacksquircle.ui.editorkit.model.FindResultSpan;
import com.blacksquircle.ui.editorkit.model.TabWidthSpan;
import com.blacksquircle.ui.editorkit.utils.EditorTheme;
import com.blacksquircle.ui.editorkit.utils.ExtensionsKt;
import com.blacksquircle.ui.editorkit.utils.StylingTask;
import com.blacksquircle.ui.editorkit.widget.internal.UndoRedoEditText;
import com.blacksquircle.ui.language.base.Language;
import com.blacksquircle.ui.language.base.model.ColorScheme;
import com.blacksquircle.ui.language.base.span.StyleSpan;
import com.blacksquircle.ui.language.base.span.SyntaxHighlightSpan;
import com.blacksquircle.ui.language.base.styler.LanguageStyler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010.\u001a\u00020/H\u0002J\u0006\u00100\u001a\u00020/J\u0012\u00101\u001a\u00020/2\b\u00102\u001a\u0004\u0018\u000103H\u0016J*\u00104\u001a\u00020/2\b\u00102\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u0007H\u0016J*\u00109\u001a\u00020/2\b\u00102\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0007H\u0016J\u000e\u0010;\u001a\u00020/2\u0006\u0010<\u001a\u00020=J\u0006\u0010>\u001a\u00020/J\u0006\u0010?\u001a\u00020/J\b\u0010@\u001a\u00020/H\u0016J\b\u0010A\u001a\u00020/H\u0016J(\u0010B\u001a\u00020/2\u0006\u0010C\u001a\u00020\u00072\u0006\u0010D\u001a\u00020\u00072\u0006\u0010E\u001a\u00020\u00072\u0006\u0010F\u001a\u00020\u0007H\u0014J(\u0010G\u001a\u00020/2\u0006\u0010H\u001a\u00020\u00072\u0006\u0010I\u001a\u00020\u00072\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u0007H\u0014J\u000e\u0010L\u001a\u00020/2\u0006\u0010M\u001a\u00020NJ\u000e\u0010O\u001a\u00020/2\u0006\u0010M\u001a\u00020NJ\b\u0010P\u001a\u00020/H\u0002J\b\u0010Q\u001a\u00020/H\u0002J\u000e\u0010R\u001a\u00020/2\u0006\u0010S\u001a\u00020\u0007J\u0010\u0010T\u001a\u00020/2\u0006\u0010U\u001a\u00020VH\u0016J\u0018\u0010W\u001a\u00020/2\u0006\u0010X\u001a\u00020\u00072\u0006\u0010Y\u001a\u00020\u0007H\u0002J\b\u0010Z\u001a\u00020/H\u0002J\u0006\u0010[\u001a\u00020NJ\b\u0010\\\u001a\u00020/H\u0002R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\n\u001a\u0004\u0018\u00010\u0019@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006]"}, d2={"Lcom/blacksquircle/ui/editorkit/widget/internal/SyntaxHighlightEditText;", "Lcom/blacksquircle/ui/editorkit/widget/internal/UndoRedoEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "addedTextCount", "value", "Lcom/blacksquircle/ui/language/base/model/ColorScheme;", "colorScheme", "getColorScheme", "()Lcom/blacksquircle/ui/language/base/model/ColorScheme;", "setColorScheme", "(Lcom/blacksquircle/ui/language/base/model/ColorScheme;)V", "findResultSpans", "", "Lcom/blacksquircle/ui/editorkit/model/FindResultSpan;", "findResultStyleSpan", "Lcom/blacksquircle/ui/language/base/span/StyleSpan;", "isErrorSpansVisible", "", "isSyntaxHighlighting", "Lcom/blacksquircle/ui/language/base/Language;", "language", "getLanguage", "()Lcom/blacksquircle/ui/language/base/Language;", "setLanguage", "(Lcom/blacksquircle/ui/language/base/Language;)V", "selectedFindResult", "syntaxHighlightSpans", "Lcom/blacksquircle/ui/language/base/span/SyntaxHighlightSpan;", "tabWidth", "getTabWidth", "()I", "setTabWidth", "(I)V", "task", "Lcom/blacksquircle/ui/editorkit/utils/StylingTask;", "useSpacesInsteadOfTabs", "getUseSpacesInsteadOfTabs", "()Z", "setUseSpacesInsteadOfTabs", "(Z)V", "cancelSyntaxHighlighting", "", "clearFindResultSpans", "doAfterTextChanged", "text", "Landroid/text/Editable;", "doBeforeTextChanged", "", "start", "count", "after", "doOnTextChanged", "before", "find", "params", "Lcom/blacksquircle/ui/editorkit/model/FindParams;", "findNext", "findPrevious", "onColorSchemeChanged", "onLanguageChanged", "onScrollChanged", "horiz", "vert", "oldHoriz", "oldVert", "onSizeChanged", "w", "h", "oldw", "oldh", "replaceAllFindResults", "replaceText", "", "replaceFindResult", "scrollToFindResult", "selectResult", "setErrorLine", "lineNumber", "setTextContent", "textParams", "Landroidx/core/text/PrecomputedTextCompat;", "shiftSpans", "from", "byHowMuch", "syntaxHighlight", "tab", "updateSyntaxHighlighting", "editorkit_release"})
public abstract class SyntaxHighlightEditText
extends UndoRedoEditText {
    @Nullable
    private Language language;
    @NotNull
    private ColorScheme colorScheme;
    private boolean useSpacesInsteadOfTabs;
    private int tabWidth;
    @NotNull
    private final List<SyntaxHighlightSpan> syntaxHighlightSpans;
    @NotNull
    private final List<FindResultSpan> findResultSpans;
    @Nullable
    private StyleSpan findResultStyleSpan;
    @Nullable
    private StylingTask task;
    private int addedTextCount;
    private int selectedFindResult;
    private boolean isSyntaxHighlighting;
    private boolean isErrorSpansVisible;

    @JvmOverloads
    public SyntaxHighlightEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.colorScheme = EditorTheme.INSTANCE.getDARCULA();
        this.useSpacesInsteadOfTabs = true;
        this.tabWidth = 4;
        boolean bl = false;
        this.syntaxHighlightSpans = new ArrayList();
        bl = false;
        this.findResultSpans = new ArrayList();
    }

    public /* synthetic */ SyntaxHighlightEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.autoCompleteTextViewStyle;
        }
        this(context, attributeSet, n);
    }

    @Nullable
    public final Language getLanguage() {
        return this.language;
    }

    public final void setLanguage(@Nullable Language value) {
        this.language = value;
        this.onLanguageChanged();
    }

    @NotNull
    public final ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public final void setColorScheme(@NotNull ColorScheme value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.colorScheme = value;
        this.onColorSchemeChanged();
    }

    public final boolean getUseSpacesInsteadOfTabs() {
        return this.useSpacesInsteadOfTabs;
    }

    public final void setUseSpacesInsteadOfTabs(boolean bl) {
        this.useSpacesInsteadOfTabs = bl;
    }

    public final int getTabWidth() {
        return this.tabWidth;
    }

    public final void setTabWidth(int n) {
        this.tabWidth = n;
    }

    @Override
    public void setTextContent(@NotNull PrecomputedTextCompat textParams) {
        Intrinsics.checkNotNullParameter((Object)textParams, (String)"textParams");
        this.syntaxHighlightSpans.clear();
        this.findResultSpans.clear();
        super.setTextContent(textParams);
        this.syntaxHighlight();
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.updateSyntaxHighlighting();
        super.onSizeChanged(w, h, oldw, oldh);
    }

    @Override
    protected void onScrollChanged(int horiz, int vert, int oldHoriz, int oldVert) {
        super.onScrollChanged(horiz, vert, oldHoriz, oldVert);
        this.updateSyntaxHighlighting();
    }

    @Override
    public void doBeforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
        SyntaxHighlightEditText syntaxHighlightEditText = this;
        syntaxHighlightEditText.addedTextCount -= count;
        this.cancelSyntaxHighlighting();
        if (!this.isSyntaxHighlighting) {
            super.doBeforeTextChanged(text, start, count, after);
        }
        this.abortFling();
    }

    @Override
    public void doOnTextChanged(@Nullable CharSequence text, int start, int before, int count) {
        SyntaxHighlightEditText syntaxHighlightEditText = this;
        syntaxHighlightEditText.addedTextCount += count;
        if (!this.isSyntaxHighlighting) {
            super.doOnTextChanged(text, start, before, count);
        }
    }

    @Override
    public void doAfterTextChanged(@Nullable Editable text) {
        if (!this.isSyntaxHighlighting) {
            this.shiftSpans(this.getSelectionStart(), this.addedTextCount);
        }
        this.addedTextCount = 0;
        this.syntaxHighlight();
    }

    public void onLanguageChanged() {
    }

    public void onColorSchemeChanged() {
        this.findResultStyleSpan = new StyleSpan(this.colorScheme.getFindResultBackgroundColor(), false, false, false, false, 30, null);
        this.setTextColor(this.colorScheme.getTextColor());
        this.setBackgroundColor(this.colorScheme.getBackgroundColor());
        this.setHighlightColor(this.colorScheme.getSelectionColor());
    }

    @NotNull
    public final String tab() {
        return this.useSpacesInsteadOfTabs ? StringsKt.repeat((CharSequence)" ", (int)this.tabWidth) : "\t";
    }

    /*
     * WARNING - void declaration
     */
    public final void clearFindResultSpans() {
        FindResultSpan[] spans;
        void start$iv;
        void $this$getSpans$iv;
        this.selectedFindResult = 0;
        this.findResultSpans.clear();
        FindResultSpan[] findResultSpanArray = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)findResultSpanArray, (String)"text");
        findResultSpanArray = (Spanned)findResultSpanArray;
        int n = 0;
        int end$iv = this.getText().length();
        boolean $i$f$getSpans = false;
        Object[] objectArray = $this$getSpans$iv.getSpans((int)start$iv, end$iv, FindResultSpan.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSpans(start, end, T::class.java)");
        for (FindResultSpan span : spans = (FindResultSpan[])objectArray) {
            this.getText().removeSpan((Object)span);
        }
    }

    public final void setErrorLine(int lineNumber) {
        if (lineNumber > 0) {
            int lineStart = this.getLines().getIndexForStartOfLine(lineNumber - 1);
            int lineEnd = this.getLines().getIndexForEndOfLine(lineNumber - 1);
            if (lineStart < this.getText().length() && lineEnd < this.getText().length() && lineStart > -1 && lineEnd > -1) {
                this.isErrorSpansVisible = true;
                this.getText().setSpan((Object)new ErrorSpan(0.0f, 0.0f, 0, 7, null), lineStart, lineEnd, 33);
            }
        }
    }

    public final void find(@NotNull FindParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        CharSequence charSequence = params.getQuery();
        boolean bl = false;
        if (charSequence.length() > 0) {
            try {
                Object object;
                Pattern pattern = params.getRegex() ? (params.getMatchCase() ? Pattern.compile(params.getQuery()) : Pattern.compile(params.getQuery(), 66)) : (params.getWordsOnly() ? (params.getMatchCase() ? Pattern.compile("\\s" + params.getQuery() + "\\s") : Pattern.compile("\\s" + Pattern.quote(params.getQuery()) + "\\s", 66)) : (params.getMatchCase() ? Pattern.compile(Pattern.quote(params.getQuery())) : Pattern.compile(Pattern.quote(params.getQuery()), 66)));
                Matcher matcher = pattern.matcher((CharSequence)this.getText());
                while (matcher.find()) {
                    object = this.findResultStyleSpan;
                    if (object == null) continue;
                    Object object2 = object;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Object it = object2;
                    boolean bl4 = false;
                    FindResultSpan findResultSpan = new FindResultSpan((StyleSpan)it, matcher.start(), matcher.end());
                    this.findResultSpans.add(findResultSpan);
                    this.getText().setSpan((Object)findResultSpan, findResultSpan.getStart(), findResultSpan.getEnd(), 33);
                }
                object = this.findResultSpans;
                boolean bl5 = false;
                if (!object.isEmpty()) {
                    this.selectResult();
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    public final void findNext() {
        if (this.selectedFindResult < this.findResultSpans.size() - 1) {
            SyntaxHighlightEditText syntaxHighlightEditText = this;
            ++syntaxHighlightEditText.selectedFindResult;
            this.selectResult();
        }
    }

    public final void findPrevious() {
        if (this.selectedFindResult > 0 && this.selectedFindResult < this.findResultSpans.size()) {
            SyntaxHighlightEditText syntaxHighlightEditText = this;
            --syntaxHighlightEditText.selectedFindResult;
            this.selectResult();
        }
    }

    public final void replaceFindResult(@NotNull String replaceText) {
        Intrinsics.checkNotNullParameter((Object)replaceText, (String)"replaceText");
        Collection collection = this.findResultSpans;
        boolean bl = false;
        if (!collection.isEmpty()) {
            FindResultSpan findResult = this.findResultSpans.get(this.selectedFindResult);
            this.getText().replace(findResult.getStart(), findResult.getEnd(), (CharSequence)replaceText);
            this.findResultSpans.remove((Object)findResult);
            if (this.selectedFindResult >= this.findResultSpans.size()) {
                SyntaxHighlightEditText syntaxHighlightEditText = this;
                int n = syntaxHighlightEditText.selectedFindResult;
                syntaxHighlightEditText.selectedFindResult = n + -1;
            }
        }
    }

    public final void replaceAllFindResults(@NotNull String replaceText) {
        Intrinsics.checkNotNullParameter((Object)replaceText, (String)"replaceText");
        Collection collection = this.findResultSpans;
        int n = 0;
        if (!collection.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder((CharSequence)this.getText());
            n = this.findResultSpans.size() - 1;
            if (0 <= n) {
                do {
                    int index = n--;
                    FindResultSpan findResultSpan = this.findResultSpans.get(index);
                    stringBuilder.replace(findResultSpan.getStart(), findResultSpan.getEnd(), replaceText);
                    this.findResultSpans.remove(index);
                } while (0 <= n);
            }
            this.setText(stringBuilder.toString());
        }
    }

    private final void selectResult() {
        FindResultSpan findResult = this.findResultSpans.get(this.selectedFindResult);
        this.setSelection(findResult.getStart(), findResult.getEnd());
        this.scrollToFindResult();
    }

    private final void scrollToFindResult() {
        if (this.selectedFindResult < this.findResultSpans.size()) {
            FindResultSpan findResult = this.findResultSpans.get(this.selectedFindResult);
            if (findResult.getStart() >= this.getLayout().getLineStart(ExtensionsKt.getTopVisibleLine((TextView)this)) && findResult.getEnd() <= this.getLayout().getLineEnd(ExtensionsKt.getBottomVisibleLine((TextView)this))) {
                return;
            }
            int height = this.getLayout().getHeight() - this.getHeight() + this.getPaddingBottom() + this.getPaddingTop();
            int lineTop = this.getLayout().getLineTop(this.getLayout().getLineForOffset(findResult.getStart()));
            if (lineTop > height) {
                lineTop = height;
            }
            int scrollX = this.isHorizontallyScrollableCompat() ? (int)this.getLayout().getPrimaryHorizontal(findResult.getStart()) : this.getScrollX();
            this.scrollTo(scrollX, lineTop);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void shiftSpans(int from, int byHowMuch) {
        Object object;
        for (SyntaxHighlightSpan span : this.syntaxHighlightSpans) {
            if (span.getStart() >= from) {
                object = span;
                object.setStart(object.getStart() + byHowMuch);
            }
            if (span.getEnd() < from) continue;
            object = span;
            object.setEnd(object.getEnd() + byHowMuch);
        }
        for (FindResultSpan findResult : this.findResultSpans) {
            if (findResult.getStart() > from) {
                object = findResult;
                ((FindResultSpan)((Object)object)).setStart(((FindResultSpan)((Object)object)).getStart() + byHowMuch);
            }
            if (findResult.getEnd() < from) continue;
            object = findResult;
            ((FindResultSpan)((Object)object)).setEnd(((FindResultSpan)((Object)object)).getEnd() + byHowMuch);
        }
        if (this.isErrorSpansVisible) {
            ErrorSpan[] spans;
            void start$iv;
            void $this$getSpans$iv;
            FindResultSpan findResult;
            findResult = this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)findResult), (String)"text");
            findResult = (Spanned)findResult;
            int n = 0;
            int end$iv = this.getText().length();
            boolean $i$f$getSpans = false;
            Object[] objectArray = $this$getSpans$iv.getSpans((int)start$iv, end$iv, ErrorSpan.class);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSpans(start, end, T::class.java)");
            for (ErrorSpan span : spans = (ErrorSpan[])objectArray) {
                this.getText().removeSpan((Object)span);
            }
            this.isErrorSpansVisible = false;
        }
    }

    private final void updateSyntaxHighlighting() {
        if (this.getLayout() != null) {
            boolean isInText;
            int start$iv;
            Object $this$getSpans$iv;
            boolean isInText2;
            int start$iv2;
            Object $this$getSpans$iv2;
            int lineStart = this.getLayout().getLineStart(ExtensionsKt.getTopVisibleLine((TextView)this));
            int lineEnd = this.getLayout().getLineEnd(ExtensionsKt.getBottomVisibleLine((TextView)this));
            this.isSyntaxHighlighting = true;
            Editable editable = this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)editable, (String)"text");
            editable = (Spanned)editable;
            boolean bl = false;
            int end$iv = this.getText().length();
            boolean $i$f$getSpans = false;
            Object[] objectArray = $this$getSpans$iv2.getSpans(start$iv2, end$iv, SyntaxHighlightSpan.class);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSpans(start, end, T::class.java)");
            SyntaxHighlightSpan[] textSyntaxSpans = (SyntaxHighlightSpan[])objectArray;
            for (SyntaxHighlightSpan span : textSyntaxSpans) {
                this.getText().removeSpan((Object)span);
            }
            for (SyntaxHighlightSpan span : this.syntaxHighlightSpans) {
                boolean isVisible;
                isInText2 = span.getStart() >= 0 && span.getEnd() <= this.getText().length();
                int n = span.getStart();
                boolean bl2 = isVisible = (lineStart <= n ? n <= lineEnd : false) || span.getStart() <= lineEnd && span.getEnd() >= lineStart;
                if (!isInText2 || !isVisible) continue;
                this.getText().setSpan((Object)span, span.getStart() < lineStart ? lineStart : span.getStart(), span.getEnd() > lineEnd ? lineEnd : span.getEnd(), 33);
            }
            this.isSyntaxHighlighting = false;
            Editable span = this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)span, (String)"text");
            span = (Spanned)span;
            isInText2 = false;
            int end$iv2 = this.getText().length();
            boolean $i$f$getSpans2 = false;
            Object[] objectArray2 = $this$getSpans$iv.getSpans(start$iv, end$iv2, FindResultSpan.class);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"getSpans(start, end, T::class.java)");
            FindResultSpan[] textFindSpans = (FindResultSpan[])objectArray2;
            for (FindResultSpan span2 : textFindSpans) {
                this.getText().removeSpan((Object)span2);
            }
            for (FindResultSpan span3 : this.findResultSpans) {
                boolean isVisible;
                isInText = span3.getStart() >= 0 && span3.getEnd() <= this.getText().length();
                boolean isValid = span3.getStart() <= span3.getEnd();
                int n = span3.getStart();
                boolean bl3 = isVisible = (lineStart <= n ? n <= lineEnd : false) || span3.getStart() <= lineEnd && span3.getEnd() >= lineStart;
                if (!isInText || !isValid || !isVisible) continue;
                this.getText().setSpan((Object)span3, span3.getStart() < lineStart ? lineStart : span3.getStart(), span3.getEnd() > lineEnd ? lineEnd : span3.getEnd(), 33);
            }
            if (!this.useSpacesInsteadOfTabs) {
                TabWidthSpan[] textTabSpans;
                int start$iv3;
                TabWidthSpan[] $this$getSpans$iv3;
                Editable span3 = this.getText();
                Intrinsics.checkNotNullExpressionValue((Object)span3, (String)"text");
                span3 = (Spanned)span3;
                isInText = false;
                int end$iv3 = this.getText().length();
                boolean $i$f$getSpans3 = false;
                Object[] objectArray3 = $this$getSpans$iv3.getSpans(start$iv3, end$iv3, TabWidthSpan.class);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"getSpans(start, end, T::class.java)");
                for (TabWidthSpan span4 : textTabSpans = (TabWidthSpan[])objectArray3) {
                    this.getText().removeSpan((Object)span4);
                }
                Pattern tabPattern = Pattern.compile("\t");
                Matcher matcher = tabPattern.matcher(this.getText().subSequence(lineStart, lineEnd));
                while (matcher.find()) {
                    int start = matcher.start() + lineStart;
                    int end = matcher.end() + lineStart;
                    if (start < 0 || end > this.getText().length()) continue;
                    this.getText().setSpan((Object)new TabWidthSpan(this.tabWidth), start, end, 18);
                }
            }
            this.postInvalidate();
        }
    }

    private final void syntaxHighlight() {
        this.cancelSyntaxHighlighting();
        StylingTask stylingTask = this.task = new StylingTask((Function0<? extends List<SyntaxHighlightSpan>>)((Function0)new Function0<List<? extends SyntaxHighlightSpan>>(this){
            final /* synthetic */ SyntaxHighlightEditText this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<SyntaxHighlightSpan> invoke() {
                LanguageStyler languageStyler;
                Language language = this.this$0.getLanguage();
                List list = language == null ? null : ((languageStyler = language.getStyler()) == null ? null : languageStyler.execute(this.this$0.getText().toString(), this.this$0.getColorScheme()));
                return list == null ? CollectionsKt.emptyList() : list;
            }
        }), (Function1<? super List<SyntaxHighlightSpan>, Unit>)((Function1)new Function1<List<? extends SyntaxHighlightSpan>, Unit>(this){
            final /* synthetic */ SyntaxHighlightEditText this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<SyntaxHighlightSpan> spans) {
                Intrinsics.checkNotNullParameter(spans, (String)"spans");
                SyntaxHighlightEditText.access$getSyntaxHighlightSpans$p(this.this$0).clear();
                SyntaxHighlightEditText.access$getSyntaxHighlightSpans$p(this.this$0).addAll((Collection)spans);
                SyntaxHighlightEditText.access$updateSyntaxHighlighting(this.this$0);
            }
        }));
        if (stylingTask != null) {
            stylingTask.execute();
        }
    }

    private final void cancelSyntaxHighlighting() {
        StylingTask stylingTask = this.task;
        if (stylingTask != null) {
            stylingTask.cancel();
        }
        this.task = null;
    }

    @JvmOverloads
    public SyntaxHighlightEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SyntaxHighlightEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ List access$getSyntaxHighlightSpans$p(SyntaxHighlightEditText $this) {
        return $this.syntaxHighlightSpans;
    }

    public static final /* synthetic */ void access$updateSyntaxHighlighting(SyntaxHighlightEditText $this) {
        $this.updateSyntaxHighlighting();
    }
}

