/*
 * Decompiled with CFR 0.152.
 */
package com.blade.embedd;

import com.blade.Blade;
import com.blade.embedd.EmbedServer;
import com.blade.exception.EmbedServerException;
import com.blade.kit.CollectionKit;
import com.blade.kit.StringKit;
import com.blade.kit.base.Config;
import com.blade.mvc.context.BladeInitListener;
import com.blade.mvc.context.DynamicContext;
import com.blade.mvc.dispatch.AsyncDispatcherServlet;
import com.blade.mvc.dispatch.DispatcherServlet;
import java.io.File;
import java.net.URL;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbedJettyServer
implements EmbedServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbedJettyServer.class);
    private int port = 9000;
    private Server server;
    private String classPath;
    private WebAppContext webAppContext;
    private ServletHolder defaultHolder;

    public EmbedJettyServer() {
        System.setProperty("org.apache.jasper.compiler.disablejsr199", "true");
        if (DynamicContext.isJarContext()) {
            URL url = EmbedJettyServer.class.getResource("/");
            this.classPath = url.getPath();
            LOGGER.info("add classpath: {}", (Object)this.classPath);
        }
        Blade.$().enableServer(true);
    }

    public void startup(int port) throws EmbedServerException {
        this.startup(port, "/", null);
    }

    public void startup(int port, String contextPath) throws EmbedServerException {
        this.startup(port, contextPath, null);
    }

    public void setWebRoot(String webRoot) {
        this.webAppContext.setResourceBase(webRoot);
    }

    public void startup(int port, String contextPath, String webRoot) throws EmbedServerException {
        this.port = port;
        Config config = Blade.$().config();
        int minThreads = config.getInt("server.jetty.min-threads", Integer.valueOf(8));
        int maxThreads = config.getInt("server.jetty.max-threads", Integer.valueOf(200));
        String poolName = config.get("server.jetty.pool-name", "blade-pool");
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(minThreads);
        threadPool.setMaxThreads(maxThreads);
        threadPool.setName(poolName);
        this.server = new Server((ThreadPool)threadPool);
        this.webAppContext = new WebAppContext();
        this.webAppContext.setContextPath(contextPath);
        this.webAppContext.setResourceBase("");
        int securePort = config.getInt("server.jetty.http.secure-port", Integer.valueOf(9443));
        int outputBufferSize = config.getInt("server.jetty.http.output-buffersize", Integer.valueOf(32768));
        int requestHeaderSize = config.getInt("server.jetty.http.request-headersize", Integer.valueOf(8192));
        int responseHeaderSize = config.getInt("server.jetty.http.response-headersize", Integer.valueOf(8192));
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setSecurePort(securePort);
        http_config.setOutputBufferSize(outputBufferSize);
        http_config.setRequestHeaderSize(requestHeaderSize);
        http_config.setResponseHeaderSize(responseHeaderSize);
        long idleTimeout = config.getLong("server.jetty.http.idle-timeout", Long.valueOf(30000L));
        String host = config.get("server.host", "0.0.0.0");
        ServerConnector serverConnector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
        serverConnector.setHost(host);
        serverConnector.setPort(this.port);
        serverConnector.setIdleTimeout(idleTimeout);
        this.server.setConnectors(new Connector[]{serverConnector});
        boolean isAsync = config.getBoolean("server.async", false);
        Class servlet = isAsync ? AsyncDispatcherServlet.class : DispatcherServlet.class;
        ServletHolder servletHolder = new ServletHolder(servlet);
        servletHolder.setAsyncSupported(isAsync);
        servletHolder.setInitOrder(1);
        this.webAppContext.addEventListener((EventListener)new BladeInitListener());
        Set statics = Blade.$().bConfig().getStatics();
        this.defaultHolder = new ServletHolder(DefaultServlet.class);
        this.defaultHolder.setInitOrder(0);
        if (StringKit.isNotBlank((String)this.classPath)) {
            LOGGER.info("add classpath : {}", (Object)this.classPath);
            this.defaultHolder.setInitParameter("resourceBase", this.classPath);
        }
        statics.forEach(s -> {
            if (s.indexOf(".") != -1) {
                this.webAppContext.addServlet(this.defaultHolder, s);
            } else {
                s = s.endsWith("/") ? s + '*' : s + "/*";
                this.webAppContext.addServlet(this.defaultHolder, s);
            }
        });
        this.webAppContext.addServlet(this.defaultHolder, "/favicon.ico");
        this.webAppContext.addServlet(servletHolder, "/");
        try {
            this.loadServlets(this.webAppContext);
            this.loadFilters(this.webAppContext);
            HandlerList handlerList = new HandlerList();
            handlerList.setHandlers(new Handler[]{this.webAppContext, new DefaultHandler()});
            this.server.setHandler((Handler)handlerList);
            this.server.setStopAtShutdown(true);
            this.server.start();
            LOGGER.info("Blade Server Listen on {}:{}", (Object)host, (Object)this.port);
            this.server.join();
        }
        catch (Exception e) {
            throw new EmbedServerException((Throwable)e);
        }
    }

    public void addStatic(String ... statics) {
        if (null == statics || statics.length < 1 || null == this.webAppContext) {
            return;
        }
        for (String s : statics) {
            if (s.indexOf(".") != -1) {
                this.webAppContext.addServlet(this.defaultHolder, s);
                continue;
            }
            s = s.endsWith("/") ? s + '*' : s + "/*";
            this.webAppContext.addServlet(this.defaultHolder, s);
        }
    }

    public void addServlet(Class<? extends Servlet> servlet, String pathSpec) {
        if (null != servlet) {
            this.webAppContext.addServlet(servlet, pathSpec);
        }
    }

    public void addFilter(Class<? extends Filter> filter, String pathSpec) {
        if (null != filter && StringKit.isNotBlank((String)pathSpec)) {
            this.webAppContext.addFilter(filter, pathSpec, EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.INCLUDE));
        }
    }

    public void hotSwap(int scanInterval, String resBase) throws Exception {
        Scanner scanner = new Scanner();
        scanner.setScanInterval(scanInterval);
        scanner.addScanDir(new File(resBase));
        scanner.addListener((Scanner.Listener)((Scanner.BulkListener)fileNames -> {
            this.webAppContext.stop();
            this.webAppContext.setResourceBase(resBase);
            this.webAppContext.start();
            this.webAppContext.getHandler().start();
        }));
        LOGGER.info("Hot Swap scan interval is {}s.", (Object)scanInterval);
        scanner.start();
    }

    public void loadFilters(WebAppContext webAppContext) throws Exception {
        Map filters = Blade.$().filters();
        if (CollectionKit.isNotEmpty((Map)filters)) {
            Set entrySet = filters.entrySet();
            for (Map.Entry entry : entrySet) {
                String[] pathSpecs;
                Class filterClazz = (Class)entry.getKey();
                for (String pathSpec : pathSpecs = (String[])entry.getValue()) {
                    webAppContext.addFilter(filterClazz, pathSpec, EnumSet.of(DispatcherType.REQUEST));
                }
            }
        }
    }

    public void loadServlets(WebAppContext webAppContext) throws Exception {
        Map servlets = Blade.$().servlets();
        if (CollectionKit.isNotEmpty((Map)servlets)) {
            Set entrySet = servlets.entrySet();
            for (Map.Entry entry : entrySet) {
                String[] pathSpecs;
                Class servletClazz = (Class)entry.getKey();
                for (String pathSpec : pathSpecs = (String[])entry.getValue()) {
                    webAppContext.addServlet(servletClazz, pathSpec);
                }
            }
        }
    }

    public void shutdown() throws EmbedServerException {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new EmbedServerException((Throwable)e);
        }
    }

    public void join() throws EmbedServerException {
        try {
            this.server.join();
        }
        catch (InterruptedException e) {
            throw new EmbedServerException((Throwable)e);
        }
    }
}

