/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import com.blade.exception.BeanCopyException;
import com.blade.kit.ReflectKit;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class BeanKit {
    public static <T> T copy(Object origin, Class<T> destCls) {
        Object dest = ReflectKit.newInstance(destCls);
        BeanKit.copy(origin, dest);
        return dest;
    }

    public static void copy(Object origin, Object dest) {
        ArrayList<Field> fields = new ArrayList<Field>();
        try {
            Class<?> c1 = origin.getClass();
            Class<?> c2 = dest.getClass();
            Class<?> c1Superclass = c1.getSuperclass();
            Class<?> c2Superclass = c2.getSuperclass();
            ArrayList<Field> fs1 = new ArrayList<Field>(Arrays.asList(c1.getDeclaredFields()));
            while (!c1Superclass.equals(Object.class)) {
                List<Field> parentFields = Arrays.asList(c1Superclass.getDeclaredFields());
                fs1.addAll(parentFields);
                c1Superclass = c1Superclass.getSuperclass();
            }
            ArrayList<Field> fs2 = new ArrayList<Field>(Arrays.asList(c2.getDeclaredFields()));
            while (!c2Superclass.equals(Object.class)) {
                List<Field> parentFields = Arrays.asList(c2Superclass.getDeclaredFields());
                fs2.addAll(parentFields);
                c2Superclass = c2Superclass.getSuperclass();
            }
            block6: for (Field aFs2 : fs2) {
                for (Field aFs1 : fs1) {
                    if (!aFs1.getName().equals(aFs2.getName())) continue;
                    fields.add(aFs1);
                    continue block6;
                }
            }
            if (fields.size() > 0) {
                for (Field f : fields) {
                    String fileName = f.getName();
                    String str = fileName.substring(0, 1).toUpperCase();
                    String getName = "get" + str + fileName.substring(1);
                    String setName = "set" + str + fileName.substring(1);
                    try {
                        Object o;
                        Method getMethod = c1.getMethod(getName, new Class[0]);
                        Method setMethod = c2.getMethod(setName, f.getType());
                        if (null == getMethod || null == setMethod || null == (o = getMethod.invoke(origin, new Object[0]))) continue;
                        setMethod.invoke(dest, o);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
            }
        }
        catch (Exception e) {
            throw new BeanCopyException(e);
        }
    }

    private BeanKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

