/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.exception.BladeException;
import com.blade.exception.NotFoundException;
import com.blade.kit.BladeCache;
import com.blade.kit.BladeKit;
import com.blade.mvc.RouteContext;
import com.blade.mvc.WebContext;
import com.blade.mvc.handler.ExceptionHandler;
import com.blade.mvc.http.HttpMethod;
import com.blade.mvc.http.HttpRequest;
import com.blade.mvc.http.HttpResponse;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.blade.mvc.route.Route;
import com.blade.mvc.route.RouteMatcher;
import com.blade.server.netty.RouteMethodHandler;
import com.blade.server.netty.StaticFileHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.GenericFutureListener;
import java.time.Instant;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpServerHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(HttpServerHandler.class);
    public static final FastThreadLocal<WebContext> WEB_CONTEXT_THREAD_LOCAL = new FastThreadLocal();
    private final boolean ALLOW_COST = WebContext.blade().environment().getBoolean("http.request.cost", true);
    public static final boolean PERFORMANCE = WebContext.blade().environment().getBoolean("server.performance", false);
    private final StaticFileHandler staticFileHandler = new StaticFileHandler(WebContext.blade());
    private final RouteMethodHandler routeHandler = new RouteMethodHandler();
    private final Set<String> notStaticUri = new HashSet<String>(32);
    private final RouteMatcher routeMatcher = WebContext.blade().routeMatcher();

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest httpRequest) {
        CompletableFuture<HttpRequest> future = CompletableFuture.completedFuture(httpRequest);
        EventExecutor executor = ctx.executor();
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)future.thenApplyAsync(req -> this.buildWebContext(ctx, (HttpRequest)req), (Executor)executor)).thenApplyAsync(this::executeLogic, (Executor)executor)).thenApplyAsync(this::buildResponse, (Executor)executor)).exceptionally(this::handleException)).thenAcceptAsync(msg -> this.writeResponse(ctx, future, (FullHttpResponse)msg), (Executor)ctx.channel().eventLoop());
    }

    private WebContext buildWebContext(ChannelHandlerContext ctx, HttpRequest req) {
        String remoteAddress = ctx.channel().remoteAddress().toString();
        req.init(remoteAddress);
        return WebContext.create(req, new HttpResponse(), ctx);
    }

    private void writeResponse(ChannelHandlerContext ctx, CompletableFuture<HttpRequest> future, FullHttpResponse msg) {
        ctx.writeAndFlush((Object)msg);
        future.complete(null);
    }

    private FullHttpResponse handleException(Throwable e) {
        Request request = WebContext.request();
        Response response = WebContext.response();
        String method = request.method();
        String uri = request.uri();
        Exception srcException = (Exception)e.getCause().getCause();
        if (!(srcException instanceof BladeException)) {
            BladeKit.log500(log, method, uri);
        }
        if (null != WebContext.blade().exceptionHandler()) {
            WebContext.blade().exceptionHandler().handle(srcException);
        } else {
            log.error("", (Throwable)srcException);
        }
        return this.routeHandler.handleResponse(request, response, WebContext.get().getChannelHandlerContext());
    }

    private FullHttpResponse buildResponse(WebContext webContext) {
        WebContext.set(webContext);
        return this.routeHandler.handleResponse(webContext.getRequest(), webContext.getResponse(), webContext.getChannelHandlerContext());
    }

    private WebContext executeLogic(WebContext webContext) {
        try {
            WebContext.set(webContext);
            Request request = webContext.getRequest();
            String method = request.method();
            String uri = request.uri();
            Instant start = null;
            if (this.ALLOW_COST && !PERFORMANCE) {
                start = Instant.now();
            }
            if (this.isStaticFile(method, uri)) {
                this.staticFileHandler.handle(webContext);
            } else {
                if (HttpMethod.OPTIONS.name().equals(method) && null != WebContext.blade().corsMiddleware()) {
                    WebContext.blade().corsMiddleware().handle(new RouteContext(webContext.getRequest(), webContext.getResponse()));
                } else {
                    Route route = this.routeMatcher.lookupRoute(method, uri);
                    if (null == route) {
                        throw new NotFoundException(uri);
                    }
                    webContext.setRoute(route);
                    this.routeHandler.handle(webContext);
                }
                if (PERFORMANCE) {
                    return webContext;
                }
                if (this.ALLOW_COST) {
                    long cost = BladeKit.log200AndCost(log, start, BladeCache.getPaddingMethod(method), uri);
                    request.attribute("costTime", cost);
                } else {
                    BladeKit.log200(log, BladeCache.getPaddingMethod(method), uri);
                }
            }
            return webContext;
        }
        catch (Exception e) {
            throw BladeException.wrapper(e);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!ExceptionHandler.isResetByPeer(cause)) {
            log.error(cause.getMessage(), cause);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)500));
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private boolean isStaticFile(String method, String uri) {
        if (HttpMethod.POST.name().equals(method) || this.notStaticUri.contains(uri)) {
            return false;
        }
        Optional<String> result = WebContext.blade().getStatics().stream().filter(s -> s.equals(uri) || uri.startsWith((String)s)).findFirst();
        if (!result.isPresent()) {
            this.notStaticUri.add(uri);
            return false;
        }
        return true;
    }
}

