/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class AsmKit {
    private static final Map<Method, String[]> METHOD_NAMES_POOL = new ConcurrentHashMap<Method, String[]>(64);

    private static boolean sameType(Type[] types, Class<?>[] classes) {
        if (types.length != classes.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (Type.getType(classes[i]).equals((Object)types[i])) continue;
            return false;
        }
        return true;
    }

    public static String[] getMethodParamNames(final Method m) {
        ClassReader cr;
        if (METHOD_NAMES_POOL.containsKey(m)) {
            return METHOD_NAMES_POOL.get(m);
        }
        final String[] paramNames = new String[m.getParameterTypes().length];
        String n = m.getDeclaringClass().getName();
        try {
            cr = new ClassReader(n);
        }
        catch (IOException e) {
            return null;
        }
        cr.accept(new ClassVisitor(327680){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                Type[] args = Type.getArgumentTypes((String)desc);
                if (!name.equals(m.getName()) || !AsmKit.sameType(args, m.getParameterTypes())) {
                    return super.visitMethod(access, name, desc, signature, exceptions);
                }
                MethodVisitor v = super.visitMethod(access, name, desc, signature, exceptions);
                return new MethodVisitor(327680, v){

                    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                        int i = index - 1;
                        if (Modifier.isStatic(m.getModifiers())) {
                            i = index;
                        }
                        if (i >= 0 && i < paramNames.length) {
                            paramNames[i] = name;
                        }
                        super.visitLocalVariable(name, desc, signature, start, end, index);
                    }
                };
            }
        }, 0);
        METHOD_NAMES_POOL.put(m, paramNames);
        return paramNames;
    }

    private AsmKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

