/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import com.blade.kit.CollectionKit;
import com.blade.mvc.multipart.MimeType;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Stream;

public final class StringKit {
    private static final Random RANDOM = new Random();
    private static final char SEPARATOR = '_';

    public static int rand(int min, int max) {
        return RANDOM.nextInt(max) % (max - min + 1) + min;
    }

    public static String rand(int size) {
        StringBuilder num = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            double a = Math.random() * 9.0;
            a = Math.ceil(a);
            int randomNum = new Double(a).intValue();
            num.append(randomNum);
        }
        return num.toString();
    }

    public static boolean isNotBlank(String ... str) {
        if (str == null) {
            return false;
        }
        for (String s : str) {
            if (!StringKit.isBlank(s)) continue;
            return false;
        }
        return true;
    }

    public static void isNotBlankThen(String str, Consumer<String> consumer) {
        if (!StringKit.isBlank(str)) {
            consumer.accept(str);
        }
    }

    public static boolean isBlank(String str) {
        return null == str || "".equals(str.trim());
    }

    public static boolean isEmpty(String str) {
        return null == str || str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !StringKit.isEmpty(str);
    }

    public static void isBlankThen(String str, Consumer<String> consumer) {
        if (StringKit.isBlank(str)) {
            consumer.accept(str);
        }
    }

    public static boolean isAnyBlank(String ... values) {
        if (CollectionKit.isEmpty(values)) {
            return true;
        }
        return Stream.of(values).filter(StringKit::isBlank).count() == (long)values.length;
    }

    public static boolean isNumber(String value) {
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static String alignLeft(Object o, int width, char c) {
        if (null == o) {
            return null;
        }
        String s = o.toString();
        int length = s.length();
        if (length >= width) {
            return s;
        }
        return s + StringKit.dup(c, width - length);
    }

    public static String alignRight(Object o, int width, char c) {
        if (null == o) {
            return null;
        }
        String s = o.toString();
        int len = s.length();
        if (len >= width) {
            return s;
        }
        return StringKit.dup(c, width - len) + s;
    }

    public static String dup(char c, int num) {
        if (c == '\u0000' || num < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder(num);
        for (int i = 0; i < num; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String fileExt(String fname) {
        if (StringKit.isBlank(fname) || fname.indexOf(46) == -1) {
            return null;
        }
        return fname.substring(fname.lastIndexOf(46) + 1);
    }

    public static String mimeType(String fileName) {
        String ext = StringKit.fileExt(fileName);
        if (null == ext) {
            return null;
        }
        return MimeType.get(ext);
    }

    public static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    public static String padLeft(String s, int n) {
        return String.format("%1$" + n + "s", s);
    }

    public static boolean equals(String str1, String str2) {
        if (null == str1) {
            return false;
        }
        return str1.equals(str2);
    }

    public static String toUnderlineName(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            boolean nextUpperCase = true;
            if (i < s.length() - 1) {
                nextUpperCase = Character.isUpperCase(s.charAt(i + 1));
            }
            if (Character.isUpperCase(c)) {
                if (!(upperCase && nextUpperCase || i <= 0)) {
                    sb.append('_');
                }
                upperCase = true;
            } else {
                upperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String toCamelCase(String s) {
        if (s == null) {
            return null;
        }
        s = s.toLowerCase();
        StringBuilder sb = new StringBuilder(s.length());
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toCapitalizeCamelCase(String s) {
        if (s == null) {
            return null;
        }
        s = StringKit.toCamelCase(s);
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private StringKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

